/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.text.Collator;
import java.util.Iterator;
import java.util.Properties;
import org.exist.EXistException;
import org.exist.dom.DocumentSet;
import org.exist.dom.EmptyNodeSet;
import org.exist.dom.NodeSet;
import org.exist.dom.StoredNode;
import org.exist.memtree.DocumentBuilderReceiver;
import org.exist.numbering.NodeId;
import org.exist.storage.DBBroker;
import org.exist.storage.Indexable;
import org.exist.storage.ValueIndexFactory;
import org.exist.xquery.XPathException;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SingleItemIterator;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AtomicValue
implements Item,
Sequence,
Indexable {
    public static final AtomicValue EMPTY_VALUE = new EmptyValue();

    public int getType() {
        return 20;
    }

    public abstract String getStringValue() throws XPathException;

    public abstract boolean compareTo(Collator var1, int var2, AtomicValue var3) throws XPathException;

    public abstract int compareTo(Collator var1, AtomicValue var2) throws XPathException;

    public abstract AtomicValue max(Collator var1, AtomicValue var2) throws XPathException;

    public abstract AtomicValue min(Collator var1, AtomicValue var2) throws XPathException;

    public boolean startsWith(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("Cannot call starts-with on value of type " + Type.getTypeName(this.getType()));
    }

    public boolean endsWith(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("Cannot call ends-with on value of type " + Type.getTypeName(this.getType()));
    }

    public boolean contains(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("Cannot call contains on value of type " + Type.getTypeName(this.getType()));
    }

    public int getItemCount() {
        return 1;
    }

    public int getCardinality() {
        return 2;
    }

    public void removeDuplicates() {
    }

    public SequenceIterator iterate() throws XPathException {
        return new SingleItemIterator(this);
    }

    public SequenceIterator unorderedIterator() {
        return new SingleItemIterator(this);
    }

    public int getItemType() {
        return this.getType();
    }

    public Item itemAt(int pos) {
        return pos > 0 ? null : this;
    }

    public Sequence toSequence() {
        return this;
    }

    public void toSAX(DBBroker broker, ContentHandler handler, Properties properties) throws SAXException {
        try {
            String s = this.getStringValue();
            handler.characters(s.toCharArray(), 0, s.length());
        }
        catch (XPathException e) {
            throw new SAXException(e);
        }
    }

    public void copyTo(DBBroker broker, DocumentBuilderReceiver receiver) throws SAXException {
        try {
            String s = this.getStringValue();
            receiver.characters(s);
        }
        catch (XPathException e) {
            throw new SAXException(e);
        }
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean hasOne() {
        return true;
    }

    public boolean hasMany() {
        return false;
    }

    public void add(Item item) throws XPathException {
    }

    public void addAll(Sequence other) throws XPathException {
    }

    public AtomicValue atomize() throws XPathException {
        return this;
    }

    public abstract boolean effectiveBooleanValue() throws XPathException;

    public NodeSet toNodeSet() throws XPathException {
        throw new XPathException("cannot convert " + Type.getTypeName(this.getType()) + "('" + this.getStringValue() + "')" + " to a node set");
    }

    public DocumentSet getDocumentSet() {
        return DocumentSet.EMPTY_DOCUMENT_SET;
    }

    public Iterator getCollectionIterator() {
        return EmptyNodeSet.EMPTY_ITERATOR;
    }

    public AtomicValue promote(AtomicValue otherValue) throws XPathException {
        if (this.getType() != otherValue.getType()) {
            if (Type.subTypeOf(this.getType(), 32) && (Type.subTypeOf(otherValue.getType(), 34) || Type.subTypeOf(otherValue.getType(), 33))) {
                return this.convertTo(otherValue.getType());
            }
            if (Type.subTypeOf(this.getType(), 33) && Type.subTypeOf(otherValue.getType(), 34)) {
                return this.convertTo(34);
            }
            if (Type.subTypeOf(this.getType(), 25) && Type.subTypeOf(otherValue.getType(), 22)) {
                return this.convertTo(22);
            }
        }
        return this;
    }

    public void dump(ExpressionDumper dumper) {
        try {
            dumper.display(this.getStringValue());
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
    }

    public int conversionPreference(Class javaClass) {
        return Integer.MAX_VALUE;
    }

    public Object toJavaObject(Class target) throws XPathException {
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }

    public String toString() {
        try {
            return this.getStringValue();
        }
        catch (XPathException e) {
            return super.toString();
        }
    }

    public boolean isCached() {
        return false;
    }

    public void setIsCached(boolean cached) {
    }

    public void clearContext(int contextId) {
    }

    public void setSelfAsContext(int contextId) {
    }

    public boolean isPersistentSet() {
        return false;
    }

    public void nodeMoved(NodeId oldNodeId, StoredNode newNode) {
    }

    public byte[] serializeValue(int offset) throws EXistException {
        return ValueIndexFactory.serialize(this, offset);
    }

    public int compareTo(Object other) {
        throw new IllegalArgumentException("Invalid call to compareTo by " + Type.getTypeName(this.getItemType()));
    }

    public int getState() {
        return 0;
    }

    public boolean hasChanged(int previousState) {
        return false;
    }

    public boolean isCacheable() {
        return true;
    }

    private static final class EmptyValue
    extends AtomicValue {
        private EmptyValue() {
        }

        public boolean isEmpty() {
            return true;
        }

        public String getStringValue() {
            return "";
        }

        public AtomicValue convertTo(int requiredType) throws XPathException {
            switch (requiredType) {
                case 11: 
                case 20: 
                case 22: {
                    return StringValue.EMPTY_STRING;
                }
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: {
                    return new StringValue("", requiredType);
                }
                case 25: {
                    return AnyURIValue.EMPTY_URI;
                }
                case 23: {
                    return BooleanValue.FALSE;
                }
            }
            throw new XPathException("cannot convert empty value to " + requiredType);
        }

        public boolean effectiveBooleanValue() throws XPathException {
            return false;
        }

        public int compareTo(Collator collator, AtomicValue other) throws XPathException {
            if (other instanceof EmptyValue) {
                return 0;
            }
            return -1;
        }

        public boolean compareTo(Collator collator, int operator, AtomicValue other) throws XPathException {
            return false;
        }

        public Item itemAt(int pos) {
            return null;
        }

        public Sequence toSequence() {
            return this;
        }

        public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
            return this;
        }

        public void add(Item item) throws XPathException {
        }

        public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
            return this;
        }

        public int conversionPreference(Class javaClass) {
            return Integer.MAX_VALUE;
        }

        public Object toJavaObject(Class target) throws XPathException {
            throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
        }
    }
}

