/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Database;

public class XMLDBRegisterDatabase
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("register-database", "http://exist-db.org/xquery/xmldb", "xmldb"), "Register an XMLDB driver class with the XMLDB Database Manager. This is only required if you want to access a database instance different from the one that executes the XQuery.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(23, 2)}, new SequenceType(23, 2));

    public XMLDBRegisterDatabase(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String driverName = args[0].getStringValue();
        boolean createDatabase = args[1].effectiveBooleanValue();
        try {
            Class<?> driver = Class.forName(driverName);
            Database database = (Database)driver.newInstance();
            database.setProperty("create-database", createDatabase ? "true" : "false");
            DatabaseManager.registerDatabase((Database)database);
        }
        catch (Exception e) {
            LOG.warn((Object)("failed to initiate XMLDB database driver: " + driverName), (Throwable)e);
            return BooleanValue.FALSE;
        }
        return BooleanValue.TRUE;
    }
}

