/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.exist.dom.QName;
import org.exist.memtree.DocumentImpl;
import org.exist.memtree.NodeImpl;
import org.exist.memtree.SAXAdapter;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Parse
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("parse", "http://exist-db.org/xquery/util", "util"), "Parses the passed string value into an XML fragment. The string has to be well-formed XML. An empty sequence is returned if the argument is an empty string or sequence.", new SequenceType[]{new SequenceType(22, 3)}, new SequenceType(-1, 7)), new FunctionSignature(new QName("parse-html", "http://exist-db.org/xquery/util", "util"), "Parses the passed string value into an XML fragment. The HTML string may not be well-formed XML. It will be passed through the Neko HTML parser to make it well-formed. An empty sequence is returned if the argument is an empty string or sequence.", new SequenceType[]{new SequenceType(22, 3)}, new SequenceType(-1, 7))};

    public Parse(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].getItemCount() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String xmlContent = args[0].itemAt(0).getStringValue();
        if (xmlContent.length() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        StringReader reader = new StringReader(xmlContent);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            InputSource src = new InputSource(reader);
            XMLReader xr = null;
            if (this.isCalledAs("parse-html")) {
                try {
                    Class<?> clazz = Class.forName("org.cyberneko.html.parsers.SAXParser");
                    xr = (XMLReader)clazz.newInstance();
                    xr.setProperty("http://cyberneko.org/html/properties/names/elems", "match");
                    xr.setProperty("http://cyberneko.org/html/properties/names/attrs", "no-change");
                }
                catch (Exception e) {
                    LOG.warn((Object)"Could not instantiate neko HTML parser for function util:parse-html, falling back to default XML parser.", (Throwable)e);
                }
            }
            if (xr == null) {
                SAXParser parser = factory.newSAXParser();
                xr = parser.getXMLReader();
            }
            SAXAdapter adapter = new SAXAdapter(this.context);
            xr.setContentHandler(adapter);
            xr.parse(src);
            DocumentImpl doc = (DocumentImpl)adapter.getDocument();
            if (doc.getChildCount() == 1) {
                return (NodeImpl)doc.getFirstChild();
            }
            ValueSequence result = new ValueSequence();
            for (NodeImpl node = (NodeImpl)doc.getFirstChild(); node != null; node = (NodeImpl)node.getNextSibling()) {
                result.add(node);
            }
            return result;
        }
        catch (ParserConfigurationException e) {
            throw new XPathException(this.getASTNode(), "Error while constructing XML parser: " + e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new XPathException(this.getASTNode(), "Error while parsing XML: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XPathException(this.getASTNode(), "Error while parsing XML: " + e.getMessage(), e);
        }
    }
}

