/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.exist.dom.QName;
import org.exist.memtree.MemTreeBuilder;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Module;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.helpers.AttributesImpl;

public class ExtractDocs
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("extract-docs", "http://exist-db.org/xquery/util", "util"), "Returns an XML document which describes the functions available in a given module. The module is identified through its module namespace URI, which is passed as an argument. The function returns a module documentation in XQDoc format.", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(-1, 3));
    private final String XQDOC_NS = "http://www.xqdoc.org/1.0";

    public ExtractDocs(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String moduleURI = args[0].getStringValue();
        Module module = this.context.getModule(moduleURI);
        if (module == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        int nodeNr = builder.startElement("http://www.xqdoc.org/1.0", "xqdoc", "xqdoc", null);
        this.module(module, builder);
        this.functions(module, builder);
        builder.endElement();
        return builder.getDocument().getNode(nodeNr);
    }

    private void functions(Module module, MemTreeBuilder builder) {
        builder.startElement("http://www.xqdoc.org/1.0", "functions", "functions", null);
        FunctionSignature[] functions = module.listFunctions();
        for (int i = 0; i < functions.length; ++i) {
            FunctionSignature function = functions[i];
            builder.startElement("http://www.xqdoc.org/1.0", "function", "function", null);
            this.simpleElement(builder, "name", function.getName().getLocalName());
            this.simpleElement(builder, "signature", function.toString());
            builder.startElement("http://www.xqdoc.org/1.0", "comment", "comment", null);
            this.simpleElement(builder, "description", function.getDescription());
            builder.endElement();
            builder.endElement();
        }
        builder.endElement();
    }

    private void module(Module module, MemTreeBuilder builder) {
        AttributesImpl attribs = new AttributesImpl();
        attribs.addAttribute("", "type", "type", "CDATA", "library");
        builder.startElement("http://www.xqdoc.org/1.0", "module", "module", attribs);
        this.simpleElement(builder, "uri", module.getNamespaceURI());
        builder.startElement("http://www.xqdoc.org/1.0", "comment", "comment", null);
        this.simpleElement(builder, "description", module.getDescription());
        builder.endElement();
        builder.endElement();
    }

    private void simpleElement(MemTreeBuilder builder, String tag, String value) {
        builder.startElement("http://www.xqdoc.org/1.0", tag, tag, null);
        builder.characters(value == null ? "" : value);
        builder.endElement();
    }
}

