/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.net.URISyntaxException;
import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class CollectionName
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("collection-name", "http://exist-db.org/xquery/util", "util"), "Returns the name of the collection from a passed node or path string. If the argument is a node, the function returns the name of the collection to which the node's document belongs. If the argument is a string, it is interpreted as path to a resource and the function returns the computed parent collection path for this resource.", new SequenceType[]{new SequenceType(11, 3)}, new SequenceType(22, 3));

    public CollectionName(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        Item item = args[0].itemAt(0);
        if (item.getType() == 100) {
            Object o = ((JavaObjectValue)item).getObject();
            if (!(o instanceof Collection)) {
                throw new XPathException(this.getASTNode(), "Passed Java object should be of type org.xmldb.api.base.Collection");
            }
            Collection collection = (Collection)o;
            try {
                return new StringValue(collection.getName());
            }
            catch (XMLDBException e) {
                throw new XPathException(this.getASTNode(), "Failed to retrieve collection name", e);
            }
        }
        if (Type.subTypeOf(item.getType(), 22)) {
            String path = item.getStringValue();
            try {
                XmldbURI uri = XmldbURI.xmldbUriFor(path).removeLastSegment();
                return new StringValue(uri.toString());
            }
            catch (URISyntaxException e) {
                throw new XPathException(this.getASTNode(), "Illegal URI for resource path: " + path);
            }
        }
        if (Type.subTypeOf(item.getType(), -1)) {
            NodeValue node = (NodeValue)item;
            if (node.getImplementationType() == 1) {
                NodeProxy p = (NodeProxy)node;
                return new StringValue(p.getDocument().getCollection().getURI().toString());
            }
        } else {
            throw new XPathException(this.getASTNode(), "First argument to util:collection-name should be either a Java object of type org.xmldb.api.base.Collection or a node; got: " + Type.getTypeName(item.getType()));
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

