/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.net.URISyntaxException;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.dom.QName;
import org.exist.security.PermissionDeniedException;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Base64Binary;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class BinaryDoc
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("binary-doc", "http://exist-db.org/xquery/util", "util"), "Retrieves the binary resource identified by $a and returns its contents as a value of type xs:base64Binary. An empty sequence is returned if the resource could not be found or $a was empty.", new SequenceType[]{new SequenceType(22, 3)}, new SequenceType(26, 3)), new FunctionSignature(new QName("binary-doc-available", "http://exist-db.org/xquery/util", "util"), "Checks if the binary resource identified by $a is available.", new SequenceType[]{new SequenceType(22, 3)}, new SequenceType(23, 2))};

    public BinaryDoc(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence defaultReturn;
        Sequence sequence = defaultReturn = this.isCalledAs("binary-doc") ? Sequence.EMPTY_SEQUENCE : BooleanValue.FALSE;
        if (args[0].isEmpty()) {
            return defaultReturn;
        }
        String path = args[0].getStringValue();
        DocumentImpl doc = null;
        try {
            doc = this.context.getBroker().getXMLResource(XmldbURI.xmldbUriFor(path), 0);
            if (doc == null) {
                Sequence sequence2 = defaultReturn;
                return sequence2;
            }
            if (doc.getResourceType() != 1) {
                Sequence sequence3 = defaultReturn;
                return sequence3;
            }
            if (this.isCalledAs("binary-doc")) {
                BinaryDocument bin = (BinaryDocument)doc;
                byte[] data = this.context.getBroker().getBinaryResource(bin);
                Base64Binary base64Binary = new Base64Binary(data);
                return base64Binary;
            }
            BooleanValue bin = BooleanValue.TRUE;
            return bin;
        }
        catch (URISyntaxException e) {
            throw new XPathException(this.getASTNode(), "Invalid resource uri", e);
        }
        catch (PermissionDeniedException e) {
            throw new XPathException(this.getASTNode(), path + ": permission denied to read resource");
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(0);
            }
        }
    }
}

