/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.text;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.exist.collections.Collection;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.IndexSpec;
import org.exist.util.Occurrences;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class IndexTerms
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("index-terms", "http://exist-db.org/xquery/text", "text"), "This function can be used to collect some information on the distribution of index terms within a set of nodes. The set of nodes is specified in the first argument $a. The function returns term frequencies for all terms in the index found in descendants of the nodes in $a. The second argument $b specifies a start string. Only terms starting with the specified character sequence are returned. If $a is the empty sequence, all terms in the index will be selected. $c is a function reference, which points to a callback function that will be called for every term occurrence. $d defines the maximum number of terms that should be reported. The function reference for $c can be created with the util:function function. It can be an arbitrary user-defined function, but it should take exactly 2 arguments: 1) the current term as found in the index as xs:string, 2) a sequence containing four int values: a) the overall frequency of the term within the node set, b) the number of distinct documents in the node set the term occurs in, c) the current position of the term in the whole list of terms returned, d) the rank of the current term in the whole list of terms returned.", new SequenceType[]{new SequenceType(-1, 7), new SequenceType(22, 3), new SequenceType(101, 2), new SequenceType(38, 2)}, new SequenceType(11, 7)), new FunctionSignature(new QName("index-terms", "http://exist-db.org/xquery/text", "text"), "This version of the index-terms function is to be used with indexes that were defined on a specific element or attribute QName. The second argument lists the QNames or elements or attributes for which occurrences should bereturned. Otherwise, the function behaves like the 4-argument version.", new SequenceType[]{new SequenceType(-1, 7), new SequenceType(24, 6), new SequenceType(22, 3), new SequenceType(101, 2), new SequenceType(38, 2)}, new SequenceType(11, 7))};

    public IndexTerms(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        int arg = 0;
        if (args[arg].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        NodeSet nodes = args[arg++].toNodeSet();
        DocumentSet docs = nodes.getDocumentSet();
        QName[] qnames = null;
        if (args.length == 5) {
            qnames = new QName[args[arg].getItemCount()];
            int q = 0;
            SequenceIterator i = args[arg].iterate();
            while (i.hasNext()) {
                QNameValue qnv = (QNameValue)i.nextItem();
                qnames[q] = qnv.getQName();
                ++q;
            }
            ++arg;
        } else {
            qnames = this.getDefinedIndexes(this.context.getBroker(), docs);
        }
        String start = null;
        if (!args[arg].isEmpty()) {
            start = args[arg].getStringValue();
        }
        FunctionReference ref = (FunctionReference)args[++arg].itemAt(0);
        int max = ((IntegerValue)args[++arg].itemAt(0)).getInt();
        FunctionCall call = ref.getFunctionCall();
        ValueSequence result = new ValueSequence();
        try {
            int j;
            Occurrences[] occur = this.context.getBroker().getTextEngine().scanIndexTerms(docs, nodes, qnames, start, null);
            if (args.length == 4) {
                Occurrences[] occur2 = this.context.getBroker().getTextEngine().scanIndexTerms(docs, nodes, start, null);
                if (occur == null || occur.length == 0) {
                    occur = occur2;
                } else {
                    Occurrences[] t = new Occurrences[occur.length + occur2.length];
                    System.arraycopy(occur, 0, t, 0, occur.length);
                    System.arraycopy(occur2, 0, t, occur.length, occur2.length);
                    occur = t;
                }
            }
            int len = occur.length > max ? max : occur.length;
            Sequence[] params = new Sequence[2];
            ValueSequence data = new ValueSequence();
            Vector<Integer> list = new Vector<Integer>(len);
            for (int j2 = 0; j2 < len; ++j2) {
                if (list.contains(new Integer(occur[j2].getOccurrences()))) continue;
                list.add(new Integer(occur[j2].getOccurrences()));
            }
            Collections.sort(list);
            Collections.reverse(list);
            HashMap map = new HashMap(list.size() * 2);
            for (j = 0; j < list.size(); ++j) {
                map.put(list.get(j), new Integer(j + 1));
            }
            for (j = 0; j < len; ++j) {
                params[0] = new StringValue(occur[j].getTerm().toString());
                data.add(new IntegerValue(occur[j].getOccurrences(), 43));
                data.add(new IntegerValue(occur[j].getDocuments(), 43));
                data.add(new IntegerValue(j + 1, 43));
                data.add(new IntegerValue(((Integer)map.get(new Integer(occur[j].getOccurrences()))).intValue(), 43));
                params[1] = data;
                result.addAll(call.evalFunction(contextSequence, null, params));
                data.clear();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Returning: " + result.getItemCount()));
            }
            return result;
        }
        catch (PermissionDeniedException e) {
            throw new XPathException(this.getASTNode(), e.getMessage(), e);
        }
    }

    private QName[] getDefinedIndexes(DBBroker broker, DocumentSet docs) {
        HashSet<QName> indexes = new HashSet<QName>();
        Iterator i = docs.getCollectionIterator();
        while (i.hasNext()) {
            Collection collection = (Collection)i.next();
            IndexSpec idxConf = collection.getIndexConfiguration(broker);
            if (idxConf == null) continue;
            List qnames = idxConf.getIndexedQNames();
            for (int j = 0; j < qnames.size(); ++j) {
                QName qName = (QName)qnames.get(j);
                indexes.add(qName);
            }
        }
        QName[] qnames = new QName[indexes.size()];
        return indexes.toArray(qnames);
    }
}

