/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.FunStringToCodepoints;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class FunTranslate
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("translate", "http://www.w3.org/2005/xpath-functions"), "Returns the value of $a modified so that every character in the value of $a that occurs at some position N in the value of $b has been replaced by the character that occurs at position N in the value of $c. If the value of $a is the empty sequence, the zero-length string is returned.", new SequenceType[]{new SequenceType(22, 3), new SequenceType(22, 2), new SequenceType(22, 2)}, new SequenceType(22, 2));

    public FunTranslate(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        StringValue result;
        Sequence seq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((seq = this.getArgument(0).eval(contextSequence)).isEmpty()) {
            result = StringValue.EMPTY_STRING;
        } else {
            ValueSequence arg = FunStringToCodepoints.getCodePoints(seq.getStringValue());
            ValueSequence mapStr = FunStringToCodepoints.getCodePoints(this.getArgument(1).eval(contextSequence).getStringValue());
            ValueSequence transStr = FunStringToCodepoints.getCodePoints(this.getArgument(2).eval(contextSequence).getStringValue());
            StringBuffer buf = new StringBuffer(arg.getItemCount());
            for (int i = 0; i < arg.getItemCount(); ++i) {
                IntegerValue ch = (IntegerValue)arg.itemAt(i);
                int p = FunStringToCodepoints.indexOf(mapStr, ch);
                if (p == -1) {
                    buf.append(FunStringToCodepoints.codePointToString(ch));
                    continue;
                }
                if (p >= transStr.getItemCount()) continue;
                buf.append(FunStringToCodepoints.codePointToString((IntegerValue)transStr.itemAt(p)));
            }
            result = new StringValue(buf.toString());
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

