/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.dom.QNameable;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.w3c.dom.Node;

public class FunNodeName
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("node-name", "http://www.w3.org/2005/xpath-functions"), "Returns an expanded-QName for node kinds that can have names. For other kinds of nodes it returns the empty sequence. If $a is the empty sequence, the empty sequence is returned.", new SequenceType[]{new SequenceType(-1, 3)}, new SequenceType(24, 3));

    public FunNodeName(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        Sequence seq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((seq = this.getArgument(0).eval(contextSequence, contextItem)).isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            QName qn;
            Item item = seq.itemAt(0);
            if (!Type.subTypeOf(item.getType(), -1)) {
                throw new XPathException(this.getASTNode(), "XPTY0004: item is not a node; got '" + Type.getTypeName(item.getType()) + "'");
            }
            Node n = ((NodeValue)item).getNode();
            result = n instanceof QNameable ? ((qn = ((QNameable)((Object)n)).getQName()).equalsSimple(QName.EMPTY_QNAME) ? Sequence.EMPTY_SEQUENCE : new QNameValue(this.context, qn)) : Sequence.EMPTY_SEQUENCE;
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

