/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.text.Collator;
import org.exist.dom.QName;
import org.exist.util.Collations;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.CollatingFunction;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.FloatValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class FunMin
extends CollatingFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("min", "http://www.w3.org/2005/xpath-functions"), "Selects an item from the input sequence $a whose value is less than or equal to the value of every other item in the input sequence.", new SequenceType[]{new SequenceType(20, 7)}, new SequenceType(20, 3)), new FunctionSignature(new QName("min", "http://www.w3.org/2005/xpath-functions"), "Selects an item from the input sequence $a whose value is less than or equal to the value of every other item in the input sequence. The collation specified in $b is used for string comparisons.", new SequenceType[]{new SequenceType(20, 7), new SequenceType(22, 2)}, new SequenceType(20, 3))};

    public FunMin(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        boolean computableProcessing = false;
        Sequence arg = this.getArgument(0).eval(contextSequence, contextItem);
        if (arg.isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            Collator collator = this.getCollator(contextSequence, contextItem, 2);
            SequenceIterator iter = arg.unorderedIterator();
            AtomicValue min = null;
            while (iter.hasNext()) {
                Item item = iter.nextItem();
                if (item instanceof QNameValue) {
                    throw new XPathException(this.getASTNode(), "FORG0006: Cannot compare " + Type.getTypeName(item.getType()));
                }
                AtomicValue value = item.atomize();
                if (value.getType() == 21) {
                    value = value.convertTo(34);
                }
                if (min == null) {
                    min = value;
                    continue;
                }
                if (Type.getCommonSuperType(min.getType(), value.getType()) == 20) {
                    throw new XPathException(this.getASTNode(), "FORG0006: Cannot compare " + Type.getTypeName(min.getType()) + " and " + Type.getTypeName(value.getType()));
                }
                if (value.getType() == 20) {
                    value = value.convertTo(34);
                }
                if (Type.subTypeOf(value.getType(), 30)) {
                    if (!Type.subTypeOf(min.getType(), 30)) {
                        throw new XPathException(this.getASTNode(), "FORG0006: Cannot compare " + Type.getTypeName(min.getType()) + " and " + Type.getTypeName(value.getType()));
                    }
                    if (((NumericValue)value).isNaN()) {
                        if ((value = value.promote(min)).getType() == 33) {
                            min = FloatValue.NaN;
                            continue;
                        }
                        min = DoubleValue.NaN;
                        continue;
                    }
                    min = min.promote(value);
                }
                if (value instanceof ComputableValue) {
                    if (!(min instanceof ComputableValue)) {
                        throw new XPathException(this.getASTNode(), "FORG0006: Cannot compare " + Type.getTypeName(min.getType()) + " and " + Type.getTypeName(value.getType()));
                    }
                    value = value.promote(min);
                    min = min.min(collator, value);
                    computableProcessing = true;
                    continue;
                }
                if (computableProcessing) {
                    throw new XPathException(this.getASTNode(), "FORG0006: Cannot compare " + Type.getTypeName(min.getType()) + " and " + Type.getTypeName(value.getType()));
                }
                if (Collations.compare(collator, value.getStringValue(), min.getStringValue()) >= 0) continue;
                min = value;
            }
            result = min;
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

