/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.util.UTF8;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class FunEscapeURI
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("escape-uri", "http://www.w3.org/2005/xpath-functions"), "This function applies the URI escaping rules defined in section 2 of [RFC 2396] as amended by [RFC 2732], with one exception, to the string supplied as $a, which typically represents all or part of a URI. The effect of the function is to escape a set of identified characters in the string. Each such character is replaced in the string by an escape sequence, which is formed by encoding the character as a sequence of octets in UTF-8, and then representing each of these octets in the form %HH, where HH is the hexadecimal representation of the octet. $b indicates whether to escape reserved characters.", new SequenceType[]{new SequenceType(22, 3), new SequenceType(23, 2)}, new SequenceType(22, 2));
    private static final String hex = "0123456789ABCDEF";

    public FunEscapeURI(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        if (!args[0].isEmpty()) {
            String uri = args[0].getStringValue();
            boolean escapeReserved = args[1].effectiveBooleanValue();
            return new StringValue(FunEscapeURI.escape(uri, escapeReserved));
        }
        StringValue result = StringValue.EMPTY_STRING;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public static String escape(CharSequence s, boolean escapeReserved) {
        StringBuffer sb = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                sb.append(c);
                continue;
            }
            if (c <= ' ' || c >= '\u007f') {
                FunEscapeURI.escapeChar(c, i + 1 < s.length() ? s.charAt(i + 1) : (char)' ', sb);
                continue;
            }
            if (escapeReserved) {
                if ("-_.!~*'()%".indexOf(c) >= 0) {
                    sb.append(c);
                    continue;
                }
                FunEscapeURI.escapeChar(c, ' ', sb);
                continue;
            }
            if ("-_.!~*'()%;/?:@&=+$,#[]".indexOf(c) >= 0) {
                sb.append(c);
                continue;
            }
            FunEscapeURI.escapeChar(c, ' ', sb);
        }
        return sb.toString();
    }

    private static void escapeChar(char c, char c2, StringBuffer sb) {
        byte[] array = new byte[4];
        int used = UTF8.getUTF8Encoding(c, c2, array);
        for (int b = 0; b < used; ++b) {
            int v = array[b] >= 0 ? array[b] : 256 + array[b];
            sb.append('%');
            sb.append(hex.charAt(v / 16));
            sb.append(hex.charAt(v % 16));
        }
    }
}

