/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.memtree.DocumentImpl;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunDocumentURI
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("document-uri", "http://www.w3.org/2005/xpath-functions"), "Returns the absolute URI of the resource from which the document node $a was constructed, if none such URI exists returns the empty sequence. If $a is the empty sequence, returns the empty sequence.", new SequenceType[]{new SequenceType(-1, 3)}, new SequenceType(25, 3));

    public FunDocumentURI(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        Sequence seq = this.getArgument(0).eval(contextSequence, contextItem);
        Sequence result = Sequence.EMPTY_SEQUENCE;
        if (!seq.isEmpty()) {
            NodeValue value = (NodeValue)seq.itemAt(0);
            if (value.getImplementationType() == 1) {
                NodeProxy node = (NodeProxy)value;
                if (node.isDocument()) {
                    XmldbURI path = node.getDocument().getURI();
                    result = new AnyURIValue(path);
                }
            } else if (value instanceof DocumentImpl && ((DocumentImpl)value).getDocumentURI() != null) {
                result = new AnyURIValue(((DocumentImpl)value).getDocumentURI());
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

