/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.exist.EXistException;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.Match;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.NodeSetIterator;
import org.exist.numbering.NodeId;
import org.exist.storage.NativeTextEngine;
import org.exist.storage.analysis.TextToken;
import org.exist.storage.analysis.Tokenizer;
import org.exist.util.GlobToRegex;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.ExtFulltext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Sequence;

public class ExtPhrase
extends ExtFulltext {
    public ExtPhrase(XQueryContext context) {
        super(context, 1);
    }

    public Sequence evalQuery(String searchArg, NodeSet nodes) throws XPathException {
        String[] terms;
        try {
            terms = this.getSearchTerms(searchArg);
        }
        catch (EXistException e) {
            throw new XPathException(this.getASTNode(), e.getMessage(), e);
        }
        NodeSet hits = this.processQuery(terms, nodes);
        if (hits == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        boolean hasWildcards = false;
        for (int i = 0; i < terms.length; ++i) {
            hasWildcards |= NativeTextEngine.containsWildcards(terms[i]);
        }
        return hasWildcards ? this.patternMatch(this.context, terms, hits) : this.exactMatch(this.context, terms, hits);
    }

    private Sequence exactMatch(XQueryContext context, String[] terms, NodeSet result) {
        ExtArrayNodeSet r = new ExtArrayNodeSet();
        Tokenizer tok = context.getBroker().getTextEngine().getTokenizer();
        String matchTerm = "";
        for (int k = 0; k < terms.length; ++k) {
            matchTerm = matchTerm + terms[k];
            if (k == terms.length - 1) continue;
            matchTerm = matchTerm + "\\W*";
        }
        NodeSetIterator i = result.iterator();
        block1: while (i.hasNext()) {
            Vector<NodeId> matchGid = new Vector<NodeId>();
            NodeProxy current = (NodeProxy)i.next();
            current.setMatches(null);
            for (Match nextMatch = current.getMatches(); nextMatch != null; nextMatch = nextMatch.getNextMatch()) {
                TextToken token;
                NodeId nodeId = nextMatch.getNodeId();
                if (matchGid.contains(nodeId)) continue;
                NodeProxy mcurrent = new NodeProxy(current.getDocument(), nodeId);
                Match match = null;
                int firstOffset = -1;
                matchGid.add(nodeId);
                String value = mcurrent.getNodeValue();
                tok.setText(value);
                int j = 0;
                if (j >= terms.length) continue block1;
                String term = terms[j];
                int frequency = 0;
                while ((token = tok.nextToken()) != null) {
                    String word = token.getText().toLowerCase();
                    if (word.equalsIgnoreCase(term)) {
                        if (++j == terms.length) {
                            if (match == null) {
                                match = nextMatch.createInstance(this.getExpressionId(), nodeId, matchTerm);
                            }
                            if (firstOffset < 0) {
                                firstOffset = token.startOffset();
                            }
                            match.addOffset(firstOffset, token.endOffset() - firstOffset);
                            ++frequency;
                            j = 0;
                            term = terms[j];
                            continue;
                        }
                        term = terms[j];
                        if (firstOffset >= 0) continue;
                        firstOffset = token.startOffset();
                        continue;
                    }
                    if (j > 0 && word.equalsIgnoreCase(terms[0])) {
                        j = 1;
                        term = terms[j];
                        firstOffset = token.startOffset();
                        continue;
                    }
                    j = 0;
                    firstOffset = -1;
                    term = terms[j];
                }
                if (frequency == 0) continue;
                current.addMatch(match);
                r.add(current);
                frequency = 0;
            }
        }
        return r;
    }

    private Sequence patternMatch(XQueryContext context, String[] terms, NodeSet result) {
        Pattern[] patterns = new Pattern[terms.length];
        Matcher[] matchers = new Matcher[terms.length];
        for (int i = 0; i < patterns.length; ++i) {
            try {
                patterns[i] = Pattern.compile(GlobToRegex.globToRegexp(terms[i]), 66);
                matchers[i] = patterns[i].matcher("");
                continue;
            }
            catch (PatternSyntaxException e) {
                LOG.warn((Object)"malformed pattern", (Throwable)e);
                return Sequence.EMPTY_SEQUENCE;
            }
        }
        ExtArrayNodeSet r = new ExtArrayNodeSet();
        Tokenizer tok = context.getBroker().getTextEngine().getTokenizer();
        NodeSetIterator i = result.iterator();
        block3: while (i.hasNext()) {
            Vector<NodeId> matchGid = new Vector<NodeId>();
            NodeProxy current = (NodeProxy)i.next();
            current.setMatches(null);
            for (Match nextMatch = current.getMatches(); nextMatch != null; nextMatch = nextMatch.getNextMatch()) {
                Match match;
                TextToken token;
                Hashtable<String, Match> matchTable = new Hashtable<String, Match>();
                NodeId nodeId = nextMatch.getNodeId();
                if (matchGid.contains(nodeId)) continue;
                NodeProxy mcurrent = new NodeProxy(current.getDocument(), nodeId);
                matchGid.add(nodeId);
                String value = mcurrent.getNodeValue();
                tok.setText(value);
                int j = 0;
                if (j >= patterns.length) continue block3;
                Matcher matcher = matchers[j];
                String matchTerm = null;
                while ((token = tok.nextToken()) != null) {
                    String word = token.getText().toLowerCase();
                    matcher.reset(word);
                    matchers[0].reset(word);
                    if (matcher.matches()) {
                        matchTerm = matchTerm == null ? word : matchTerm + "\\W*" + word;
                        if (++j == patterns.length) {
                            if (matchTable.containsKey(matchTerm)) {
                                match = (Match)matchTable.get(matchTerm);
                                match.addOffset(token.startOffset(), matchTerm.length());
                            } else {
                                match = nextMatch.createInstance(this.getExpressionId(), nodeId, matchTerm);
                                match.addOffset(token.startOffset(), matchTerm.length());
                                matchTable.put(matchTerm, match);
                            }
                            j = 0;
                            matcher = matchers[j];
                            matchTerm = null;
                            continue;
                        }
                        matcher = matchers[j];
                        continue;
                    }
                    if (j > 0 && matchers[0].matches()) {
                        j = 1;
                        matcher = matchers[j];
                        matchTerm = word;
                        continue;
                    }
                    j = 0;
                    matcher = matchers[j];
                    matchTerm = null;
                }
                if (matchTable.size() == 0) continue;
                Enumeration eMatch = matchTable.elements();
                while (eMatch.hasMoreElements()) {
                    match = (Match)eMatch.nextElement();
                    current.addMatch(match);
                }
                r.add(current);
            }
        }
        return r;
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display("phrase(");
        this.path.dump(dumper);
        dumper.display(", ");
        this.searchTerm.dump(dumper);
        dumper.display(")");
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("phrase(");
        buf.append(this.path);
        buf.append(", ");
        buf.append(this.searchTerm);
        buf.append(")");
        return buf.toString();
    }
}

