/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.DocumentSet;
import org.exist.dom.NodeSet;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Profiler;
import org.exist.xquery.Step;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class SimpleStep
extends Step {
    private final Expression expression;

    public SimpleStep(XQueryContext context, int axis, Expression expression) {
        super(context, axis);
        this.expression = expression;
        this.expression.setPrimaryAxis(axis);
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.expression.analyze(contextInfo);
        super.analyze(contextInfo);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        NodeSet set;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((set = this.expression.eval(contextSequence).toNodeSet()).isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            switch (this.axis) {
                case 8: {
                    set = set.selectAncestorDescendant(contextSequence.toNodeSet(), 1, true, this.contextId);
                    break;
                }
                case 5: {
                    set = set.selectParentChild(contextSequence.toNodeSet(), 1, this.contextId);
                    break;
                }
                default: {
                    throw new XPathException(this.getASTNode(), "Wrong axis specified");
                }
            }
            result = set;
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.expression.resetState(postOptimization);
    }

    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.expression.setContextDocSet(contextSet);
    }

    public void setPrimaryAxis(int axis) {
        this.expression.setPrimaryAxis(axis);
    }
}

