/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Iterator;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.ExtNodeSet;
import org.exist.dom.NewArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.NodeSetIterator;
import org.exist.dom.NodeVisitor;
import org.exist.dom.StoredNode;
import org.exist.dom.VirtualNodeSet;
import org.exist.numbering.NodeId;
import org.exist.storage.ElementIndex;
import org.exist.storage.UpdateListener;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.AncestorSelector;
import org.exist.xquery.CachedResult;
import org.exist.xquery.ChildSelector;
import org.exist.xquery.Dependency;
import org.exist.xquery.DescendantOrSelfSelector;
import org.exist.xquery.DescendantSelector;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.NodeSelector;
import org.exist.xquery.NodeTest;
import org.exist.xquery.ParentSelector;
import org.exist.xquery.Predicate;
import org.exist.xquery.Profiler;
import org.exist.xquery.SelfSelector;
import org.exist.xquery.Step;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class LocationStep
extends Step {
    private final int ATTR_DIRECT_SELECT_THRESHOLD = 10;
    protected NodeSet currentSet = null;
    protected DocumentSet currentDocs = null;
    protected UpdateListener listener = null;
    protected Expression parent = null;
    protected CachedResult cached = null;
    protected int parentDeps = -1;
    protected boolean preload = false;
    protected boolean optimized = false;
    protected boolean inUpdate = false;
    protected boolean useDirectAttrSelect = true;
    protected boolean useDirectChildSelect = false;
    private Integer nodeTestType = null;

    public LocationStep(XQueryContext context, int axis) {
        super(context, axis);
    }

    public LocationStep(XQueryContext context, int axis, NodeTest test) {
        super(context, axis, test);
    }

    public int getDependencies() {
        int deps = 1;
        if (!this.inPredicate && this.axis == 12) {
            deps |= 2;
        }
        Iterator i = this.predicates.iterator();
        while (i.hasNext()) {
            deps |= ((Predicate)i.next()).getDependencies();
        }
        return deps;
    }

    protected boolean preloadNodeSets() {
        if (this.preload) {
            this.context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, null, "Preloaded NodeSets");
            return true;
        }
        if (this.inUpdate) {
            return false;
        }
        if ((this.parentDeps & 4) == 4) {
            this.context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, null, "Preloaded NodeSets");
            return true;
        }
        return false;
    }

    public void setPreloadNodeSets(boolean doPreload) {
        this.preload = doPreload;
    }

    public void setPreloadedData(DocumentSet docs, NodeSet nodes) {
        this.currentDocs = docs;
        this.currentSet = nodes;
        this.optimized = true;
    }

    protected Sequence applyPredicate(Sequence outerSequence, Sequence contextSequence) throws XPathException {
        Sequence result;
        if (contextSequence == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (this.predicates.size() == 0) {
            return contextSequence;
        }
        Predicate pred = (Predicate)this.predicates.get(0);
        if (this.abbreviatedStep && (pred.getExecutionMode() != 0 || !contextSequence.isPersistentSet())) {
            result = new ValueSequence();
            NodeSet contextSet = contextSequence.toNodeSet();
            outerSequence = contextSet.getParents(this.getExpressionId());
            SequenceIterator i = outerSequence.iterate();
            while (i.hasNext()) {
                NodeValue node = (NodeValue)i.nextItem();
                NodeSet newContextSeq = contextSet.selectParentChild((NodeSet)((Object)node), 1, this.getExpressionId());
                Sequence temp = this.processPredicate(outerSequence, newContextSeq);
                result.addAll(temp);
            }
        } else {
            result = this.processPredicate(outerSequence, contextSequence);
        }
        return result;
    }

    private Sequence processPredicate(Sequence outerSequence, Sequence contextSequence) throws XPathException {
        Sequence result = contextSequence;
        Iterator i = this.predicates.iterator();
        while (i.hasNext()) {
            Predicate pred = (Predicate)i.next();
            pred.setContextDocSet(this.getContextDocSet());
            result = pred.evalPredicate(outerSequence, result, this.axis);
            outerSequence = null;
        }
        return result;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        this.parent = contextInfo.getParent();
        this.parentDeps = this.parent.getDependencies();
        if ((contextInfo.getFlags() & 8) > 0) {
            this.inUpdate = true;
        }
        if ((contextInfo.getFlags() & 1) > 0) {
            this.preload = true;
        }
        if ((contextInfo.getFlags() & 0x10) > 0) {
            this.useDirectAttrSelect = false;
        }
        if ((contextInfo.getFlags() & 0x20) > 0) {
            this.useDirectChildSelect = true;
        }
        if (this.axis == 12 && this.test.getType() == -1) {
            contextInfo.addFlag(128);
        }
        super.analyze(contextInfo);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        block21: {
            block20: {
                if (this.context.getProfiler().isEnabled()) {
                    this.context.getProfiler().start(this);
                    this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
                    if (contextSequence != null) {
                        this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
                    }
                    if (contextItem != null) {
                        this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
                    }
                }
                if (contextItem != null) {
                    contextSequence = contextItem.toSequence();
                }
                if (!this.needsComputation()) break block20;
                if (contextSequence == null) {
                    throw new XPathException(this.getASTNode(), "XPDY0002 : undefined context sequence for '" + this.toString() + "'");
                }
                switch (this.axis) {
                    case 7: 
                    case 8: {
                        result = this.getDescendants(this.context, contextSequence.toNodeSet());
                        break block21;
                    }
                    case 5: {
                        if (this.test.getType() == 2) {
                            this.axis = 6;
                            result = this.getAttributes(this.context, contextSequence.toNodeSet());
                        } else {
                            result = this.getChildren(this.context, contextSequence.toNodeSet());
                        }
                        break block21;
                    }
                    case 0: 
                    case 1: {
                        result = this.getAncestors(this.context, contextSequence.toNodeSet());
                        break block21;
                    }
                    case 2: {
                        result = this.getParents(this.context, contextSequence.toNodeSet());
                        break block21;
                    }
                    case 12: {
                        result = !(contextSequence instanceof VirtualNodeSet) && Type.subTypeOf(contextSequence.getItemType(), 20) ? this.getSelfAtomic(contextSequence) : this.getSelf(this.context, contextSequence.toNodeSet());
                        break block21;
                    }
                    case 6: 
                    case 13: {
                        result = this.getAttributes(this.context, contextSequence.toNodeSet());
                        break block21;
                    }
                    case 3: {
                        result = this.getPreceding(this.context, contextSequence.toNodeSet());
                        break block21;
                    }
                    case 9: {
                        result = this.getFollowing(this.context, contextSequence.toNodeSet());
                        break block21;
                    }
                    case 4: 
                    case 10: {
                        result = this.getSiblings(this.context, contextSequence.toNodeSet());
                        break block21;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported axis specified");
                    }
                }
            }
            result = NodeSet.EMPTY_SET;
        }
        if (this.axis != 12 && contextSequence != null && contextSequence.isCacheable()) {
            this.cached = new CachedResult(contextSequence, contextItem, result);
            this.registerUpdateListener();
        }
        result.removeDuplicates();
        result = this.applyPredicate(contextSequence, result);
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    private boolean needsComputation() {
        switch (this.axis) {
            case 1: 
            case 2: 
            case 12: {
                if (this.nodeTestType == null) {
                    this.nodeTestType = new Integer(this.test.getType());
                }
                if (this.nodeTestType == -1 || this.nodeTestType == 1 || this.nodeTestType == 4) break;
                if (this.context.getProfiler().isEnabled()) {
                    this.context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, "OPTIMIZATION", "avoid useless computations");
                }
                return false;
            }
        }
        return true;
    }

    protected Sequence getSelf(XQueryContext context, NodeSet contextSet) {
        if (this.test.getType() == 4) {
            VirtualNodeSet vset = new VirtualNodeSet(context.getBroker(), this.axis, this.test, this.contextId, contextSet);
            vset.setInPredicate(-1 != this.contextId);
            return vset;
        }
        if (this.test.isWildcardTest()) {
            if (this.nodeTestType == null) {
                this.nodeTestType = new Integer(this.test.getType());
            }
            if (Type.subTypeOf(this.nodeTestType, -1)) {
                NewArrayNodeSet result = null;
                if (-1 != this.contextId && contextSet instanceof VirtualNodeSet) {
                    ((VirtualNodeSet)contextSet).setInPredicate(true);
                    ((VirtualNodeSet)contextSet).setSelfIsContext();
                    ((VirtualNodeSet)contextSet).setContextId(this.contextId);
                } else if (Type.subTypeOf(contextSet.getItemType(), -1)) {
                    if (this.test.getType() != -1) {
                        result = new NewArrayNodeSet();
                    }
                    NodeSetIterator i = contextSet.iterator();
                    while (i.hasNext()) {
                        NodeProxy p = (NodeProxy)i.next();
                        if (!this.test.matches(p)) continue;
                        p.addContextNode(this.contextId, p);
                        if (result == null) continue;
                        result.add(p);
                    }
                }
                return result == null ? contextSet : result;
            }
            VirtualNodeSet vset = new VirtualNodeSet(context.getBroker(), this.axis, this.test, this.contextId, contextSet);
            vset.setInPredicate(-1 != this.contextId);
            return vset;
        }
        DocumentSet docs = this.getDocumentSet(contextSet);
        SelfSelector selector = new SelfSelector(contextSet, this.contextId);
        ElementIndex index = context.getBroker().getElementIndex();
        if (context.getProfiler().isEnabled()) {
            context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
        }
        return index.findElementsByTagName((byte)0, docs, this.test.getName(), selector);
    }

    protected Sequence getSelfAtomic(Sequence contextSequence) throws XPathException {
        if (!this.test.isWildcardTest()) {
            throw new XPathException(this.getASTNode(), this.test.toString() + " cannot be applied to an atomic value.");
        }
        return contextSequence;
    }

    protected NodeSet getAttributes(XQueryContext context, NodeSet contextSet) {
        NodeSelector selector;
        boolean selectDirect = false;
        if (this.useDirectAttrSelect && this.axis == 6) {
            if (contextSet instanceof VirtualNodeSet) {
                selectDirect = ((VirtualNodeSet)contextSet).preferTreeTraversal() && contextSet.getLength() < 10;
            } else {
                boolean bl = selectDirect = contextSet.getLength() < 10;
            }
        }
        if (selectDirect) {
            if (context.getProfiler().isEnabled()) {
                context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, "OPTIMIZATION", "direct attribute selection");
            }
            if (contextSet.isEmpty()) {
                return NodeSet.EMPTY_SET;
            }
            NodeProxy proxy = contextSet.get(0);
            if (proxy != null) {
                return contextSet.directSelectAttribute(context.getBroker(), this.test, this.contextId);
            }
        }
        if (this.test.isWildcardTest()) {
            VirtualNodeSet result = new VirtualNodeSet(context.getBroker(), this.axis, this.test, this.contextId, contextSet);
            result.setInPredicate(-1 != this.contextId);
            return result;
        }
        if (this.preloadNodeSets()) {
            DocumentSet docs = this.getDocumentSet(contextSet);
            XQueryContext xQueryContext = context;
            synchronized (xQueryContext) {
                if (this.currentSet == null || this.currentDocs == null || !this.optimized && docs != this.currentDocs && !docs.equals(this.currentDocs)) {
                    ElementIndex index = context.getBroker().getElementIndex();
                    if (context.getProfiler().isEnabled()) {
                        context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
                    }
                    this.currentSet = index.findElementsByTagName((byte)1, docs, this.test.getName(), null);
                    this.currentDocs = docs;
                    this.registerUpdateListener();
                }
                switch (this.axis) {
                    case 6: {
                        return this.currentSet.selectParentChild(contextSet, 1, this.contextId);
                    }
                    case 13: {
                        return this.currentSet.selectAncestorDescendant(contextSet, 1, false, this.contextId);
                    }
                }
                throw new IllegalArgumentException("Unsupported axis specified");
            }
        }
        DocumentSet docs = this.getDocumentSet(contextSet);
        switch (this.axis) {
            case 6: {
                selector = new ChildSelector(contextSet, this.contextId);
                break;
            }
            case 13: {
                selector = new DescendantSelector(contextSet, this.contextId);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported axis specified");
            }
        }
        ElementIndex index = context.getBroker().getElementIndex();
        if (context.getProfiler().isEnabled()) {
            context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
        }
        if (contextSet instanceof ExtNodeSet && !contextSet.getProcessInReverseOrder()) {
            return index.findDescendantsByTagName((byte)1, this.test.getName(), this.axis, docs, (ExtNodeSet)contextSet, this.contextId);
        }
        return index.findElementsByTagName((byte)1, docs, this.test.getName(), selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeSet getChildren(XQueryContext context, NodeSet contextSet) {
        if (this.test.isWildcardTest() || this.test.getType() == 4) {
            VirtualNodeSet vset = new VirtualNodeSet(context.getBroker(), this.axis, this.test, this.contextId, contextSet);
            vset.setInPredicate(-1 != this.contextId);
            return vset;
        }
        if (this.useDirectChildSelect) {
            NewArrayNodeSet result = new NewArrayNodeSet();
            NodeSetIterator i = contextSet.iterator();
            while (i.hasNext()) {
                NodeProxy p = (NodeProxy)i.next();
                result.addAll(p.directSelectChild(this.test.getName(), this.contextId));
            }
            return result;
        }
        if (this.preloadNodeSets()) {
            DocumentSet docs = this.getDocumentSet(contextSet);
            XQueryContext i = context;
            synchronized (i) {
                if (this.currentSet == null || this.currentDocs == null || !this.optimized && docs != this.currentDocs && !docs.equals(this.currentDocs)) {
                    ElementIndex index = context.getBroker().getElementIndex();
                    if (context.getProfiler().isEnabled()) {
                        context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
                    }
                    this.currentSet = index.findElementsByTagName((byte)0, docs, this.test.getName(), null);
                    this.currentDocs = docs;
                    this.registerUpdateListener();
                }
                return this.currentSet.selectParentChild(contextSet, 1, this.contextId);
            }
        }
        ElementIndex index = context.getBroker().getElementIndex();
        if (context.getProfiler().isEnabled()) {
            context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
        }
        DocumentSet docs = this.getDocumentSet(contextSet);
        if (contextSet instanceof ExtNodeSet && !contextSet.getProcessInReverseOrder()) {
            return index.findDescendantsByTagName((byte)0, this.test.getName(), this.axis, docs, (ExtNodeSet)contextSet, this.contextId);
        }
        ChildSelector selector = new ChildSelector(contextSet, this.contextId);
        return index.findElementsByTagName((byte)0, docs, this.test.getName(), selector);
    }

    protected NodeSet getDescendants(XQueryContext context, NodeSet contextSet) {
        DescendantSelector selector;
        if (this.test.isWildcardTest() || this.test.getType() == 4) {
            VirtualNodeSet vset = new VirtualNodeSet(context.getBroker(), this.axis, this.test, this.contextId, contextSet);
            vset.setInPredicate(-1 != this.contextId);
            return vset;
        }
        if (this.preloadNodeSets()) {
            DocumentSet docs = this.getDocumentSet(contextSet);
            XQueryContext xQueryContext = context;
            synchronized (xQueryContext) {
                if (this.currentSet == null || this.currentDocs == null || !this.optimized && docs != this.currentDocs && !docs.equals(this.currentDocs)) {
                    ElementIndex index = context.getBroker().getElementIndex();
                    if (context.getProfiler().isEnabled()) {
                        context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
                    }
                    this.currentSet = index.findElementsByTagName((byte)0, docs, this.test.getName(), null);
                    this.currentDocs = docs;
                    this.registerUpdateListener();
                }
                switch (this.axis) {
                    case 8: {
                        NodeSet tempSet = this.currentSet.selectAncestorDescendant(contextSet, 1, true, this.contextId);
                        return tempSet;
                    }
                    case 7: {
                        return this.currentSet.selectAncestorDescendant(contextSet, 1, false, this.contextId);
                    }
                }
                throw new IllegalArgumentException("Unsupported axis specified");
            }
        }
        DocumentSet docs = contextSet.getDocumentSet();
        switch (this.axis) {
            case 8: {
                selector = new DescendantOrSelfSelector(contextSet, this.contextId);
                break;
            }
            case 7: {
                selector = new DescendantSelector(contextSet, this.contextId);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported axis specified");
            }
        }
        ElementIndex index = context.getBroker().getElementIndex();
        if (context.getProfiler().isEnabled()) {
            context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
        }
        if (contextSet instanceof ExtNodeSet) {
            return index.findDescendantsByTagName((byte)0, this.test.getName(), this.axis, docs, (ExtNodeSet)contextSet, this.contextId);
        }
        return index.findElementsByTagName((byte)0, docs, this.test.getName(), selector);
    }

    protected NodeSet getSiblings(XQueryContext context, NodeSet contextSet) {
        if (this.test.getType() == 4) {
            VirtualNodeSet vset = new VirtualNodeSet(context.getBroker(), this.axis, this.test, this.contextId, contextSet);
            vset.setInPredicate(-1 != this.contextId);
            return vset;
        }
        if (this.test.isWildcardTest()) {
            ExtArrayNodeSet result = new ExtArrayNodeSet(contextSet.getLength());
            SiblingVisitor visitor = new SiblingVisitor(result);
            NodeSetIterator i = contextSet.iterator();
            while (i.hasNext()) {
                NodeProxy current = (NodeProxy)i.next();
                NodeId parentId = current.getNodeId().getParentId();
                if (parentId.getTreeLevel() == 1 && current.getDocument().getCollection().isTempCollection()) continue;
                StoredNode parentNode = context.getBroker().objectWith(current.getOwnerDocument(), parentId);
                visitor.setContext(current);
                parentNode.accept(visitor);
            }
            return result;
        }
        DocumentSet docs = this.getDocumentSet(contextSet);
        XQueryContext xQueryContext = context;
        synchronized (xQueryContext) {
            if (this.currentSet == null || this.currentDocs == null || !docs.equals(this.currentDocs)) {
                ElementIndex index = context.getBroker().getElementIndex();
                if (context.getProfiler().isEnabled()) {
                    context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
                }
                this.currentSet = index.findElementsByTagName((byte)0, docs, this.test.getName(), null);
                this.currentDocs = docs;
                this.registerUpdateListener();
            }
            switch (this.axis) {
                case 4: {
                    return this.currentSet.selectPrecedingSiblings(contextSet, this.contextId);
                }
                case 10: {
                    return this.currentSet.selectFollowingSiblings(contextSet, this.contextId);
                }
            }
            throw new IllegalArgumentException("Unsupported axis specified");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeSet getPreceding(XQueryContext context, NodeSet contextSet) throws XPathException {
        if (this.test.getType() == 4) {
            VirtualNodeSet vset = new VirtualNodeSet(context.getBroker(), this.axis, this.test, this.contextId, contextSet);
            vset.setInPredicate(-1 != this.contextId);
            return vset;
        }
        if (this.test.isWildcardTest()) {
            return NodeSet.EMPTY_SET;
        }
        DocumentSet docs = this.getDocumentSet(contextSet);
        XQueryContext xQueryContext = context;
        synchronized (xQueryContext) {
            if (this.currentSet == null || this.currentDocs == null || !docs.equals(this.currentDocs)) {
                ElementIndex index = context.getBroker().getElementIndex();
                if (context.getProfiler().isEnabled()) {
                    context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
                }
                this.currentSet = index.findElementsByTagName((byte)0, docs, this.test.getName(), null);
                this.currentDocs = docs;
                this.registerUpdateListener();
            }
            return this.currentSet.selectPreceding(contextSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeSet getFollowing(XQueryContext context, NodeSet contextSet) throws XPathException {
        if (this.test.getType() == 4) {
            VirtualNodeSet vset = new VirtualNodeSet(context.getBroker(), this.axis, this.test, this.contextId, contextSet);
            vset.setInPredicate(-1 != this.contextId);
            return vset;
        }
        if (this.test.isWildcardTest() && this.test.getType() != 4) {
            return NodeSet.EMPTY_SET;
        }
        DocumentSet docs = this.getDocumentSet(contextSet);
        XQueryContext xQueryContext = context;
        synchronized (xQueryContext) {
            if (this.currentSet == null || this.currentDocs == null || !docs.equals(this.currentDocs)) {
                ElementIndex index = context.getBroker().getElementIndex();
                if (context.getProfiler().isEnabled()) {
                    context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
                }
                this.currentSet = index.findElementsByTagName((byte)0, docs, this.test.getName(), null);
                this.currentDocs = docs;
                this.registerUpdateListener();
            }
            return this.currentSet.selectFollowing(contextSet);
        }
    }

    protected NodeSet getAncestors(XQueryContext context, NodeSet contextSet) {
        AncestorSelector selector;
        if (this.test.isWildcardTest()) {
            ExtArrayNodeSet result = new ExtArrayNodeSet();
            result.setProcessInReverseOrder(true);
            NodeSetIterator i = contextSet.iterator();
            while (i.hasNext()) {
                NodeProxy ancestor;
                NodeProxy current = (NodeProxy)i.next();
                if (this.axis == 1 && this.test.matches(current)) {
                    ancestor = new NodeProxy(current.getDocument(), current.getNodeId(), 1, current.getInternalAddress());
                    NodeProxy t = result.get(ancestor);
                    if (t == null) {
                        if (-1 != this.contextId) {
                            ancestor.addContextNode(this.contextId, current);
                        } else {
                            ancestor.copyContext(current);
                        }
                        ancestor.addMatches(current);
                        result.add(ancestor);
                    } else {
                        t.addContextNode(this.contextId, current);
                        t.addMatches(current);
                    }
                }
                for (NodeId parentID = current.getNodeId().getParentId(); parentID != null; parentID = parentID.getParentId()) {
                    ancestor = new NodeProxy(current.getDocument(), parentID, 1);
                    if (parentID == NodeId.DOCUMENT_NODE || parentID.getTreeLevel() == 1 && current.getDocument().getCollection().isTempCollection() || !this.test.matches(ancestor)) continue;
                    NodeProxy t = result.get(ancestor);
                    if (t == null) {
                        if (-1 != this.contextId) {
                            ancestor.addContextNode(this.contextId, current);
                        } else {
                            ancestor.copyContext(current);
                        }
                        ancestor.addMatches(current);
                        result.add(ancestor);
                        continue;
                    }
                    t.addContextNode(this.contextId, current);
                    t.addMatches(current);
                }
            }
            return result;
        }
        if (this.preloadNodeSets()) {
            DocumentSet docs = this.getDocumentSet(contextSet);
            XQueryContext i = context;
            synchronized (i) {
                if (this.currentSet == null || this.currentDocs == null || !this.optimized && docs != this.currentDocs && !docs.equals(this.currentDocs)) {
                    ElementIndex index = context.getBroker().getElementIndex();
                    if (context.getProfiler().isEnabled()) {
                        context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
                    }
                    this.currentSet = index.findElementsByTagName((byte)0, docs, this.test.getName(), null);
                    this.currentDocs = docs;
                    this.registerUpdateListener();
                }
                switch (this.axis) {
                    case 1: {
                        return this.currentSet.selectAncestors(contextSet, true, this.contextId);
                    }
                    case 0: {
                        return this.currentSet.selectAncestors(contextSet, false, this.contextId);
                    }
                }
                throw new IllegalArgumentException("Unsupported axis specified");
            }
        }
        DocumentSet docs = this.getDocumentSet(contextSet);
        switch (this.axis) {
            case 1: {
                selector = new AncestorSelector(contextSet, this.contextId, true);
                break;
            }
            case 0: {
                selector = new AncestorSelector(contextSet, this.contextId, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported axis specified");
            }
        }
        ElementIndex index = context.getBroker().getElementIndex();
        if (context.getProfiler().isEnabled()) {
            context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
        }
        return index.findElementsByTagName((byte)0, docs, this.test.getName(), selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeSet getParents(XQueryContext context, NodeSet contextSet) {
        if (this.test.isWildcardTest()) {
            NodeSet temp = contextSet.getParents(this.contextId);
            NewArrayNodeSet result = new NewArrayNodeSet();
            NodeSetIterator i = temp.iterator();
            while (i.hasNext()) {
                NodeProxy p = (NodeProxy)i.next();
                if (!this.test.matches(p)) continue;
                result.add(p);
            }
            return result;
        }
        if (this.preloadNodeSets()) {
            DocumentSet docs = this.getDocumentSet(contextSet);
            XQueryContext result = context;
            synchronized (result) {
                if (this.currentSet == null || this.currentDocs == null || !this.optimized && docs != this.currentDocs && !docs.equals(this.currentDocs)) {
                    ElementIndex index = context.getBroker().getElementIndex();
                    if (context.getProfiler().isEnabled()) {
                        context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
                    }
                    this.currentSet = index.findElementsByTagName((byte)0, docs, this.test.getName(), null);
                    this.currentDocs = docs;
                    this.registerUpdateListener();
                }
                return contextSet.selectParentChild(this.currentSet, 0);
            }
        }
        DocumentSet docs = this.getDocumentSet(contextSet);
        ParentSelector selector = new ParentSelector(contextSet, this.contextId);
        ElementIndex index = context.getBroker().getElementIndex();
        if (context.getProfiler().isEnabled()) {
            context.getProfiler().message((Expression)this, Profiler.OPTIMIZATIONS, "OPTIMIZATION", "Using structural index '" + index.toString() + "'");
        }
        return index.findElementsByTagName((byte)0, docs, this.test.getName(), selector);
    }

    protected DocumentSet getDocumentSet(NodeSet contextSet) {
        DocumentSet ds = this.getContextDocSet();
        if (ds == null) {
            ds = contextSet.getDocumentSet();
        }
        return ds;
    }

    public Expression getParent() {
        return this.parent;
    }

    public void setUseDirectAttrSelect(boolean useDirectAttrSelect) {
        this.useDirectAttrSelect = useDirectAttrSelect;
    }

    protected void registerUpdateListener() {
        if (this.listener == null) {
            this.listener = new UpdateListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void documentUpdated(DocumentImpl document, int event) {
                    XQueryContext xQueryContext = LocationStep.this.context;
                    synchronized (xQueryContext) {
                        LocationStep.this.cached = null;
                        if (document == null || event == 0 || event == 2) {
                            LocationStep.this.currentDocs = null;
                            LocationStep.this.currentSet = null;
                        } else if (LocationStep.this.currentDocs != null && LocationStep.this.currentDocs.contains(document.getDocId())) {
                            LocationStep.this.currentDocs = null;
                            LocationStep.this.currentSet = null;
                        }
                    }
                }

                public void nodeMoved(NodeId oldNodeId, StoredNode newNode) {
                }

                public void unsubscribe() {
                    LocationStep.this.listener = null;
                }

                public void debug() {
                    Step.LOG.debug((Object)("UpdateListener: Line: " + LocationStep.this.toString() + "; id: " + LocationStep.this.getExpressionId()));
                }
            };
            this.context.registerUpdateListener(this.listener);
        }
    }

    public void accept(ExpressionVisitor visitor) {
        visitor.visitLocationStep(this);
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        if (!postOptimization) {
            this.currentSet = null;
            this.currentDocs = null;
            this.optimized = false;
            this.cached = null;
            this.listener = null;
        }
    }

    private class SiblingVisitor
    implements NodeVisitor {
        private ExtArrayNodeSet resultSet;
        private NodeProxy contextNode;

        public SiblingVisitor(ExtArrayNodeSet resultSet) {
            this.resultSet = resultSet;
        }

        public void setContext(NodeProxy contextNode) {
            this.contextNode = contextNode;
        }

        public boolean visit(StoredNode current) {
            if (this.contextNode.getNodeId().getTreeLevel() == current.getNodeId().getTreeLevel()) {
                int cmp = current.getNodeId().compareTo(this.contextNode.getNodeId());
                if ((LocationStep.this.axis == 10 && cmp > 0 || LocationStep.this.axis == 4 && cmp < 0) && LocationStep.this.test.matches(current)) {
                    NodeProxy sibling = this.resultSet.get((DocumentImpl)current.getOwnerDocument(), current.getNodeId());
                    if (sibling == null) {
                        sibling = new NodeProxy((DocumentImpl)current.getOwnerDocument(), current.getNodeId(), current.getInternalAddress());
                        if (-1 != LocationStep.this.contextId) {
                            sibling.addContextNode(LocationStep.this.contextId, this.contextNode);
                        } else {
                            sibling.copyContext(this.contextNode);
                        }
                        this.resultSet.add(sibling);
                        this.resultSet.setSorted(sibling.getDocument(), true);
                    } else if (-1 != LocationStep.this.contextId) {
                        sibling.addContextNode(LocationStep.this.contextId, this.contextNode);
                    }
                }
            }
            return true;
        }
    }
}

