/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Iterator;
import java.util.List;
import org.exist.dom.QName;
import org.exist.xquery.CastExpression;
import org.exist.xquery.Expression;
import org.exist.xquery.ExternalModule;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.FunctionDef;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.GeneralComparison;
import org.exist.xquery.InternalFunctionCall;
import org.exist.xquery.InternalModule;
import org.exist.xquery.JavaCall;
import org.exist.xquery.Module;
import org.exist.xquery.PathExpr;
import org.exist.xquery.Profiler;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.ExtNear;
import org.exist.xquery.functions.ExtPhrase;
import org.exist.xquery.parser.XQueryAST;
import org.exist.xquery.value.Type;

public class FunctionFactory {
    public static final String ENABLE_JAVA_BINDING_ATTRIBUTE = "enable-java-binding";
    public static final String PROPERTY_ENABLE_JAVA_BINDING = "xquery.enable-java-binding";

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Expression createFunction(XQueryContext context, XQueryAST ast, PathExpr parent, List params) throws XPathException {
        FunctionCall call;
        void var7_24;
        void var7_20;
        QName qname = null;
        try {
            qname = QName.parse(context, ast.getText(), context.getDefaultFunctionNamespace());
        }
        catch (XPathException e) {
            e.setASTNode(ast);
            throw e;
        }
        String local = qname.getLocalName();
        String uri = qname.getNamespaceURI();
        Object var7_8 = null;
        if (uri.equals("http://www.w3.org/2005/xpath-functions")) {
            GeneralComparison op;
            PathExpr p1;
            PathExpr p0;
            Expression e1;
            PathExpr p12;
            if (local.equals("near")) {
                if (params.size() < 2) {
                    throw new XPathException(ast, "XPST0017: Function near() requires two arguments");
                }
                p12 = (PathExpr)params.get(1);
                if (p12.getLength() == 0) {
                    throw new XPathException(ast, "Second argument to near is empty");
                }
                e1 = p12.getExpression(0);
                ExtNear near = new ExtNear(context);
                near.setASTNode(ast);
                near.addTerm(e1);
                near.setPath((PathExpr)params.get(0));
                if (params.size() > 2) {
                    p12 = (PathExpr)params.get(2);
                    if (p12.getLength() == 0) {
                        throw new XPathException(ast, "Max distance argument to near is empty");
                    }
                    near.setMaxDistance(p12);
                    if (params.size() == 4) {
                        p12 = (PathExpr)params.get(3);
                        if (p12.getLength() == 0) {
                            throw new XPathException(ast, "Min distance argument to near is empty");
                        }
                        near.setMinDistance(p12);
                    }
                }
                ExtNear extNear = near;
            }
            if (local.equals("phrase")) {
                if (params.size() < 2) {
                    throw new XPathException(ast, "XPST0017: Function phrase() requires two arguments");
                }
                p12 = (PathExpr)params.get(1);
                if (p12.getLength() == 0) {
                    throw new XPathException(ast, "Second argument to phrase is empty");
                }
                e1 = p12.getExpression(0);
                ExtPhrase phrase = new ExtPhrase(context);
                phrase.setASTNode(ast);
                phrase.addTerm(e1);
                phrase.setPath((PathExpr)params.get(0));
                ExtPhrase extPhrase = phrase;
            }
            if (local.equals("starts-with")) {
                if (params.size() < 2) {
                    throw new XPathException(ast, "XPST0017: Function starts-with() requires two or three arguments");
                }
                if (params.size() > 3) {
                    throw new XPathException(ast, "XPST0017: Function starts-with() requires two or three arguments");
                }
                p0 = (PathExpr)params.get(0);
                p1 = (PathExpr)params.get(1);
                if (p1.getLength() == 0) {
                    throw new XPathException(ast, "Second argument to starts-with is empty");
                }
                op = new GeneralComparison(context, p0, p1, 4, 0);
                op.setASTNode(ast);
                context.getProfiler().message((Expression)parent, Profiler.OPTIMIZATIONS, "OPTIMIZATION", "Rewritten start-with as a general comparison with a right truncature");
                if (params.size() == 3) {
                    op.setCollation((Expression)params.get(2));
                }
                GeneralComparison generalComparison = op;
            }
            if (local.equals("ends-with")) {
                if (params.size() < 2) {
                    throw new XPathException(ast, "XPST0017 : Function ends-with() requires two or three arguments");
                }
                if (params.size() > 3) {
                    throw new XPathException(ast, "XPST0017 : Function ends-with() requires two or three arguments");
                }
                p0 = (PathExpr)params.get(0);
                p1 = (PathExpr)params.get(1);
                if (p1.getLength() == 0) {
                    throw new XPathException(ast, "Second argument to ends-with is empty");
                }
                op = new GeneralComparison(context, p0, p1, 4, 1);
                context.getProfiler().message((Expression)parent, Profiler.OPTIMIZATIONS, "OPTIMIZATION", "Rewritten ends-with as a general comparison with a left truncature");
                op.setASTNode(ast);
                if (params.size() == 3) {
                    op.setCollation((Expression)params.get(2));
                }
                GeneralComparison generalComparison = op;
            }
            if (local.equals("contains")) {
                if (params.size() < 2) {
                    throw new XPathException(ast, "XPST0017: Function contains() requires two or three arguments");
                }
                if (params.size() > 3) {
                    throw new XPathException(ast, "XPST0017: Function contains() requires two or three arguments");
                }
                p0 = (PathExpr)params.get(0);
                p1 = (PathExpr)params.get(1);
                if (p1.getLength() == 0) {
                    throw new XPathException(ast, "Second argument to contains is empty");
                }
                op = new GeneralComparison(context, p0, p1, 4, 2);
                context.getProfiler().message((Expression)parent, Profiler.OPTIMIZATIONS, "OPTIMIZATION", "Rewritten contains as a general comparison with left and right truncatures");
                op.setASTNode(ast);
                if (params.size() == 3) {
                    op.setCollation((Expression)params.get(2));
                }
                GeneralComparison generalComparison = op;
            }
        } else if (uri.equals("http://www.w3.org/2001/XMLSchema") || uri.equals("http://www.w3.org/2003/05/xpath-datatypes")) {
            if (params.size() != 1) {
                throw new XPathException(ast, "Wrong number of arguments for constructor function");
            }
            PathExpr arg = (PathExpr)params.get(0);
            int code = Type.getType(qname);
            CastExpression castExpr = new CastExpression(context, arg, code, 3);
            castExpr.setASTNode(ast);
            CastExpression castExpression = castExpr;
        } else if (uri.startsWith("java:")) {
            String javabinding = (String)context.broker.getConfiguration().getProperty(PROPERTY_ENABLE_JAVA_BINDING);
            if (javabinding == null) throw new XPathException(ast, "Java binding is disabled in the current configuration (see conf.xml). Call to " + qname.getStringValue() + " denied.");
            if (!javabinding.equals("yes")) throw new XPathException(ast, "Java binding is disabled in the current configuration (see conf.xml). Call to " + qname.getStringValue() + " denied.");
            JavaCall call2 = new JavaCall(context, qname);
            call2.setASTNode(ast);
            call2.setArguments(params);
            JavaCall javaCall = call2;
        }
        if (var7_20 != null) return var7_24;
        Module module = context.getModule(uri);
        if (module != null) {
            if (module.isInternalModule()) {
                FunctionDef def = ((InternalModule)module).getFunctionDef(qname, params.size());
                if (def == null) {
                    List funcs = ((InternalModule)module).getFunctionsByName(qname);
                    if (funcs.size() == 0) {
                        throw new XPathException(ast, "Function " + qname.getStringValue() + "() " + " is not defined in module namespace: " + qname.getNamespaceURI());
                    }
                    StringBuffer buf = new StringBuffer();
                    buf.append("Unexpectedly received ");
                    buf.append(params.size() + " parameter(s) in call to function ");
                    buf.append("'" + qname.getStringValue() + "()'. ");
                    buf.append("Defined function signatures are:\r\n");
                    Iterator i = funcs.iterator();
                    while (i.hasNext()) {
                        FunctionSignature sig = (FunctionSignature)i.next();
                        buf.append(sig.toString()).append("\r\n");
                    }
                    throw new XPathException(ast, buf.toString());
                }
                Function func = Function.createFunction(context, ast, def);
                func.setArguments(params);
                InternalFunctionCall internalFunctionCall = new InternalFunctionCall(func);
                return var7_24;
            } else {
                UserDefinedFunction func = ((ExternalModule)module).getFunction(qname, params.size());
                if (func == null) {
                    throw new XPathException(ast, "Function " + qname.getStringValue() + "() is not defined in namespace '" + qname.getNamespaceURI() + "'");
                }
                call = new FunctionCall(context, func);
                call.setArguments(params);
                call.setASTNode(ast);
                FunctionCall functionCall = call;
            }
            return var7_24;
        } else {
            UserDefinedFunction func = context.resolveFunction(qname, params.size());
            if (func != null) {
                call = new FunctionCall(context, func);
                call.setASTNode(ast);
                call.setArguments(params);
            } else {
                call = new FunctionCall(context, qname, params);
                call.setASTNode(ast);
                context.addForwardReference(call);
            }
            FunctionCall functionCall = call;
        }
        return var7_24;
    }
}

