/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.List;
import org.exist.dom.DocumentSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.Pragma;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class ExtensionExpression
extends AbstractExpression {
    private Expression innerExpression;
    private List pragmas = new ArrayList(3);

    public ExtensionExpression(XQueryContext context) {
        super(context);
    }

    public void setExpression(Expression inner) {
        this.innerExpression = inner;
    }

    public void addPragma(Pragma pragma) {
        this.pragmas.add(pragma);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        this.callBefore();
        Sequence result = null;
        for (int i = 0; i < this.pragmas.size(); ++i) {
            Pragma pragma = (Pragma)this.pragmas.get(i);
            Sequence temp = pragma.eval(contextSequence, contextItem);
            if (temp == null) continue;
            if (result != null) {
                throw new XPathException(this.getASTNode(), "Conflicting pragmas: only one should return a result for eval");
            }
            result = temp;
        }
        if (result == null) {
            result = this.innerExpression.eval(contextSequence, contextItem);
        }
        this.callAfter();
        return result;
    }

    private void callAfter() throws XPathException {
        for (int i = 0; i < this.pragmas.size(); ++i) {
            Pragma pragma = (Pragma)this.pragmas.get(i);
            pragma.after(this.context, this.innerExpression);
        }
    }

    private void callBefore() throws XPathException {
        for (int i = 0; i < this.pragmas.size(); ++i) {
            Pragma pragma = (Pragma)this.pragmas.get(i);
            pragma.before(this.context, this.innerExpression);
        }
    }

    public int returnsType() {
        return this.innerExpression.returnsType();
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        AnalyzeContextInfo newContext = new AnalyzeContextInfo(contextInfo);
        for (int i = 0; i < this.pragmas.size(); ++i) {
            Pragma pragma = (Pragma)this.pragmas.get(i);
            pragma.analyze(newContext);
        }
        this.innerExpression.analyze(newContext);
    }

    public void dump(ExpressionDumper dumper) {
        for (int i = 0; i < this.pragmas.size(); ++i) {
            Pragma pragma = (Pragma)this.pragmas.get(i);
            dumper.display("(# " + pragma.getQName().toString(), this.getASTNode());
            if (pragma.getContents() != null) {
                dumper.display(' ').display(pragma.getContents());
            }
            dumper.display("#)").nl();
        }
        dumper.display('{');
        dumper.startIndent();
        this.innerExpression.dump(dumper);
        dumper.endIndent();
        dumper.nl().display('}').nl();
    }

    public int getDependencies() {
        return this.innerExpression.getDependencies();
    }

    public int getCardinality() {
        return this.innerExpression.getCardinality();
    }

    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.innerExpression.setContextDocSet(contextSet);
    }

    public void setPrimaryAxis(int axis) {
        this.innerExpression.setPrimaryAxis(axis);
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.innerExpression.resetState(postOptimization);
        for (int i = 0; i < this.pragmas.size(); ++i) {
            Pragma pragma = (Pragma)this.pragmas.get(i);
            pragma.resetState(postOptimization);
        }
    }

    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this.innerExpression);
    }
}

