/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.memtree.DocumentBuilderReceiver;
import org.exist.memtree.MemTreeBuilder;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.PathExpr;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.xml.sax.SAXException;

public class EnclosedExpr
extends PathExpr {
    public EnclosedExpr(XQueryContext context) {
        super(context);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        this.context.pushDocumentContext();
        Sequence result = super.eval(contextSequence, null);
        this.context.popDocumentContext();
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        DocumentBuilderReceiver receiver = new DocumentBuilderReceiver(builder);
        try {
            SequenceIterator i = result.iterate();
            Item next = i.nextItem();
            StringBuffer buf = null;
            boolean allowAttribs = true;
            while (next != null) {
                this.context.proceed(this, builder);
                if (Type.subTypeOf(next.getType(), 20)) {
                    if (buf == null) {
                        buf = new StringBuffer();
                    } else if (buf.length() > 0) {
                        buf.append(' ');
                    }
                    buf.append(next.getStringValue());
                    allowAttribs = false;
                    next = i.nextItem();
                    continue;
                }
                if (!Type.subTypeOf(next.getType(), -1)) continue;
                if (buf != null && buf.length() > 0) {
                    receiver.characters(buf);
                    buf.setLength(0);
                }
                if (next.getType() == 2 && !allowAttribs) {
                    throw new XPathException(this.getASTNode(), "XQTY0024: An attribute may not appear after another child node.");
                }
                next.copyTo(this.context.getBroker(), receiver);
                allowAttribs = next.getType() == 2;
                next = i.nextItem();
            }
            if (buf != null && buf.length() > 0) {
                receiver.characters(buf);
            }
        }
        catch (SAXException e) {
            LOG.warn((Object)("SAXException during serialization: " + e.getMessage()), (Throwable)e);
            throw new XPathException(this.getASTNode(), e.getMessage());
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display("{");
        dumper.startIndent();
        super.dump(dumper);
        dumper.endIndent();
        dumper.nl().display("}");
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("{");
        result.append(super.toString());
        result.append("}");
        return result.toString();
    }

    public void accept(ExpressionVisitor visitor) {
        visitor.visitPathExpr(this);
    }
}

