/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

public class Cardinality {
    public static final int ZERO = 1;
    public static final int ONE = 2;
    public static final int MANY = 4;
    public static final int EMPTY = 1;
    public static final int EXACTLY_ONE = 2;
    public static final int ONE_OR_MORE = 6;
    public static final int ZERO_OR_MORE = 7;
    public static final int ZERO_OR_ONE = 3;

    public static final String toString(int cardinality) {
        switch (cardinality) {
            case 1: {
                return "empty()";
            }
            case 2: {
                return "";
            }
            case 6: {
                return "+";
            }
            case 7: {
                return "*";
            }
            case 3: {
                return "?";
            }
        }
        throw new IllegalArgumentException("unknown cardinality: " + cardinality);
    }

    public static final String getDescription(int cardinality) {
        switch (cardinality) {
            case 1: {
                return "empty";
            }
            case 2: {
                return "exactly one";
            }
            case 6: {
                return "one or more";
            }
            case 7: {
                return "zero or more";
            }
            case 3: {
                return "zero or one";
            }
            case 4: {
                return "many";
            }
        }
        throw new IllegalArgumentException("unknown cardinality: " + cardinality);
    }

    public static final boolean checkCardinality(int required, int cardinality) {
        return (required & cardinality) == cardinality;
    }
}

