/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.exist.dom.QName;
import org.exist.util.Occurrences;
import org.exist.xmldb.IndexQueryService;
import org.exist.xmldb.RemoteCollection;
import org.exist.xmldb.XmldbURI;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class RemoteIndexQueryService
implements IndexQueryService {
    protected XmlRpcClient rpcClient = null;
    protected RemoteCollection parent;

    public RemoteIndexQueryService(XmlRpcClient client, RemoteCollection parent) {
        this.rpcClient = client;
        this.parent = parent;
    }

    public void reindexCollection() throws XMLDBException {
        this.reindexCollection(this.parent.getPath());
    }

    public void reindexCollection(String collectionPath) throws XMLDBException {
        try {
            this.reindexCollection(XmldbURI.xmldbUriFor(collectionPath));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    public void reindexCollection(XmldbURI collectionPath) throws XMLDBException {
        if (this.parent != null) {
            collectionPath = this.parent.getPathURI().resolveCollectionPath(collectionPath);
        }
        ArrayList<String> params = new ArrayList<String>(1);
        params.add(collectionPath.toString());
        try {
            this.rpcClient.execute("reindexCollection", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(0, "xmlrpc error while doing reindexCollection: ", (Throwable)e);
        }
    }

    public Occurrences[] getIndexedElements(boolean inclusive) throws XMLDBException {
        try {
            ArrayList<Object> params = new ArrayList<Object>(1);
            params.add(this.parent.getPath());
            params.add(inclusive);
            Object[] result = (Object[])this.rpcClient.execute("getIndexedElements", params);
            Occurrences[] occurrences = new Occurrences[result.length];
            for (int i = 0; i < occurrences.length; ++i) {
                Object[] row = (Object[])result[i];
                QName qname = new QName((String)row[0], (String)row[1], (String)row[2]);
                occurrences[i] = new Occurrences(qname);
                occurrences[i].addOccurrences((Integer)row[3]);
            }
            return occurrences;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(0, "xmlrpc error while retrieving indexed elements", (Throwable)e);
        }
    }

    public Occurrences[] scanIndexTerms(String start, String end, boolean inclusive) throws XMLDBException {
        try {
            ArrayList<Object> params = new ArrayList<Object>(1);
            params.add(this.parent.getPath());
            params.add(start);
            params.add(end);
            params.add(inclusive);
            Object[] result = (Object[])this.rpcClient.execute("scanIndexTerms", params);
            Occurrences[] occurrences = new Occurrences[result.length];
            for (int i = 0; i < occurrences.length; ++i) {
                Object[] row = (Object[])result[i];
                occurrences[i] = new Occurrences((Comparable)((Object)((String)row[0])));
                occurrences[i].addOccurrences((Integer)row[1]);
            }
            return occurrences;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(0, "xmlrpc error while retrieving indexed elements", (Throwable)e);
        }
    }

    public Occurrences[] scanIndexTerms(String xpath, String start, String end) throws XMLDBException {
        try {
            ArrayList<String> params = new ArrayList<String>(1);
            params.add(xpath);
            params.add(start);
            params.add(end);
            Object[] result = (Object[])this.rpcClient.execute("scanIndexTerms", params);
            Occurrences[] occurrences = new Occurrences[result.length];
            for (int i = 0; i < occurrences.length; ++i) {
                Object[] row = (Object[])result[i];
                occurrences[i] = new Occurrences((Comparable)((Object)((String)row[0])));
                occurrences[i].addOccurrences((Integer)row[1]);
            }
            return occurrences;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(0, "xmlrpc error while retrieving indexed elements", (Throwable)e);
        }
    }

    public String getName() throws XMLDBException {
        return "IndexQueryService";
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    public void setCollection(Collection col) throws XMLDBException {
        this.parent = (RemoteCollection)col;
    }

    public String getProperty(String name) throws XMLDBException {
        return null;
    }

    public void setProperty(String name, String value) throws XMLDBException {
    }

    public void configureCollection(String configData) throws XMLDBException {
        String path = this.parent.getPath();
        ArrayList<String> params = new ArrayList<String>(1);
        params.add(path);
        params.add(configData);
        try {
            this.rpcClient.execute("configureCollection", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(0, "xmlrpc error while doing reindexCollection: ", (Throwable)e);
        }
    }
}

