/*
 * Decompiled with CFR 0.152.
 */
package org.exist.webstart;

import java.io.File;
import org.apache.log4j.Logger;
import org.exist.start.LatestFileResolver;
import org.exist.webstart.JnlpHelper;

public class JnlpJarFiles {
    private static Logger logger = Logger.getLogger((Class)JnlpJarFiles.class);
    private File[] _coreJars;
    private File _mainJar;
    private String[] jars = new String[]{"xmldb", "xmlrpc-common-%latest%", "xmlrpc-client-%latest%", "ws-commons-util-%latest%", "commons-pool-%latest%", "excalibur-cli-%latest%", "jEdit-syntax", "jline-%latest%", "log4j-%latest%", "stax-api-%latest%", "sunxacml"};
    private LatestFileResolver jarFileResolver = new LatestFileResolver();

    public File getJar(File folder, String jarFileBaseName) {
        String fileToFind = folder.getAbsolutePath() + File.separatorChar + jarFileBaseName + ".jar";
        String resolvedFile = this.jarFileResolver.getResolvedFileName(fileToFind);
        File jar = new File(resolvedFile);
        if (jar.exists()) {
            logger.debug((Object)("Found match: " + resolvedFile + " for file pattern: " + fileToFind));
            return jar;
        }
        logger.error((Object)("Could not resolve file pattern: " + fileToFind));
        return null;
    }

    public JnlpJarFiles(JnlpHelper jnlpHelper) {
        logger.info((Object)"Initializing jar files Webstart");
        int nrCoreJars = this.jars.length;
        this._coreJars = new File[nrCoreJars];
        logger.debug((Object)("Number of webstart jars=" + nrCoreJars));
        for (int i = 0; i < nrCoreJars; ++i) {
            this._coreJars[i] = this.getJar(jnlpHelper.getCoreJarsFolder(), this.jars[i]);
        }
        this._mainJar = new File(jnlpHelper.getExistJarFolder(), "exist.jar");
    }

    public File[] getCoreJars() {
        return this._coreJars;
    }

    public File getMainJar() {
        return this._mainJar;
    }

    public void setMainJar(File mainJar) {
        this._mainJar = mainJar;
    }

    public File getFile(String name) {
        File retVal = null;
        if (name.equals("exist.jar")) {
            retVal = this._mainJar;
        } else {
            boolean found = false;
            int index = 0;
            while (!found && index < this._coreJars.length) {
                if (this._coreJars[index].getName().equals(name)) {
                    found = true;
                    retVal = this._coreJars[index];
                    continue;
                }
                ++index;
            }
        }
        return retVal;
    }
}

