/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation.service;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.validation.ValidationReport;
import org.exist.validation.Validator;
import org.exist.validation.service.ValidationService;
import org.exist.xmldb.LocalCollection;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class LocalValidationService
implements ValidationService {
    private static Logger logger = Logger.getLogger((Class)LocalValidationService.class);
    private BrokerPool brokerPool;
    private User user;
    private LocalCollection localCollection;
    private Validator validator;

    public LocalValidationService(User user, BrokerPool pool, LocalCollection collection) {
        logger.info((Object)"Starting LocalValidationService");
        this.user = user;
        this.brokerPool = pool;
        this.localCollection = collection;
        this.validator = new Validator(pool);
    }

    public boolean validateResource(String id) throws XMLDBException {
        return this.validateResource(id, null);
    }

    public boolean validateResource(String documentPath, String grammarPath) throws XMLDBException {
        if (documentPath.startsWith("/")) {
            documentPath = "xmldb:exist://" + documentPath;
        }
        if (grammarPath != null && grammarPath.startsWith("/")) {
            grammarPath = "xmldb:exist://" + grammarPath;
        }
        logger.info((Object)("Validating resource '" + documentPath + "'"));
        InputStream is = null;
        try {
            is = new URL(documentPath).openStream();
        }
        catch (MalformedURLException ex) {
            logger.error((Object)ex);
            throw new XMLDBException(5, (Throwable)ex);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new XMLDBException(0, (Throwable)ex);
        }
        if (is == null) {
            logger.error((Object)"Resource not found");
            throw new XMLDBException(300, "Resource not found");
        }
        ValidationReport report = null;
        report = grammarPath == null ? this.validator.validate(is) : this.validator.validate(is, grammarPath);
        logger.info((Object)"Validation done.");
        return report.isValid();
    }

    public void setCollection(Collection collection) throws XMLDBException {
    }

    public String getName() throws XMLDBException {
        return "ValidationService";
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    public void setProperty(String str, String str1) throws XMLDBException {
    }

    public String getProperty(String str) throws XMLDBException {
        return null;
    }
}

