/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.log4j.Logger;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.exist.protocolhandler.embedded.EmbeddedInputStream;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.protocolhandler.xmlrpc.XmlrpcInputStream;

public class AnyUriResolver
implements XMLEntityResolver {
    private static final Logger LOG = Logger.getLogger((Class)AnyUriResolver.class);
    private String docPath;
    private String parentURI;
    private boolean firstTime = true;

    public AnyUriResolver(String path) {
        this.docPath = path;
        if (this.docPath.startsWith("/")) {
            this.docPath = "xmldb:exist://" + this.docPath;
        }
        LOG.debug((Object)("Specified path=" + path));
        if (path.lastIndexOf(47) != -1) {
            this.parentURI = path.substring(0, path.lastIndexOf(47));
            LOG.debug((Object)("parentURI=" + this.parentURI));
        } else {
            this.parentURI = "";
        }
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier xri) throws XNIException, IOException {
        XmldbURL xmldbURL;
        if (xri.getExpandedSystemId() == null && xri.getLiteralSystemId() == null && xri.getNamespace() == null && xri.getPublicId() == null) {
            return null;
        }
        LOG.debug((Object)("Resolving XMLResourceIdentifier: " + this.getXriDetails(xri)));
        String resourcePath = null;
        String baseSystemId = null;
        if (this.firstTime) {
            resourcePath = this.docPath;
            baseSystemId = this.parentURI;
            this.firstTime = false;
        } else {
            resourcePath = xri.getExpandedSystemId();
            baseSystemId = xri.getBaseSystemId();
        }
        LOG.debug((Object)("resourcePath='" + resourcePath + "'"));
        InputStream is = null;
        is = resourcePath.startsWith("xmldb:") ? ((xmldbURL = new XmldbURL(resourcePath)).isEmbedded() ? new EmbeddedInputStream(xmldbURL) : new XmlrpcInputStream(xmldbURL)) : new URL(resourcePath).openStream();
        XMLInputSource xis = new XMLInputSource(xri.getPublicId(), resourcePath, baseSystemId, is, "UTF-8");
        LOG.debug((Object)("XMLInputSource: " + this.getXisDetails(xis)));
        return xis;
    }

    private String getXriDetails(XMLResourceIdentifier xrid) {
        StringBuffer sb = new StringBuffer();
        sb.append("PublicId='").append(xrid.getPublicId()).append("' ");
        sb.append("BaseSystemId='").append(xrid.getBaseSystemId()).append("' ");
        sb.append("ExpandedSystemId='").append(xrid.getExpandedSystemId()).append("' ");
        sb.append("LiteralSystemId='").append(xrid.getLiteralSystemId()).append("' ");
        sb.append("Namespace='").append(xrid.getNamespace()).append("' ");
        return sb.toString();
    }

    private String getXisDetails(XMLInputSource xis) {
        StringBuffer sb = new StringBuffer();
        sb.append("PublicId='").append(xis.getPublicId()).append("' ");
        sb.append("SystemId='").append(xis.getSystemId()).append("' ");
        sb.append("BaseSystemId='").append(xis.getBaseSystemId()).append("' ");
        sb.append("Encoding='").append(xis.getEncoding()).append("' ");
        return sb.toString();
    }
}

