/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import org.apache.log4j.Logger;
import org.xml.sax.XMLReader;

public class XmlLibraryChecker {
    private static final ClassVersion[] validParsers = new ClassVersion[]{new ClassVersion("Xerces", "Xerces-J 2.9.1", "org.apache.xerces.impl.Version.getVersion()")};
    private static final ClassVersion[] validTransformers = new ClassVersion[]{new ClassVersion("Saxon", "8.9.0", "net.sf.saxon.Version.getProductVersion()"), new ClassVersion("Xalan", "Xalan Java 2.7.1", "org.apache.xalan.Version.getVersion()")};
    private static final ClassVersion[] validResolvers = new ClassVersion[]{new ClassVersion("Resolver", "XmlResolver 1.2", "org.apache.xml.resolver.Version.getVersion()")};
    private static final Logger logger = Logger.getLogger((Class)XmlLibraryChecker.class);

    private static String getClassName(String classid) {
        int lastChar = classid.lastIndexOf("@");
        String className = lastChar == -1 ? classid : classid.substring(0, lastChar);
        return className;
    }

    private static String determineActualParserClass() {
        String parserClass = "Unable to determine parser class";
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            XMLReader xmlReader = factory.newSAXParser().getXMLReader();
            String classId = xmlReader.toString();
            parserClass = XmlLibraryChecker.getClassName(classId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return parserClass;
    }

    private static String determineActualTransformerClass() {
        String transformerClass = "Unable to determine transformer class";
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            String classId = transformer.toString();
            transformerClass = XmlLibraryChecker.getClassName(classId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return transformerClass;
    }

    public static void check() {
        StringBuffer message = new StringBuffer();
        boolean invalidVersionFound = false;
        if (XmlLibraryChecker.hasValidClassVersion("Parser", validParsers, message)) {
            logger.info((Object)message.toString());
        } else {
            logger.warn((Object)message.toString());
            System.err.println(message.toString());
            invalidVersionFound = true;
        }
        message = new StringBuffer();
        if (XmlLibraryChecker.hasValidClassVersion("Transformer", validTransformers, message)) {
            logger.info((Object)message.toString());
        } else {
            logger.warn((Object)message.toString());
            System.err.println(message.toString());
            invalidVersionFound = true;
        }
        message = new StringBuffer();
        if (XmlLibraryChecker.hasValidClassVersion("Resolver", validResolvers, message)) {
            logger.info((Object)message.toString());
        } else {
            logger.warn((Object)message.toString());
            System.err.println(message.toString());
            invalidVersionFound = true;
        }
        logger.info((Object)("Using parser " + XmlLibraryChecker.determineActualParserClass()));
        logger.info((Object)("Using transformer " + XmlLibraryChecker.determineActualTransformerClass()));
        if (invalidVersionFound) {
            System.err.println("Using parser " + XmlLibraryChecker.determineActualParserClass());
            System.err.println("Using transformer " + XmlLibraryChecker.determineActualTransformerClass());
            System.err.println();
        }
    }

    public static boolean hasValidClassVersion(String type, ClassVersion[] validClasses, StringBuffer message) {
        String sep = System.getProperty("line.separator");
        message.append("Looking for a valid " + type + "..." + sep);
        for (int i = 0; i < validClasses.length; ++i) {
            String actualVersion = validClasses[i].getActualVersion();
            message.append("Checking for " + validClasses[i].getSimpleName());
            if (actualVersion != null) {
                message.append(", found version " + actualVersion);
                if (actualVersion.compareToIgnoreCase(validClasses[i].getRequiredVersion()) >= 0) {
                    message.append(sep + "OK!" + sep);
                    return true;
                }
                message.append(" needed version " + validClasses[i].getRequiredVersion() + sep);
                continue;
            }
            message.append(", not found!" + sep);
        }
        message.append("Warning: Failed find a valid " + type + "!" + sep);
        message.append(sep + "Please add an appropriate " + type + " to the " + "class-path, e.g. in the 'endorsed' folder of " + "the servlet container or in the 'endorsed' folder " + "of the JRE." + sep);
        return false;
    }

    public static boolean hasValidParser() {
        return XmlLibraryChecker.hasValidParser(new StringBuffer());
    }

    public static boolean hasValidParser(StringBuffer message) {
        return XmlLibraryChecker.hasValidClassVersion("Parser", validParsers, message);
    }

    public static boolean hasValidTransformer() {
        return XmlLibraryChecker.hasValidTransformer(new StringBuffer());
    }

    public static boolean hasValidTransformer(StringBuffer message) {
        return XmlLibraryChecker.hasValidClassVersion("Transformer", validTransformers, message);
    }

    public static class ClassVersion {
        private String simpleName;
        private String requiredVersion;
        private String versionFunction;

        ClassVersion(String simpleName, String requiredVersion, String versionFunction) {
            this.simpleName = simpleName;
            this.requiredVersion = requiredVersion;
            this.versionFunction = versionFunction;
        }

        public String getSimpleName() {
            return this.simpleName;
        }

        public String getRequiredVersion() {
            return this.requiredVersion;
        }

        public String getActualVersion() {
            String actualVersion = null;
            String versionClassName = this.versionFunction.substring(0, this.versionFunction.lastIndexOf(46));
            String versionFunctionName = this.versionFunction.substring(this.versionFunction.lastIndexOf(46) + 1, this.versionFunction.lastIndexOf(40));
            try {
                Class<?> versionClass = Class.forName(versionClassName);
                Method getVersionMethod = versionClass.getMethod(versionFunctionName, null);
                actualVersion = (String)getVersionMethod.invoke(versionClass, (Object[])null);
            }
            catch (ClassNotFoundException cfe) {
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (InvocationTargetException ite) {
            }
            catch (IllegalAccessException iae) {
                // empty catch block
            }
            return actualVersion;
        }
    }
}

