/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer;

import org.exist.dom.QName;
import org.exist.dom.StoredNode;
import org.exist.util.serializer.AttrList;
import org.exist.util.serializer.Receiver;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class ReceiverToSAX
implements Receiver {
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler = null;
    private char[] charBuf = new char[2048];

    public ReceiverToSAX(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public void startDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.contentHandler.endDocument();
    }

    public void startPrefixMapping(String prefix, String namespaceURI) throws SAXException {
        this.contentHandler.startPrefixMapping(prefix, namespaceURI);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.contentHandler.endPrefixMapping(prefix);
    }

    public void startElement(QName qname, AttrList attribs) throws SAXException {
        AttributesImpl a = new AttributesImpl();
        if (attribs != null) {
            for (int i = 0; i < attribs.getLength(); ++i) {
                QName attrQName = attribs.getQName(i);
                a.addAttribute(attrQName.getNamespaceURI(), attrQName.getLocalName(), attrQName.getStringValue(), "CDATA", attribs.getValue(i));
            }
        }
        this.contentHandler.startElement(qname.getNamespaceURI(), qname.getLocalName(), qname.getStringValue(), a);
    }

    public void endElement(QName qname) throws SAXException {
        this.contentHandler.endElement(qname.getNamespaceURI(), qname.getLocalName(), qname.getStringValue());
    }

    public void characters(CharSequence seq) throws SAXException {
        int len = seq.length();
        if (len < this.charBuf.length) {
            for (int i = 0; i < len; ++i) {
                this.charBuf[i] = seq.charAt(i);
            }
            this.contentHandler.characters(this.charBuf, 0, len);
        } else {
            this.contentHandler.characters(((Object)seq).toString().toCharArray(), 0, seq.length());
        }
    }

    public void attribute(QName qname, String value) throws SAXException {
        this.contentHandler.characters(value.toCharArray(), 0, value.length());
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(ch, start, length);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.contentHandler.processingInstruction(target, data);
    }

    public void cdataSection(char[] ch, int start, int len) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
        this.contentHandler.characters(ch, start, len);
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    public void documentType(String name, String publicId, String systemId) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startDTD(name, publicId, systemId);
            this.lexicalHandler.endDTD();
        }
    }

    public void highlightText(CharSequence seq) {
    }

    public void setCurrentNode(StoredNode node) {
    }

    public Document getDocument() {
        return null;
    }
}

