/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.sanity;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.Logger;
import org.exist.util.sanity.AssertFailure;

public class SanityCheck {
    private static final Logger LOG = Logger.getLogger((Class)SanityCheck.class);

    public static final void ASSERT(boolean mustBeTrue) {
        if (!mustBeTrue) {
            AssertFailure failure = new AssertFailure("ASSERT FAILED");
            SanityCheck.showTrace(failure);
        }
    }

    public static final void ASSERT(boolean mustBeTrue, String failureMsg) {
        if (!mustBeTrue) {
            AssertFailure failure = new AssertFailure("ASSERT FAILED: " + failureMsg);
            SanityCheck.showTrace(failure);
        }
    }

    public static final void THROW_ASSERT(boolean mustBeTrue) {
        if (!mustBeTrue) {
            AssertFailure failure = new AssertFailure("ASSERT FAILED");
            SanityCheck.showTrace(failure);
            throw failure;
        }
    }

    public static final void THROW_ASSERT(boolean mustBeTrue, String failureMsg) {
        if (!mustBeTrue) {
            AssertFailure failure = new AssertFailure("ASSERT FAILED: " + failureMsg);
            SanityCheck.showTrace(failure);
            throw failure;
        }
    }

    public static final void TRACE(String msg) {
        AssertFailure failure = new AssertFailure("TRACE: " + msg);
        SanityCheck.showTrace(failure);
    }

    public static final void PRINT_STACK(int level) {
        StackTraceElement[] elements = new Exception("Trace").getStackTrace();
        if (level > elements.length) {
            level = elements.length;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 1; i < level; ++i) {
            buf.append('\n');
            buf.append(elements[i].toString());
        }
        LOG.debug((Object)buf.toString());
    }

    private static final void showTrace(AssertFailure failure) {
        StringWriter sout = new StringWriter();
        PrintWriter out = new PrintWriter(sout);
        out.println("Stacktrace:");
        failure.printStackTrace(out);
        LOG.warn((Object)sout.toString());
    }
}

