/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.hashtable;

import java.util.Iterator;
import org.exist.dom.QName;
import org.exist.util.hashtable.AbstractHashtable;

public class NamePool
extends AbstractHashtable {
    private static final QName REMOVED = new QName("REMOVED", "");
    private QName[] values;

    public NamePool() {
        this.values = new QName[this.tabSize];
    }

    public NamePool(int iSize) {
        super(iSize);
        this.values = new QName[this.tabSize];
    }

    public synchronized int size() {
        return this.items;
    }

    public synchronized Object get(int pos) {
        QName obj = this.values[pos];
        return obj == null || obj == REMOVED ? null : obj;
    }

    public synchronized int add(QName value) {
        try {
            return this.insert(value);
        }
        catch (AbstractHashtable.HashtableOverflowException e) {
            throw new RuntimeException("The size of the internal name pool is exceeded!");
        }
    }

    protected int insert(QName value) throws AbstractHashtable.HashtableOverflowException {
        if (value == null) {
            throw new IllegalArgumentException("Illegal value: null");
        }
        int idx = NamePool.hash(value) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        int bucket = -1;
        if (this.values[idx] == null) {
            this.values[idx] = value;
            ++this.items;
            return idx;
        }
        if (this.values[idx] == REMOVED) {
            bucket = idx;
        } else if (NamePool.eq(this.values[idx], value)) {
            return idx;
        }
        int rehashVal = this.rehash(idx);
        int rehashCnt = 1;
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.values[idx = (idx + rehashVal) % this.tabSize] == REMOVED) {
                bucket = idx;
            } else {
                if (this.values[idx] == null) {
                    if (bucket > -1) {
                        idx = bucket;
                    }
                    this.values[idx] = value;
                    ++this.items;
                    return idx;
                }
                if (NamePool.eq(this.values[idx], value)) {
                    return idx;
                }
            }
            ++rehashCnt;
        }
        if (bucket > -1) {
            this.values[bucket] = value;
            ++this.items;
            return bucket;
        }
        throw new AbstractHashtable.HashtableOverflowException();
    }

    public synchronized void remove(QName value) {
        int idx = NamePool.hash(value) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.values[idx] == null) {
            return;
        }
        if (NamePool.eq(this.values[idx], value)) {
            this.values[idx] = REMOVED;
            --this.items;
            return;
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.values[idx = (idx + rehashVal) % this.tabSize] == null) {
                return;
            }
            if (!NamePool.eq(this.values[idx], value)) continue;
            this.values[idx] = REMOVED;
            --this.items;
            return;
        }
    }

    private static final boolean eq(QName q1, QName q2) {
        if (q1.getNameType() == q2.getNameType()) {
            return q1.equals(q2);
        }
        return false;
    }

    protected int rehash(int iVal) {
        int retVal = (iVal + iVal / 2) % this.tabSize;
        if (retVal == 0) {
            retVal = 1;
        }
        return retVal;
    }

    protected static final int hash(Object o) {
        return o.hashCode();
    }

    public Iterator iterator() {
        return new SymbolTableIterator();
    }

    public Iterator valueIterator() {
        return new SymbolTableIterator();
    }

    private class SymbolTableIterator
    implements Iterator {
        private int idx = 0;

        private SymbolTableIterator() {
        }

        public boolean hasNext() {
            if (this.idx == NamePool.this.tabSize) {
                return false;
            }
            while (NamePool.this.values[this.idx] == null || NamePool.this.values[this.idx] == REMOVED) {
                ++this.idx;
                if (this.idx != NamePool.this.tabSize) continue;
                return false;
            }
            return true;
        }

        public Object next() {
            if (this.idx == NamePool.this.tabSize) {
                return null;
            }
            while (NamePool.this.values[this.idx] == null || NamePool.this.values[this.idx] == REMOVED) {
                ++this.idx;
                if (this.idx != NamePool.this.tabSize) continue;
                return null;
            }
            return NamePool.this.values[this.idx++];
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove is not implemented");
        }
    }
}

