/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.exist.dom.NodeProxy;
import org.exist.util.SwapVals;

public final class InsertionSort {
    public static final void sortByNodeId(NodeProxy[] a, int lo0, int hi0) {
        if (lo0 >= hi0) {
            return;
        }
        if (a[lo0].compareTo(a[lo0 + 1]) > 0) {
            SwapVals.swap(a, lo0, lo0 + 1);
        }
        if (lo0 + 1 == hi0) {
            return;
        }
        for (int i = lo0 + 1; i < hi0; ++i) {
            NodeProxy temp = a[i + 1];
            if (temp.compareTo(a[i]) >= 0) continue;
            for (int j = i; j >= lo0 && temp.compareTo(a[j]) < 0; --j) {
                a[j + 1] = a[j];
            }
            a[j + 1] = temp;
        }
    }

    public static final void sort(Comparable[] a, int lo0, int hi0) {
        if (lo0 >= hi0) {
            return;
        }
        if (a[lo0].compareTo(a[lo0 + 1]) > 0) {
            SwapVals.swap(a, lo0, lo0 + 1);
        }
        if (lo0 + 1 == hi0) {
            return;
        }
        for (int i = lo0 + 1; i < hi0; ++i) {
            Comparable temp = a[i + 1];
            if (temp.compareTo(a[i]) >= 0) continue;
            for (int j = i; j >= lo0 && temp.compareTo(a[j]) < 0; --j) {
                a[j + 1] = a[j];
            }
            a[j + 1] = temp;
        }
    }

    public static final void sort(Comparable[] a, int lo0, int hi0, int[] b) {
        if (lo0 >= hi0) {
            return;
        }
        if (a[lo0].compareTo(a[lo0 + 1]) > 0) {
            SwapVals.swap(a, lo0, lo0 + 1);
            if (b != null) {
                SwapVals.swap(b, lo0, lo0 + 1);
            }
        }
        if (lo0 + 1 == hi0) {
            return;
        }
        for (int i = lo0 + 1; i < hi0; ++i) {
            Comparable tempa = a[i + 1];
            if (tempa.compareTo(a[i]) >= 0) continue;
            int tempb = 0;
            if (b != null) {
                tempb = b[i + 1];
            }
            for (int j = i; j >= lo0 && tempa.compareTo(a[j]) < 0; --j) {
                a[j + 1] = a[j];
                if (b == null) continue;
                b[j + 1] = b[j];
            }
            a[j + 1] = tempa;
            if (b == null) continue;
            b[j + 1] = tempb;
        }
    }

    public static final void sort(Object[] a, Comparator comp, int lo0, int hi0) {
        if (lo0 >= hi0) {
            return;
        }
        if (comp.compare(a[lo0], a[lo0 + 1]) > 0) {
            SwapVals.swap(a, lo0, lo0 + 1);
        }
        if (lo0 + 1 == hi0) {
            return;
        }
        for (int i = lo0 + 1; i < hi0; ++i) {
            Object temp = a[i + 1];
            if (comp.compare(temp, a[i]) >= 0) continue;
            for (int j = i; j >= lo0 && comp.compare(temp, a[j]) < 0; --j) {
                a[j + 1] = a[j];
            }
            a[j + 1] = temp;
        }
    }

    public static final void sort(List a, int lo0, int hi0) {
        if (lo0 >= hi0) {
            return;
        }
        if (((Comparable)a.get(lo0)).compareTo(a.get(lo0 + 1)) > 0) {
            SwapVals.swap(a, lo0, lo0 + 1);
        }
        if (lo0 + 1 == hi0) {
            return;
        }
        for (int i = lo0 + 1; i < hi0; ++i) {
            int j;
            Comparable temp = (Comparable)a.get(i + 1);
            if (temp.compareTo(a.get(i)) >= 0) continue;
            for (j = i; j >= lo0 && temp.compareTo(a.get(j)) < 0; --j) {
                a.set(j + 1, a.get(j));
            }
            a.set(j + 1, temp);
        }
    }

    public static final void sort(long[] a, int lo0, int hi0, Object[] b) {
        if (lo0 >= hi0) {
            return;
        }
        if (a[lo0] > a[lo0 + 1]) {
            SwapVals.swap(a, lo0, lo0 + 1);
            if (b != null) {
                SwapVals.swap(b, lo0, lo0 + 1);
            }
        }
        if (lo0 + 1 == hi0) {
            return;
        }
        for (int i = lo0 + 1; i < hi0; ++i) {
            long tempa = a[i + 1];
            if (tempa >= a[i]) continue;
            Object tempb = null;
            if (b != null) {
                tempb = b[i + 1];
            }
            for (int j = i; j >= lo0 && tempa < a[j]; --j) {
                a[j + 1] = a[j];
                if (b == null) continue;
                b[j + 1] = b[j];
            }
            a[j + 1] = tempa;
            if (b == null) continue;
            b[j + 1] = tempb;
        }
    }

    public static void main(String[] args) throws Exception {
        ArrayList<String> l = new ArrayList<String>();
        if (args.length == 0) {
            String[] a = new String[]{"Rudi", "Herbert", "Anton", "Berta", "Olga", "Willi", "Heinz"};
            for (int i = 0; i < a.length; ++i) {
                l.add(a[i]);
            }
        } else {
            System.err.println("Ordering file " + args[0] + "\n");
            try {
                String rr;
                BufferedReader is = new BufferedReader(new FileReader(args[0]));
                while ((rr = is.readLine()) != null) {
                    l.add(rr);
                }
                is.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        long a = System.currentTimeMillis();
        InsertionSort.sort(l, 0, l.size() - 1);
        long b = System.currentTimeMillis();
        System.err.println("Ellapsed time: " + (b - a) + " size: " + l.size());
        for (int i = 0; i < l.size(); ++i) {
            System.out.println(l.get(i));
        }
    }
}

