/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.io.File;
import java.net.URL;
import org.apache.log4j.Logger;
import org.exist.storage.BrokerPool;

public class ConfigurationHelper {
    private static final Logger LOG = Logger.getLogger((Class)ConfigurationHelper.class);

    public static File getExistHome() {
        File existHome = null;
        try {
            BrokerPool broker = BrokerPool.getInstance();
            if (broker != null) {
                existHome = broker.getConfiguration().getExistHome();
                LOG.debug((Object)("Got eXist home from broker: " + existHome));
                return existHome;
            }
        }
        catch (Throwable e) {
            LOG.debug((Object)("Could not retieve instance of brokerpool: " + e.getMessage()));
        }
        String config = "conf.xml";
        if (System.getProperty("exist.home") != null && (existHome = new File(ConfigurationHelper.decodeUserHome(System.getProperty("exist.home")))).isDirectory()) {
            LOG.debug((Object)("Got eXist home from system property 'exist.home': " + existHome));
            return existHome;
        }
        existHome = new File(System.getProperty("user.home"));
        if (existHome.isDirectory() && new File(existHome, config).isFile()) {
            LOG.debug((Object)("Got eXist home from system property 'user.home': " + existHome));
            return existHome;
        }
        existHome = new File(System.getProperty("user.dir"));
        if (existHome.isDirectory() && new File(existHome, config).isFile()) {
            LOG.debug((Object)("Got eXist home from system property 'user.dir': " + existHome));
            return existHome;
        }
        URL configUrl = ConfigurationHelper.class.getClassLoader().getResource(config);
        if (configUrl != null) {
            existHome = new File(configUrl.getPath()).getParentFile();
            LOG.debug((Object)("Got eXist home from classpath: " + existHome));
            return existHome;
        }
        existHome = null;
        return existHome;
    }

    public static File lookup(String path) {
        return ConfigurationHelper.lookup(path, null);
    }

    public static File lookup(String path, String parent) {
        File f = new File(ConfigurationHelper.decodeUserHome(path));
        if (f.isAbsolute()) {
            return f;
        }
        if (parent == null) {
            File home = ConfigurationHelper.getExistHome();
            if (home == null) {
                home = new File(System.getProperty("user.dir"));
            }
            parent = home.getPath();
        }
        return new File(parent, path);
    }

    public static String decodeUserHome(String path) {
        if (path != null && path.startsWith("~") && path.length() > 1) {
            path = System.getProperty("user.home") + path.substring(1);
        }
        return path;
    }
}

