/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.exist.memtree.SAXAdapter;
import org.exist.protocolhandler.eXistURLStreamHandlerFactory;
import org.exist.scheduler.JobException;
import org.exist.security.User;
import org.exist.storage.IndexSpec;
import org.exist.util.ConfigurationHelper;
import org.exist.util.DatabaseConfigurationException;
import org.exist.validation.GrammarPool;
import org.exist.validation.resolver.eXistXMLCatalogResolver;
import org.exist.xquery.XQueryContext;
import org.quartz.SimpleTrigger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class Configuration
implements ErrorHandler {
    private static final Logger LOG = Logger.getLogger((Class)Configuration.class);
    protected String configFilePath = null;
    protected File existHome = null;
    protected DocumentBuilder builder = null;
    protected HashMap config = new HashMap();

    public Configuration() throws DatabaseConfigurationException {
        this("conf.xml", null);
    }

    public Configuration(String configFilename) throws DatabaseConfigurationException {
        this(configFilename, null);
    }

    public Configuration(String configFilename, String existHomeDirname) throws DatabaseConfigurationException {
        try {
            NodeList validations;
            NodeList clusters;
            NodeList xacml;
            NodeList xquery;
            NodeList xupdates;
            NodeList serializers;
            NodeList transformers;
            NodeList dbcon;
            NodeList schedulers;
            InputStream is = null;
            if (configFilename == null) {
                configFilename = "conf.xml";
            }
            try {
                is = Configuration.class.getClassLoader().getResourceAsStream(configFilename);
                if (is != null) {
                    LOG.info((Object)"Reading configuration from classloader");
                }
            }
            catch (Exception e) {
                LOG.debug((Object)e);
            }
            if (is == null) {
                File configFile;
                File absoluteConfigFile;
                File file = this.existHome = existHomeDirname != null ? new File(existHomeDirname) : ConfigurationHelper.getExistHome();
                if (this.existHome == null && (absoluteConfigFile = new File(configFilename)).isAbsolute() && absoluteConfigFile.exists() && absoluteConfigFile.canRead()) {
                    this.existHome = absoluteConfigFile.getParentFile();
                    configFilename = absoluteConfigFile.getName();
                }
                if (!(configFile = new File(configFilename)).isAbsolute() && this.existHome != null) {
                    configFile = new File(this.existHome, configFilename);
                }
                if (configFile == null) {
                    configFile = ConfigurationHelper.lookup(configFilename);
                }
                if (!configFile.exists() || !configFile.canRead()) {
                    throw new DatabaseConfigurationException("Unable to read configuration file at " + configFile);
                }
                this.configFilePath = configFile.getAbsolutePath();
                is = new FileInputStream(configFile);
                existHomeDirname = configFile.getParentFile().getCanonicalPath();
                LOG.info((Object)("Reading configuration from file " + configFile));
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            InputSource src = new InputSource(is);
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            SAXAdapter adapter = new SAXAdapter();
            reader.setContentHandler(adapter);
            reader.parse(src);
            Document doc = adapter.getDocument();
            NodeList indexers = doc.getElementsByTagName("indexer");
            if (indexers.getLength() > 0) {
                this.configureIndexer(existHomeDirname, doc, (Element)indexers.item(0));
            }
            if ((schedulers = doc.getElementsByTagName("scheduler")).getLength() > 0) {
                this.configureScheduler((Element)schedulers.item(0));
            }
            if ((dbcon = doc.getElementsByTagName("db-connection")).getLength() > 0) {
                this.configureBackend(existHomeDirname, (Element)dbcon.item(0));
            }
            if ((transformers = doc.getElementsByTagName("transformer")).getLength() > 0) {
                this.configureTransformer((Element)transformers.item(0));
            }
            if ((serializers = doc.getElementsByTagName("serializer")).getLength() > 0) {
                this.configureSerializer((Element)serializers.item(0));
            }
            if ((xupdates = doc.getElementsByTagName("xupdate")).getLength() > 0) {
                this.configureXUpdate((Element)xupdates.item(0));
            }
            if ((xquery = doc.getElementsByTagName("xquery")).getLength() > 0) {
                this.configureXQuery((Element)xquery.item(0));
            }
            if ((xacml = doc.getElementsByTagName("xacml")).getLength() > 0) {
                this.configureXACML((Element)xacml.item(0));
            }
            if ((clusters = doc.getElementsByTagName("cluster")).getLength() > 0) {
                this.configureCluster((Element)clusters.item(0));
            }
            if ((validations = doc.getElementsByTagName("validation")).getLength() > 0) {
                this.configureValidation(existHomeDirname, doc, (Element)validations.item(0));
            }
        }
        catch (SAXException e) {
            LOG.warn((Object)("error while reading config file: " + configFilename), (Throwable)e);
            throw new DatabaseConfigurationException(e.getMessage());
        }
        catch (ParserConfigurationException cfg) {
            LOG.warn((Object)("error while reading config file: " + configFilename), (Throwable)cfg);
            throw new DatabaseConfigurationException(cfg.getMessage());
        }
        catch (IOException io) {
            LOG.warn((Object)("error while reading config file: " + configFilename), (Throwable)io);
            throw new DatabaseConfigurationException(io.getMessage());
        }
    }

    private void configureCluster(Element cluster) {
        String dir;
        String pwd;
        String user;
        String protocol = cluster.getAttribute("protocol");
        if (protocol != null) {
            this.config.put("cluster.protocol", protocol);
            LOG.debug((Object)("cluster.protocol: " + this.config.get("cluster.protocol")));
        }
        if ((user = cluster.getAttribute("dbaUser")) != null) {
            this.config.put("cluster.user", user);
            LOG.debug((Object)("cluster.user: " + this.config.get("cluster.user")));
        }
        if ((pwd = cluster.getAttribute("dbaPassword")) != null) {
            this.config.put("cluster.pwd", pwd);
            LOG.debug((Object)("cluster.pwd: " + this.config.get("cluster.pwd")));
        }
        if ((dir = cluster.getAttribute("journalDir")) != null) {
            this.config.put("cluster.journalDir", dir);
            LOG.debug((Object)("cluster.journalDir: " + this.config.get("cluster.journalDir")));
        }
        String excludedColl = cluster.getAttribute("exclude");
        ArrayList<String> list = new ArrayList<String>();
        if (excludedColl != null) {
            String[] excl = excludedColl.split(",");
            for (int i = 0; i < excl.length; ++i) {
                list.add(excl[i]);
            }
        }
        if (!list.contains("/db/system/temp")) {
            list.add("/db/system/temp");
        }
        this.config.put("cluster.exclude", list);
        LOG.debug((Object)("cluster.exclude: " + this.config.get("cluster.exclude")));
        String maxStore = cluster.getAttribute("journalMaxItem");
        if (maxStore == null || maxStore.trim().length() == 0) {
            maxStore = "65000";
        }
        this.config.put("cluster.journal.maxStore", Integer.valueOf(maxStore));
        LOG.debug((Object)("cluster.journal.maxStore: " + this.config.get("cluster.journal.maxStore")));
        String shift = cluster.getAttribute("journalIndexShift");
        if (shift == null || shift.trim().length() == 0) {
            shift = "100";
        }
        this.config.put("cluster.journal.shift", Integer.valueOf(shift));
        LOG.debug((Object)("cluster.journal.shift: " + this.config.get("cluster.journal.shift")));
    }

    private void configureXQuery(Element xquery) throws DatabaseConfigurationException {
        String backwardCompatible;
        String optimize;
        String javabinding = xquery.getAttribute("enable-java-binding");
        if (javabinding != null) {
            this.config.put("xquery.enable-java-binding", javabinding);
            LOG.debug((Object)("xquery.enable-java-binding: " + this.config.get("xquery.enable-java-binding")));
        }
        if ((optimize = xquery.getAttribute("enable-query-rewriting")) != null && optimize.length() > 0) {
            this.config.put("xquery.enable-query-rewriting", optimize);
            LOG.debug((Object)("xquery.enable-query-rewriting: " + this.config.get("xquery.enable-query-rewriting")));
        }
        if ((backwardCompatible = xquery.getAttribute("backwardCompatible")) != null && backwardCompatible.length() > 0) {
            this.config.put("xquery.backwardCompatible", backwardCompatible);
            LOG.debug((Object)("xquery.backwardCompatible: " + this.config.get("xquery.backwardCompatible")));
        }
        Map moduleMap = XQueryContext.loadModuleClasses(xquery);
        this.config.put("xquery.modules", moduleMap);
    }

    private void configureXACML(Element xacml) {
        String enable = xacml.getAttribute("enable");
        this.config.put("xacml.enable", this.parseBoolean(enable, false));
        LOG.debug((Object)("xacml.enable: " + this.config.get("xacml.enable")));
        String loadDefaults = xacml.getAttribute("load-defaults");
        this.config.put("xacml.load.defaults", this.parseBoolean(loadDefaults, true));
        LOG.debug((Object)("xacml.load.defaults: " + this.config.get("xacml.load.defaults")));
    }

    private void configureXUpdate(Element xupdate) throws NumberFormatException {
        String consistencyCheck;
        String fragmentation = xupdate.getAttribute("allowed-fragmentation");
        if (fragmentation != null) {
            this.config.put("xupdate.fragmentation", new Integer(fragmentation));
            LOG.debug((Object)("xupdate.fragmentation: " + this.config.get("xupdate.fragmentation")));
        }
        if ((consistencyCheck = xupdate.getAttribute("enable-consistency-checks")) != null) {
            this.config.put("xupdate.consistency-checks", consistencyCheck.equals("yes"));
            LOG.debug((Object)("xupdate.consistency-checks: " + this.config.get("xupdate.consistency-checks")));
        }
    }

    private void configureTransformer(Element transformer) {
        String className = transformer.getAttribute("class");
        if (className != null) {
            this.config.put("transformer.class", className);
            LOG.debug((Object)("transformer.class: " + this.config.get("transformer.class")));
        }
    }

    private void configureSerializer(Element serializer) {
        String tagAttributeMatches;
        String tagElementMatches;
        String internalId;
        String compress;
        String indent;
        String xsl;
        String xinclude = serializer.getAttribute("enable-xinclude");
        if (xinclude != null) {
            this.config.put("serialization.enable-xinclude", xinclude);
            LOG.debug((Object)("serialization.enable-xinclude: " + this.config.get("serialization.enable-xinclude")));
        }
        if ((xsl = serializer.getAttribute("enable-xsl")) != null) {
            this.config.put("serialization.enable-xsl", xsl);
            LOG.debug((Object)("serialization.enable-xsl: " + this.config.get("serialization.enable-xsl")));
        }
        if ((indent = serializer.getAttribute("indent")) != null) {
            this.config.put("serialization.indent", indent);
            LOG.debug((Object)("serialization.indent: " + this.config.get("serialization.indent")));
        }
        if ((compress = serializer.getAttribute("compress-output")) != null) {
            this.config.put("serialization.compress-output", compress);
            LOG.debug((Object)("serialization.compress-output: " + this.config.get("serialization.compress-output")));
        }
        if ((internalId = serializer.getAttribute("add-exist-id")) != null) {
            this.config.put("serialization.add-exist-id", internalId);
            LOG.debug((Object)("serialization.add-exist-id: " + this.config.get("serialization.add-exist-id")));
        }
        if ((tagElementMatches = serializer.getAttribute("match-tagging-elements")) != null) {
            this.config.put("serialization.match-tagging-elements", tagElementMatches);
            LOG.debug((Object)("serialization.match-tagging-elements: " + this.config.get("serialization.match-tagging-elements")));
        }
        if ((tagAttributeMatches = serializer.getAttribute("match-tagging-attributes")) != null) {
            this.config.put("serialization.match-tagging-attributes", tagAttributeMatches);
            LOG.debug((Object)("serialization.match-tagging-attributes: " + this.config.get("serialization.match-tagging-attributes")));
        }
    }

    private void configureScheduler(Element scheduler) {
        NodeList nlJobs = scheduler.getElementsByTagName("job");
        if (nlJobs == null) {
            return;
        }
        ArrayList<JobConfig> jobList = new ArrayList<JobConfig>();
        String jobType = null;
        String jobName = null;
        String jobResource = null;
        String jobSchedule = null;
        String jobDelay = null;
        String jobRepeat = null;
        for (int i = 0; i < nlJobs.getLength(); ++i) {
            Element job = (Element)nlJobs.item(i);
            jobType = job.getAttribute("type");
            if (jobType == null) {
                jobType = "user";
            }
            jobName = job.getAttribute("name");
            jobResource = job.getAttribute("class");
            if (jobResource == null) {
                jobResource = job.getAttribute("xquery");
            }
            if ((jobSchedule = job.getAttribute("cron-trigger")) == null) {
                jobSchedule = job.getAttribute("period");
            }
            try {
                JobConfig jobConfig = new JobConfig(jobType, jobName, jobResource, jobSchedule);
                jobDelay = job.getAttribute("delay");
                if (jobDelay != null && jobDelay.length() > 0) {
                    jobConfig.setDelay(Long.parseLong(jobDelay));
                }
                if ((jobRepeat = job.getAttribute("repeat")) != null && jobRepeat.length() > 0) {
                    jobConfig.setRepeat(Integer.parseInt(jobRepeat));
                }
                NodeList params = job.getElementsByTagName("parameter");
                for (int p = 0; p < params.getLength(); ++p) {
                    Element param = (Element)params.item(p);
                    String name = param.getAttribute("name");
                    String value = param.getAttribute("value");
                    if (name == null || name.length() == 0) {
                        LOG.warn((Object)("Discarded invalid parameter for '" + jobType + "' job '" + jobResource + "'"));
                        continue;
                    }
                    jobConfig.addParameter(name, value);
                }
                jobList.add(jobConfig);
                LOG.debug((Object)("Configured scheduled '" + jobType + "' job '" + jobResource + (jobSchedule == null ? "" : "' with trigger '" + jobSchedule) + (jobDelay == null ? "" : "' with delay '" + jobDelay) + (jobRepeat == null ? "" : "' repetitions '" + jobRepeat) + "'"));
                continue;
            }
            catch (JobException je) {
                LOG.warn((Object)je);
            }
        }
        if (jobList.size() > 0) {
            JobConfig[] configs = new JobConfig[jobList.size()];
            for (int i = 0; i < jobList.size(); ++i) {
                configs[i] = (JobConfig)jobList.get(i);
            }
            this.config.put("scheduler.jobs", configs);
        }
    }

    private void configureBackend(String dbHome, Element con) throws DatabaseConfigurationException {
        NodeList defaultPermissions;
        NodeList recoveries;
        NodeList watchConf;
        NodeList queryPoolConf;
        String elementBuffers;
        String wordBuffers;
        String collBuffers;
        String buffers;
        String collCacheSize;
        String pageSize;
        String collectionCache;
        String cacheMem;
        String dataFiles;
        String mysql = con.getAttribute("database");
        if (mysql != null) {
            this.config.put("database", mysql);
            LOG.debug((Object)("database: " + this.config.get("database")));
        }
        if ((dataFiles = con.getAttribute("files")) != null) {
            File df = ConfigurationHelper.lookup(dataFiles, dbHome);
            if (!df.canRead()) {
                throw new DatabaseConfigurationException("cannot read data directory: " + df.getAbsolutePath());
            }
            this.config.put("db-connection.data-dir", df.getAbsolutePath());
            LOG.debug((Object)("db-connection.data-dir: " + this.config.get("db-connection.data-dir")));
        }
        if ((cacheMem = con.getAttribute("cacheSize")) != null) {
            if (cacheMem.endsWith("M") || cacheMem.endsWith("m")) {
                cacheMem = cacheMem.substring(0, cacheMem.length() - 1);
            }
            try {
                this.config.put("db-connection.cache-size", new Integer(cacheMem));
                LOG.debug((Object)("db-connection.cache-size: " + this.config.get("db-connection.cache-size") + "m"));
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)nfe);
            }
        }
        if ((collectionCache = con.getAttribute("collectionCache")) != null) {
            if (collectionCache.endsWith("M") || collectionCache.endsWith("m")) {
                collectionCache = collectionCache.substring(0, collectionCache.length() - 1);
            }
            try {
                this.config.put("db-connection.collection-cache-mem", new Integer(collectionCache));
                LOG.debug((Object)("db-connection.collection-cache-mem: " + this.config.get("db-connection.collection-cache-mem") + "m"));
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)nfe);
            }
        }
        if ((pageSize = con.getAttribute("pageSize")) != null) {
            try {
                this.config.put("db-connection.page-size", new Integer(pageSize));
                LOG.debug((Object)("db-connection.page-size: " + this.config.get("db-connection.page-size")));
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)nfe);
            }
        }
        if ((collCacheSize = con.getAttribute("collectionCacheSize")) != null) {
            try {
                this.config.put("db-connection.collection-cache-size", new Integer(collCacheSize));
                LOG.debug((Object)("db-connection.collection-cache-size: " + this.config.get("db-connection.collection-cache-size")));
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)nfe);
            }
        }
        if ((buffers = con.getAttribute("buffers")) != null) {
            try {
                this.config.put("db-connection.buffers", new Integer(buffers));
                LOG.debug((Object)("db-connection.buffers: " + this.config.get("db-connection.buffers")));
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)nfe);
            }
        }
        if ((collBuffers = con.getAttribute("collection_buffers")) != null) {
            try {
                this.config.put("db-connection.collections.buffers", new Integer(collBuffers));
                LOG.debug((Object)("db-connection.collections.buffers: " + this.config.get("db-connection.collections.buffers")));
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)nfe);
            }
        }
        if ((wordBuffers = con.getAttribute("words_buffers")) != null) {
            try {
                this.config.put("db-connection.words.buffers", new Integer(wordBuffers));
                LOG.debug((Object)("db-connection.words.buffers: " + this.config.get("db-connection.words.buffers")));
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)nfe);
            }
        }
        if ((elementBuffers = con.getAttribute("elements_buffers")) != null) {
            try {
                this.config.put("db-connection.elements.buffers", new Integer(elementBuffers));
                LOG.debug((Object)("db-connection.elements.buffers: " + this.config.get("db-connection.elements.buffers")));
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)nfe);
            }
        }
        NodeList securityConf = con.getElementsByTagName("security");
        String securityManagerClassName = "org.exist.security.XMLSecurityManager";
        if (securityConf.getLength() > 0) {
            Element security = (Element)securityConf.item(0);
            securityManagerClassName = security.getAttribute("class");
            String encoding = security.getAttribute("password-encoding");
            this.config.put("db-connection.security.password-encoding", encoding);
            if (encoding != null) {
                LOG.info((Object)("db-connection.security.password-encoding: " + this.config.get("db-connection.security.password-encoding")));
                User.setPasswordEncoding(encoding);
            } else {
                LOG.info((Object)"No password encoding set, defaulting.");
            }
            String realm = security.getAttribute("password-realm");
            this.config.put("db-connection.security.password-realm", realm);
            if (realm != null) {
                LOG.info((Object)("db-connection.security.password-realm: " + this.config.get("db-connection.security.password-realm")));
                User.setPasswordRealm(realm);
            } else {
                LOG.info((Object)"No password realm set, defaulting.");
            }
        }
        try {
            this.config.put("db-connection.security.class", Class.forName(securityManagerClassName));
            LOG.debug((Object)("db-connection.security.class: " + this.config.get("db-connection.security.class")));
        }
        catch (Throwable ex) {
            if (ex instanceof ClassNotFoundException) {
                throw new DatabaseConfigurationException("Cannot find security manager class " + securityManagerClassName, ex);
            }
            throw new DatabaseConfigurationException("Cannot load security manager class " + securityManagerClassName + " due to " + ex.getMessage(), ex);
        }
        NodeList poolConf = con.getElementsByTagName("pool");
        if (poolConf.getLength() > 0) {
            this.configurePool((Element)poolConf.item(0));
        }
        if ((queryPoolConf = con.getElementsByTagName("query-pool")).getLength() > 0) {
            this.configureXQueryPool((Element)queryPoolConf.item(0));
        }
        if ((watchConf = con.getElementsByTagName("watchdog")).getLength() > 0) {
            this.configureWatchdog((Element)watchConf.item(0));
        }
        if ((recoveries = con.getElementsByTagName("recovery")).getLength() > 0) {
            this.configureRecovery((Element)recoveries.item(0));
        }
        if ((defaultPermissions = con.getElementsByTagName("default-permissions")).getLength() > 0) {
            this.configurePermissions((Element)defaultPermissions.item(0));
        }
    }

    private void configureRecovery(Element recovery) throws DatabaseConfigurationException {
        String option = recovery.getAttribute("enabled");
        boolean value = true;
        if (option != null) {
            value = option.equals("yes");
        }
        this.setProperty("db-connection.recovery.enabled", new Boolean(value));
        LOG.debug((Object)("db-connection.recovery.enabled: " + this.config.get("db-connection.recovery.enabled")));
        option = recovery.getAttribute("sync-on-commit");
        value = true;
        if (option != null) {
            value = option.equals("yes");
        }
        this.setProperty("db-connection.recovery.sync-on-commit", new Boolean(value));
        LOG.debug((Object)("db-connection.recovery.sync-on-commit: " + this.config.get("db-connection.recovery.sync-on-commit")));
        option = recovery.getAttribute("group-commit");
        value = false;
        if (option != null) {
            value = option.equals("yes");
        }
        this.setProperty("db-connection.recovery.group-commit", new Boolean(value));
        LOG.debug((Object)("db-connection.recovery.group-commit: " + this.config.get("db-connection.recovery.group-commit")));
        option = recovery.getAttribute("journal-dir");
        if (option != null) {
            this.setProperty("db-connection.recovery.journal-dir", option);
            LOG.debug((Object)("db-connection.recovery.journal-dir: " + this.config.get("db-connection.recovery.journal-dir")));
        }
        if ((option = recovery.getAttribute("size")) != null) {
            if (option.endsWith("M") || option.endsWith("m")) {
                option = option.substring(0, option.length() - 1);
            }
            try {
                Integer size = new Integer(option);
                this.setProperty("db-connection.recovery.size-limit", size);
                LOG.debug((Object)("db-connection.recovery.size-limit: " + this.config.get("db-connection.recovery.size-limit") + "m"));
            }
            catch (NumberFormatException e) {
                throw new DatabaseConfigurationException("size attribute in recovery section needs to be a number");
            }
        }
        option = recovery.getAttribute("force-restart");
        value = false;
        if (option != null) {
            value = option.equals("yes");
        }
        this.setProperty("db-connection.recovery.force-restart", new Boolean(value));
        LOG.debug((Object)("db-connection.recovery.force-restart: " + this.config.get("db-connection.recovery.force-restart")));
        option = recovery.getAttribute("consistency-check");
        value = false;
        if (option != null) {
            value = option.equals("yes");
        }
        this.setProperty("db-connection.recovery.consistency-check", new Boolean(value));
        LOG.debug((Object)("db-connection.recovery.consistency-check: " + this.config.get("db-connection.recovery.consistency-check")));
    }

    private void configurePermissions(Element defaultPermission) throws DatabaseConfigurationException {
        Integer perms;
        String option = defaultPermission.getAttribute("collection");
        if (option != null && option.length() > 0) {
            try {
                perms = new Integer(Integer.parseInt(option, 8));
                this.setProperty("indexer.permissions.collection", perms);
                LOG.debug((Object)("indexer.permissions.collection: " + this.config.get("indexer.permissions.collection")));
            }
            catch (NumberFormatException e) {
                throw new DatabaseConfigurationException("collection attribute in default-permissions section needs to be an octal number");
            }
        }
        if ((option = defaultPermission.getAttribute("resource")) != null && option.length() > 0) {
            try {
                perms = new Integer(Integer.parseInt(option, 8));
                this.setProperty("indexer.permissions.resource", perms);
                LOG.debug((Object)("indexer.permissions.resource: " + this.config.get("indexer.permissions.resource")));
            }
            catch (NumberFormatException e) {
                throw new DatabaseConfigurationException("resource attribute in default-permissions section needs to be an octal number");
            }
        }
    }

    private void configureWatchdog(Element watchDog) {
        String maxOutput;
        String timeout = watchDog.getAttribute("query-timeout");
        if (timeout != null) {
            try {
                this.config.put("db-connection.watchdog.query-timeout", new Long(timeout));
                LOG.debug((Object)("db-connection.watchdog.query-timeout: " + this.config.get("db-connection.watchdog.query-timeout")));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)e);
            }
        }
        if ((maxOutput = watchDog.getAttribute("output-size-limit")) != null) {
            try {
                this.config.put("db-connection.watchdog.output-size-limit", new Integer(maxOutput));
                LOG.debug((Object)("db-connection.watchdog.output-size-limit: " + this.config.get("db-connection.watchdog.output-size-limit")));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)e);
            }
        }
    }

    private void configureXQueryPool(Element queryPool) {
        String timeoutCheckInterval;
        String timeout;
        String maxPoolSize;
        String maxStackSize = queryPool.getAttribute("max-stack-size");
        if (maxStackSize != null) {
            try {
                this.config.put("db-connection.query-pool.max-stack-size", new Integer(maxStackSize));
                LOG.debug((Object)("db-connection.query-pool.max-stack-size: " + this.config.get("db-connection.query-pool.max-stack-size")));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)e);
            }
        }
        if ((maxPoolSize = queryPool.getAttribute("size")) != null) {
            try {
                this.config.put("db-connection.query-pool.size", new Integer(maxPoolSize));
                LOG.debug((Object)("db-connection.query-pool.size: " + this.config.get("db-connection.query-pool.size")));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)e);
            }
        }
        if ((timeout = queryPool.getAttribute("timeout")) != null) {
            try {
                this.config.put("db-connection.query-pool.timeout", new Long(timeout));
                LOG.debug((Object)("db-connection.query-pool.timeout: " + this.config.get("db-connection.query-pool.timeout")));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)e);
            }
        }
        if ((timeoutCheckInterval = queryPool.getAttribute("timeout-check-interval")) != null) {
            try {
                this.config.put("db-connection.query-pool.timeout-check-interval", new Long(timeoutCheckInterval));
                LOG.debug((Object)("db-connection.query-pool.timeout-check-interval: " + this.config.get("db-connection.query-pool.timeout-check-interval")));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)e);
            }
        }
    }

    private void configurePool(Element pool) {
        String maxShutdownWait;
        String sync;
        String max;
        String min = pool.getAttribute("min");
        if (min != null) {
            try {
                this.config.put("db-connection.pool.min", new Integer(min));
                LOG.debug((Object)("db-connection.pool.min: " + this.config.get("db-connection.pool.min")));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)e);
            }
        }
        if ((max = pool.getAttribute("max")) != null) {
            try {
                this.config.put("db-connection.pool.max", new Integer(max));
                LOG.debug((Object)("db-connection.pool.max: " + this.config.get("db-connection.pool.max")));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)e);
            }
        }
        if ((sync = pool.getAttribute("sync-period")) != null) {
            try {
                this.config.put("db-connection.pool.sync-period", new Long(sync));
                LOG.debug((Object)("db-connection.pool.sync-period: " + this.config.get("db-connection.pool.sync-period")));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)e);
            }
        }
        if ((maxShutdownWait = pool.getAttribute("wait-before-shutdown")) != null) {
            try {
                this.config.put("wait-before-shutdown", new Long(maxShutdownWait));
                LOG.debug((Object)("wait-before-shutdown: " + this.config.get("wait-before-shutdown")));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)e);
            }
        }
    }

    private void configureIndexer(String dbHome, Document doc, Element indexer) throws DatabaseConfigurationException, MalformedURLException {
        NodeList modules;
        NodeList cl;
        String suppressWSmixed;
        String suppressWS;
        String stopwordFile;
        File sf;
        NodeList stopwords;
        String caseSensitive;
        String tokenizer;
        String termFreq;
        String stemming;
        String parseNum = indexer.getAttribute("parseNumbers");
        if (parseNum != null) {
            this.config.put("indexer.indexNumbers", parseNum.equals("yes"));
            LOG.debug((Object)("indexer.indexNumbers: " + this.config.get("indexer.indexNumbers")));
        }
        if ((stemming = indexer.getAttribute("stemming")) != null) {
            this.config.put("indexer.stem", stemming.equals("yes"));
            LOG.debug((Object)("indexer.stem: " + this.config.get("indexer.stem")));
        }
        if ((termFreq = indexer.getAttribute("track-term-freq")) != null) {
            this.config.put("indexer.store-term-freq", termFreq.equals("yes"));
            LOG.debug((Object)("indexer.store-term-freq: " + this.config.get("indexer.store-term-freq")));
        }
        if ((tokenizer = indexer.getAttribute("tokenizer")) != null) {
            this.config.put("indexer.tokenizer", tokenizer);
            LOG.debug((Object)("indexer.tokenizer: " + this.config.get("indexer.tokenizer")));
        }
        if ((caseSensitive = indexer.getAttribute("caseSensitive")) != null) {
            this.config.put("indexer.case-sensitive", caseSensitive.equals("yes"));
            LOG.debug((Object)("indexer.case-sensitive: " + this.config.get("indexer.case-sensitive")));
        }
        if ((stopwords = indexer.getElementsByTagName("stopwords")).getLength() > 0 && (sf = ConfigurationHelper.lookup(stopwordFile = ((Element)stopwords.item(0)).getAttribute("file"), dbHome)).canRead()) {
            this.config.put("stopwords", stopwordFile);
            LOG.debug((Object)("stopwords: " + this.config.get("stopwords")));
        }
        int depth = 3;
        String indexDepth = indexer.getAttribute("index-depth");
        if (indexDepth != null) {
            try {
                depth = Integer.parseInt(indexDepth);
                if (depth < 3) {
                    LOG.warn((Object)"parameter index-depth should be >= 3 or you will experience a severe performance loss for node updates (XUpdate or XQuery update extensions)");
                    depth = 3;
                }
                this.config.put("indexer.index-depth", new Integer(depth));
                LOG.debug((Object)("indexer.index-depth: " + this.config.get("indexer.index-depth")));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)e);
            }
        }
        if ((suppressWS = indexer.getAttribute("suppress-whitespace")) != null) {
            this.config.put("indexer.suppress-whitespace", suppressWS);
            LOG.debug((Object)("indexer.suppress-whitespace: " + this.config.get("indexer.suppress-whitespace")));
        }
        if ((suppressWSmixed = indexer.getAttribute("preserve-whitespace-mixed-content")) != null) {
            this.config.put("indexer.preserve-whitespace-mixed-content", suppressWSmixed.equals("yes"));
            LOG.debug((Object)("indexer.preserve-whitespace-mixed-content: " + this.config.get("indexer.preserve-whitespace-mixed-content")));
        }
        if ((cl = doc.getElementsByTagName("index")).getLength() > 0) {
            Element elem = (Element)cl.item(0);
            IndexSpec spec = new IndexSpec(null, elem);
            this.config.put("indexer.config", spec);
        }
        if ((modules = indexer.getElementsByTagName("modules")).getLength() > 0) {
            modules = ((Element)modules.item(0)).getElementsByTagName("module");
            IndexModuleConfig[] modConfig = new IndexModuleConfig[modules.getLength()];
            for (int i = 0; i < modules.getLength(); ++i) {
                Element elem = (Element)modules.item(i);
                String className = elem.getAttribute("class");
                String id = elem.getAttribute("id");
                if (className == null || className.length() == 0) {
                    throw new DatabaseConfigurationException("Required attribute class is missing for module");
                }
                if (id == null || id.length() == 0) {
                    throw new DatabaseConfigurationException("Required attribute id is missing for module");
                }
                modConfig[i] = new IndexModuleConfig(id, className, elem);
            }
            this.config.put("indexer.modules", modConfig);
        }
    }

    private void configureValidation(String dbHome, Document doc, Element validation) throws DatabaseConfigurationException {
        eXistURLStreamHandlerFactory.init();
        String mode = validation.getAttribute("mode");
        if (mode != null) {
            this.config.put("validation.mode", mode);
            LOG.debug((Object)("validation.mode: " + this.config.get("validation.mode")));
        }
        LOG.debug((Object)"Creating eXist catalog resolver");
        eXistXMLCatalogResolver resolver = new eXistXMLCatalogResolver();
        NodeList entityResolver = validation.getElementsByTagName("entity-resolver");
        if (entityResolver.getLength() > 0) {
            Element r = (Element)entityResolver.item(0);
            NodeList catalogs = r.getElementsByTagName("catalog");
            LOG.debug((Object)("Found " + catalogs.getLength() + " catalog uri entries."));
            LOG.debug((Object)("Using dbHome=" + dbHome));
            File webappHome = null;
            webappHome = dbHome == null ? new File("webapp").getAbsoluteFile() : (dbHome.endsWith("WEB-INF") ? new File(dbHome).getParentFile().getAbsoluteFile() : new File(dbHome, "webapp").getAbsoluteFile());
            LOG.debug((Object)("using webappHome=" + webappHome.toURI().toString()));
            ArrayList<String> allURIs = new ArrayList<String>();
            for (int i = 0; i < catalogs.getLength(); ++i) {
                String uri = ((Element)catalogs.item(i)).getAttribute("uri");
                if (uri == null) continue;
                if (uri.indexOf("${WEBAPP_HOME}") != -1) {
                    uri = uri.replaceAll("\\$\\{WEBAPP_HOME\\}", webappHome.toURI().toString());
                }
                LOG.info((Object)("Add catalog uri " + uri + ""));
                allURIs.add(uri);
            }
            resolver.setCatalogs(allURIs);
            this.config.put("validation.catalog_uris", allURIs);
        }
        this.config.put("validation.resolver", resolver);
        GrammarPool gp = new GrammarPool();
        this.config.put("validation.grammar_pool", gp);
    }

    public String getConfigFilePath() {
        return this.configFilePath;
    }

    public File getExistHome() {
        return this.existHome;
    }

    public Object getProperty(String name) {
        return this.config.get(name);
    }

    public boolean hasProperty(String name) {
        return this.config.containsKey(name);
    }

    public void setProperty(String name, Object obj) {
        this.config.put(name, obj);
    }

    private Boolean parseBoolean(String value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return (value = value.toLowerCase()).equals("yes") || value.equals("true");
    }

    public int getInteger(String name) {
        Object obj = this.getProperty(name);
        if (obj == null || !(obj instanceof Integer)) {
            return -1;
        }
        return (Integer)obj;
    }

    public void error(SAXParseException exception) throws SAXException {
        System.err.println("error occured while reading configuration file [line: " + exception.getLineNumber() + "]:" + exception.getMessage());
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        System.err.println("error occured while reading configuration file [line: " + exception.getLineNumber() + "]:" + exception.getMessage());
    }

    public void warning(SAXParseException exception) throws SAXException {
        System.err.println("error occured while reading configuration file [line: " + exception.getLineNumber() + "]:" + exception.getMessage());
    }

    public static final class IndexModuleConfig {
        protected String id;
        protected String className;
        protected Element config;

        public IndexModuleConfig(String id, String className, Element config) {
            this.id = id;
            this.className = className;
            this.config = config;
        }

        public String getClassName() {
            return this.className;
        }

        public Element getConfig() {
            return this.config;
        }

        public String getId() {
            return this.id;
        }
    }

    public static final class JobConfig {
        private String type = null;
        private String jobName = null;
        private String resourceName = null;
        private String schedule = null;
        private long delay = -1L;
        private int repeat = SimpleTrigger.REPEAT_INDEFINITELY;
        private Properties parameters = new Properties();

        public JobConfig(String type, String jobName, String resourceName, String schedule) throws JobException {
            this.type = type != null ? type : "user";
            this.jobName = jobName;
            if (resourceName == null) {
                throw new JobException(0, "Job must have a resource for execution");
            }
            this.resourceName = resourceName;
            if (schedule == null && !type.equals("startup")) {
                throw new JobException(0, "Job must have a schedule");
            }
            this.schedule = schedule;
        }

        public String getType() {
            return this.type;
        }

        public String getJobName() {
            return this.jobName;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public String getSchedule() {
            return this.schedule;
        }

        public void setDelay(long delay) {
            this.delay = delay;
        }

        public void setRepeat(int repeat) {
            this.repeat = repeat;
        }

        public long getDelay() {
            return this.delay;
        }

        public int getRepeat() {
            return this.repeat;
        }

        public void addParameter(String name, String value) {
            this.parameters.put(name, value);
        }

        public Properties getParameters() {
            return this.parameters;
        }
    }
}

