/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.txn;

import java.io.File;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.journal.Journal;
import org.exist.storage.recovery.RecoveryManager;
import org.exist.storage.txn.TransactionException;
import org.exist.storage.txn.Txn;
import org.exist.storage.txn.TxnAbort;
import org.exist.storage.txn.TxnCommit;
import org.exist.storage.txn.TxnStart;
import org.exist.util.ReadOnlyException;
import org.exist.xmldb.XmldbURI;

public class TransactionManager {
    public static final String RECOVERY_GROUP_COMMIT_ATTRIBUTE = "group-commit";
    public static final String PROPERTY_RECOVERY_GROUP_COMMIT = "db-connection.recovery.group-commit";
    public static final String RECOVERY_FORCE_RESTART_ATTRIBUTE = "force-restart";
    public static final String PROPERTY_RECOVERY_FORCE_RESTART = "db-connection.recovery.force-restart";
    private static final Logger LOG = Logger.getLogger((Class)TransactionManager.class);
    private long nextTxnId = 0L;
    private Journal journal;
    private boolean enabled;
    private boolean groupCommit = false;
    private boolean forceRestart = false;

    public TransactionManager(BrokerPool pool, File dataDir, boolean transactionsEnabled) throws EXistException {
        Boolean restartOpt;
        Boolean groupOpt;
        this.enabled = transactionsEnabled;
        if (this.enabled) {
            this.journal = new Journal(pool, dataDir);
        }
        if ((groupOpt = (Boolean)pool.getConfiguration().getProperty(PROPERTY_RECOVERY_GROUP_COMMIT)) != null) {
            this.groupCommit = groupOpt;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("GroupCommits = " + this.groupCommit));
            }
        }
        if ((restartOpt = (Boolean)pool.getConfiguration().getProperty(PROPERTY_RECOVERY_FORCE_RESTART)) != null) {
            this.forceRestart = restartOpt;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ForceRestart = " + this.forceRestart));
            }
        }
    }

    public void initialize() throws EXistException, ReadOnlyException {
        if (this.enabled) {
            this.journal.initialize();
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean runRecovery(DBBroker broker) throws EXistException {
        RecoveryManager recovery = new RecoveryManager(broker, this.journal, this.forceRestart);
        return recovery.recover();
    }

    public Txn beginTransaction() {
        if (!this.enabled) {
            return null;
        }
        long txnId = this.nextTxnId++;
        try {
            this.journal.writeToLog(new TxnStart(txnId));
        }
        catch (TransactionException e) {
            LOG.warn((Object)"Failed to create transaction. Error writing to log file.", (Throwable)e);
        }
        return new Txn(txnId);
    }

    public void commit(Txn txn) throws TransactionException {
        if (!this.enabled) {
            return;
        }
        if (this.enabled) {
            this.journal.writeToLog(new TxnCommit(txn.getId()));
            if (!this.groupCommit) {
                this.journal.flushToLog(true);
            }
        }
        txn.releaseAll();
    }

    public void abort(Txn txn) {
        if (!this.enabled || txn == null) {
            return;
        }
        try {
            this.journal.writeToLog(new TxnAbort(txn.getId()));
        }
        catch (TransactionException e) {
            LOG.warn((Object)("Failed to write abort record to journal: " + e.getMessage()));
        }
        if (!this.groupCommit) {
            this.journal.flushToLog(true);
        }
        txn.releaseAll();
    }

    public void checkpoint(boolean switchFiles) throws TransactionException {
        if (!this.enabled) {
            return;
        }
        long txnId = this.nextTxnId++;
        this.journal.checkpoint(txnId, switchFiles);
    }

    public Journal getJournal() {
        return this.journal;
    }

    public void reindex(DBBroker broker) {
        broker.setUser(SecurityManager.SYSTEM_USER);
        try {
            broker.reindexCollection(XmldbURI.ROOT_COLLECTION_URI);
        }
        catch (PermissionDeniedException e) {
            LOG.warn((Object)("Exception during reindex: " + e.getMessage()), (Throwable)e);
        }
    }

    public void shutdown(boolean checkpoint) {
        if (this.enabled) {
            long txnId = this.nextTxnId++;
            this.journal.shutdown(txnId, checkpoint);
        }
    }
}

