/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.lock;

import java.util.Stack;
import org.apache.log4j.Logger;
import org.exist.storage.lock.DeadlockDetection;
import org.exist.storage.lock.Lock;
import org.exist.storage.lock.LockInfo;
import org.exist.storage.lock.LockListener;
import org.exist.storage.lock.WaitingThread;
import org.exist.util.LockException;

public class ReentrantReadWriteLock
implements Lock {
    private static final int WAIT_CHECK_PERIOD = 200;
    private static final Logger LOG = Logger.getLogger((Class)ReentrantReadWriteLock.class);
    protected Object id_ = null;
    protected Thread owner_ = null;
    protected Stack suspendedThreads = new Stack();
    protected int holds_ = 0;
    public int mode_ = -1;
    private Stack modeStack = new Stack();
    private int writeLocks = 0;
    private boolean DEBUG = false;
    private Stack seStack;
    private LockListener listener = null;

    public ReentrantReadWriteLock(Object id) {
        this.id_ = id;
        if (this.DEBUG) {
            this.seStack = new Stack();
        }
    }

    public String getId() {
        return this.id_.toString();
    }

    public boolean acquire() throws LockException {
        return this.acquire(0);
    }

    public boolean acquire(int mode) throws LockException {
        if (mode == -1) {
            LOG.warn((Object)"acquired with no lock !");
            return true;
        }
        if (Thread.interrupted()) {
            throw new LockException();
        }
        Thread caller = Thread.currentThread();
        ReentrantReadWriteLock reentrantReadWriteLock = this;
        synchronized (reentrantReadWriteLock) {
            if (caller == this.owner_) {
                ++this.holds_;
                this.modeStack.push(new Integer(mode));
                if (mode == 1) {
                    ++this.writeLocks;
                }
                if (this.DEBUG) {
                    Throwable t = new Throwable();
                    this.seStack.push(t.getStackTrace());
                }
                this.mode_ = mode;
                return true;
            }
            if (this.owner_ == null) {
                this.owner_ = caller;
                this.holds_ = 1;
                this.modeStack.push(new Integer(mode));
                if (mode == 1) {
                    ++this.writeLocks;
                }
                if (this.DEBUG) {
                    Throwable t = new Throwable();
                    this.seStack.push(t.getStackTrace());
                }
                this.mode_ = mode;
                return true;
            }
            WaitingThread waitingOnResource = DeadlockDetection.deadlockCheckResource(caller, this.owner_);
            if (waitingOnResource != null) {
                waitingOnResource.suspendWaiting();
                SuspendedWaiter suspended = new SuspendedWaiter(this.owner_, this.mode_, this.holds_);
                this.suspendedThreads.push(suspended);
                this.owner_ = caller;
                this.holds_ = 1;
                this.modeStack.push(new Integer(mode));
                if (mode == 1) {
                    ++this.writeLocks;
                }
                this.mode_ = mode;
                this.listener = waitingOnResource;
                return true;
            }
            long start = System.currentTimeMillis();
            DeadlockDetection.addCollectionWaiter(caller, this);
            try {
                do {
                    this.wait(200L);
                    waitingOnResource = DeadlockDetection.deadlockCheckResource(caller, this.owner_);
                    if (waitingOnResource != null) {
                        waitingOnResource.suspendWaiting();
                        SuspendedWaiter suspended = new SuspendedWaiter(this.owner_, this.mode_, this.holds_);
                        this.suspendedThreads.push(suspended);
                        this.owner_ = caller;
                        this.holds_ = 1;
                        this.modeStack.push(new Integer(mode));
                        if (mode == 1) {
                            ++this.writeLocks;
                        }
                        this.mode_ = mode;
                        this.listener = waitingOnResource;
                        DeadlockDetection.clearCollectionWaiter(this.owner_);
                        return true;
                    }
                    if (caller != this.owner_) continue;
                    ++this.holds_;
                    this.modeStack.push(new Integer(mode));
                    if (mode == 1) {
                        ++this.writeLocks;
                    }
                    if (this.DEBUG) {
                        Throwable t = new Throwable();
                        this.seStack.push(t.getStackTrace());
                    }
                    this.mode_ = mode;
                    DeadlockDetection.clearCollectionWaiter(this.owner_);
                    return true;
                } while (this.owner_ != null);
                this.owner_ = caller;
                this.holds_ = 1;
                this.modeStack.push(new Integer(mode));
                if (mode == 1) {
                    ++this.writeLocks;
                }
                if (this.DEBUG) {
                    Throwable t = new Throwable();
                    this.seStack.push(t.getStackTrace());
                }
                this.mode_ = mode;
                DeadlockDetection.clearCollectionWaiter(this.owner_);
                return true;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw new LockException("interrupted while waiting for lock");
            }
        }
    }

    public synchronized void wakeUp() {
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean attempt(int mode) {
        Thread caller = Thread.currentThread();
        ReentrantReadWriteLock reentrantReadWriteLock = this;
        synchronized (reentrantReadWriteLock) {
            if (caller == this.owner_) {
                ++this.holds_;
                this.modeStack.push(new Integer(mode));
                if (mode == 1) {
                    ++this.writeLocks;
                }
                if (this.DEBUG) {
                    Throwable t = new Throwable();
                    this.seStack.push(t.getStackTrace());
                }
                this.mode_ = mode;
                return true;
            }
            if (this.owner_ == null) {
                this.owner_ = caller;
                this.holds_ = 1;
                this.modeStack.push(new Integer(mode));
                if (mode == 1) {
                    ++this.writeLocks;
                }
                if (this.DEBUG) {
                    Throwable t = new Throwable();
                    this.seStack.push(t.getStackTrace());
                }
                this.mode_ = mode;
                return true;
            }
            return false;
        }
    }

    public synchronized boolean isLockedForWrite() {
        return this.writeLocks > 0;
    }

    public boolean isLockedForRead(Thread owner) {
        return false;
    }

    public synchronized boolean hasLock() {
        return this.holds_ > 0;
    }

    public boolean hasLock(Thread owner) {
        return this.owner_ == owner;
    }

    public Thread getOwner() {
        return this.owner_;
    }

    public synchronized void release(int mode) {
        if (Thread.currentThread() != this.owner_) {
            LOG.warn((Object)("Possible lock problem: thread " + Thread.currentThread() + " released a lock on " + this.getId() + " it didn't hold. Either the " + "thread was interrupted or it never acquired the lock. The lock was owned by: " + this.owner_));
            if (this.DEBUG) {
                LOG.debug((Object)"Lock was acquired by :");
                while (!this.seStack.isEmpty()) {
                    StackTraceElement[] se = (StackTraceElement[])this.seStack.pop();
                    LOG.debug((Object)se);
                    se = null;
                }
            }
            return;
        }
        Integer top = (Integer)this.modeStack.pop();
        this.mode_ = top;
        top = null;
        if (this.mode_ != mode) {
            LOG.warn((Object)("Released lock of different type. Expected " + this.mode_ + " got " + mode), new Throwable());
        }
        if (this.mode_ == 1) {
            --this.writeLocks;
        }
        if (this.DEBUG) {
            StackTraceElement[] se = (StackTraceElement[])this.seStack.pop();
            se = null;
        }
        if (--this.holds_ == 0) {
            if (!this.suspendedThreads.isEmpty()) {
                SuspendedWaiter suspended = (SuspendedWaiter)this.suspendedThreads.pop();
                this.owner_ = suspended.thread;
                this.mode_ = suspended.lockMode;
                this.holds_ = suspended.lockCount;
            } else {
                this.owner_ = null;
                this.mode_ = -1;
                this.notify();
            }
        }
        if (this.listener != null) {
            this.listener.lockReleased();
            this.listener = null;
        }
    }

    public void release(int mode, int count) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support releasing multiple locks");
    }

    public synchronized long holds() {
        if (Thread.currentThread() != this.owner_) {
            return 0L;
        }
        return this.holds_;
    }

    public synchronized LockInfo getLockInfo() {
        String lockType = this.mode_ == 1 ? "WRITE" : "READ";
        return new LockInfo("COLLECTION", lockType, this.getId(), new String[]{this.owner_.getName()});
    }

    private class SuspendedWaiter {
        Thread thread;
        int lockMode;
        int lockCount;

        public SuspendedWaiter(Thread thread, int lockMode, int lockCount) {
            this.thread = thread;
            this.lockMode = lockMode;
            this.lockCount = lockCount;
        }
    }
}

