/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.dom;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.exist.dom.NodeProxy;
import org.exist.dom.StoredNode;
import org.exist.storage.DBBroker;
import org.exist.storage.StorageAddress;
import org.exist.storage.btree.BTreeException;
import org.exist.storage.btree.Value;
import org.exist.storage.dom.DOMFile;
import org.exist.storage.dom.ItemId;
import org.exist.storage.dom.RecordPos;
import org.exist.storage.lock.Lock;
import org.exist.util.ByteConversion;
import org.exist.util.LockException;
import org.exist.util.sanity.SanityCheck;

public class RawNodeIterator {
    private static final Logger LOG = Logger.getLogger((Class)RawNodeIterator.class);
    private DOMFile db = null;
    private int offset;
    private short lastTID = (short)-1;
    private DOMFile.DOMPage p = null;
    private long page;
    private DBBroker broker;

    public RawNodeIterator(DBBroker broker, DOMFile db, StoredNode node) throws IOException {
        this.db = db;
        this.broker = broker;
        this.seek(node);
    }

    public RawNodeIterator(DBBroker broker, DOMFile db, NodeProxy proxy) throws IOException {
        this.db = db;
        this.broker = broker;
        this.seek(proxy);
    }

    public void seek(StoredNode node) throws IOException {
        Lock lock = this.db.getLock();
        try {
            lock.acquire(0);
            RecordPos rec = null;
            if (node.getInternalAddress() != -1L) {
                rec = this.db.findRecord(node.getInternalAddress());
            }
            if (rec == null) {
                try {
                    long addr = this.db.findValue(this.broker, new NodeProxy(node));
                    if (addr == -1L) {
                        throw new IOException("Node not found.");
                    }
                    rec = this.db.findRecord(addr);
                }
                catch (BTreeException e) {
                    throw new IOException("Node not found: " + e.getMessage());
                }
            }
            this.page = rec.getPage().getPageNum();
            this.offset = rec.offset - 2;
            this.p = rec.getPage();
        }
        catch (LockException e) {
            throw new IOException("Exception while scanning document: " + e.getMessage());
        }
        finally {
            lock.release(0);
        }
    }

    public void seek(NodeProxy proxy) throws IOException {
        Lock lock = this.db.getLock();
        try {
            lock.acquire(0);
            RecordPos rec = null;
            if (proxy.getInternalAddress() != -1L) {
                rec = this.db.findRecord(proxy.getInternalAddress());
            }
            if (rec == null) {
                try {
                    long addr = this.db.findValue(this.broker, proxy);
                    if (addr == -1L) {
                        throw new IOException("Node not found.");
                    }
                    rec = this.db.findRecord(addr);
                }
                catch (BTreeException e) {
                    throw new IOException("Node not found: " + e.getMessage());
                }
            }
            this.page = rec.getPage().getPageNum();
            this.offset = rec.offset - 2;
            this.p = rec.getPage();
        }
        catch (LockException e) {
            throw new IOException("Exception while scanning document: " + e.getMessage());
        }
        finally {
            lock.release(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value next() {
        Value nextValue = null;
        Lock lock = this.db.getLock();
        try {
            try {
                lock.acquire(0);
            }
            catch (LockException e) {
                LOG.warn((Object)("Failed to acquire read lock on " + this.db.getFile().getName()));
                Value value = null;
                lock.release(0);
                return value;
            }
            this.db.setOwnerObject(this.broker);
            long backLink = 0L;
            do {
                DOMFile.DOMFilePageHeader ph;
                if (this.offset >= (ph = this.p.getPageHeader()).getDataLength()) {
                    long nextPage = ph.getNextDataPage();
                    if (nextPage == -1L) {
                        SanityCheck.TRACE("bad link to next " + this.p.page.getPageInfo() + "; previous: " + ph.getPrevDataPage() + "; offset = " + this.offset + "; lastTID = " + this.lastTID);
                        Value value = null;
                        return value;
                    }
                    this.page = nextPage;
                    this.p = this.db.getCurrentPage(nextPage);
                    this.db.addToBuffer(this.p);
                    this.offset = 0;
                }
                this.lastTID = ByteConversion.byteToShort(this.p.data, this.offset);
                this.offset += 2;
                if (ItemId.isLink(this.lastTID)) {
                    this.offset += 8;
                    continue;
                }
                int vlen = ByteConversion.byteToShort(this.p.data, this.offset);
                this.offset += 2;
                if (vlen < 0) {
                    LOG.warn((Object)("Got negative length" + vlen + " at offset " + this.offset + "!!!"));
                    LOG.debug((Object)this.db.debugPageContents(this.p));
                }
                if (ItemId.isRelocated(this.lastTID)) {
                    backLink = ByteConversion.byteToLong(this.p.data, this.offset);
                    this.offset += 8;
                }
                if (vlen == 0) {
                    vlen = 8;
                    long overflow = ByteConversion.byteToLong(this.p.data, this.offset);
                    this.offset += 8;
                    try {
                        byte[] odata = this.db.getOverflowValue(overflow);
                        nextValue = new Value(odata);
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Exception while loading overflow value: " + e.getMessage() + "; originating page: " + this.p.page.getPageInfo()));
                    }
                } else {
                    try {
                        nextValue = new Value(this.p.data, this.offset, vlen);
                        this.offset += vlen;
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Error while deserializing node: " + e.getMessage()), (Throwable)e);
                        LOG.warn((Object)("Reading from offset: " + this.offset + "; len = " + vlen));
                        LOG.debug((Object)this.db.debugPageContents(this.p));
                        throw new RuntimeException(e);
                    }
                }
                if (nextValue == null) {
                    LOG.warn((Object)("illegal node on page " + this.p.getPageNum() + "; tid = " + ItemId.getId(this.lastTID) + "; next = " + this.p.getPageHeader().getNextDataPage() + "; prev = " + this.p.getPageHeader().getPrevDataPage() + "; offset = " + (this.offset - vlen) + "; len = " + this.p.getPageHeader().getDataLength()));
                    Value value = null;
                    return value;
                }
                if (ItemId.isRelocated(this.lastTID)) {
                    nextValue.setAddress(backLink);
                    continue;
                }
                nextValue.setAddress(StorageAddress.createPointer((int)this.page, ItemId.getId(this.lastTID)));
            } while (nextValue == null);
            Value value = nextValue;
            return value;
        }
        finally {
            lock.release(0);
        }
    }

    public void closeDocument() {
        this.db.closeDocument();
    }

    public long currentAddress() {
        return StorageAddress.createPointer((int)this.page, ItemId.getId(this.lastTID));
    }
}

