/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.exist.xquery.XQueryWatchDog;
import org.exist.xquery.util.ExpressionDumper;

public class ProcessMonitor {
    public static final String ACTION_UNSPECIFIED = "unspecified";
    public static final String ACTION_VALIDATE_DOC = "validating document";
    public static final String ACTION_STORE_DOC = "storing document";
    public static final String ACTION_STORE_BINARY = "storing binary resource";
    public static final String ACTION_REMOVE_XML = "remove XML resource";
    public static final String ACTION_REMOVE_BINARY = "remove binary resource";
    public static final String ACTION_REMOVE_COLLECTION = "remove collection";
    public static final String ACTION_REINDEX_COLLECTION = "reindex collection";
    public static final String ACTION_COPY_COLLECTION = "copy collection";
    public static final String ACTION_MOVE_COLLECTION = "move collection";
    public static final String ACTION_COPY_XML_RESOURCE = "copy xml resource";
    public static final String ACTION_MOVE_XML_RESOURCE = "move xml resource";
    private static final Logger LOG = Logger.getLogger((Class)ProcessMonitor.class);
    private Set runningQueries = new HashSet();
    private Map processes = new HashMap();

    public void startJob(String action) {
        this.startJob(action, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startJob(String action, Object addInfo) {
        JobInfo info = new JobInfo(action);
        info.setAddInfo(addInfo);
        Map map = this.processes;
        synchronized (map) {
            this.processes.put(info.getThread(), info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endJob() {
        Map map = this.processes;
        synchronized (map) {
            this.processes.remove(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInfo[] runningJobs() {
        Map map = this.processes;
        synchronized (map) {
            JobInfo[] jobs = new JobInfo[this.processes.size()];
            int j = 0;
            Iterator i = this.processes.values().iterator();
            while (i.hasNext()) {
                jobs[j] = (JobInfo)i.next();
                ++j;
            }
            return jobs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryStarted(XQueryWatchDog watchdog) {
        Set set = this.runningQueries;
        synchronized (set) {
            this.runningQueries.add(watchdog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryCompleted(XQueryWatchDog watchdog) {
        Set set = this.runningQueries;
        synchronized (set) {
            this.runningQueries.remove(watchdog);
        }
    }

    public void killAll(long waitTime) {
        Iterator i = this.runningQueries.iterator();
        while (i.hasNext()) {
            XQueryWatchDog watchdog = (XQueryWatchDog)i.next();
            LOG.debug((Object)("Killing query: " + ExpressionDumper.dump(watchdog.getContext().getRootExpression())));
            watchdog.kill(waitTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XQueryWatchDog[] getRunningXQueries() {
        Set set = this.runningQueries;
        synchronized (set) {
            XQueryWatchDog[] watchdogs = new XQueryWatchDog[this.runningQueries.size()];
            int j = 0;
            Iterator i = this.runningQueries.iterator();
            while (i.hasNext()) {
                watchdogs[j] = (XQueryWatchDog)i.next();
                ++j;
            }
            return watchdogs;
        }
    }

    public static final class JobInfo {
        private Thread thread = Thread.currentThread();
        private String action;
        private long startTime;
        private Object addInfo = null;

        public JobInfo(String action) {
            this.action = action;
            this.startTime = System.currentTimeMillis();
        }

        public String getAction() {
            return this.action;
        }

        public Thread getThread() {
            return this.thread;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setAddInfo(Object info) {
            this.addInfo = info;
        }

        public Object getAddInfo() {
            return this.addInfo;
        }
    }
}

