/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.util.IdentityHashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.exist.dom.DocumentImpl;
import org.exist.dom.StoredNode;
import org.exist.numbering.NodeId;
import org.exist.storage.UpdateListener;

public class NotificationService
extends IdentityHashMap {
    private static final Logger LOG = Logger.getLogger((Class)NotificationService.class);

    public synchronized void subscribe(UpdateListener listener) {
        this.put(listener, new Object());
    }

    public synchronized void unsubscribe(UpdateListener listener) {
        Object i = this.remove(listener);
        if (i == null) {
            throw new RuntimeException(this.hashCode() + " listener not found: " + listener.hashCode());
        }
        listener.unsubscribe();
    }

    public synchronized void notifyUpdate(DocumentImpl document, int event) {
        Iterator i = this.keySet().iterator();
        while (i.hasNext()) {
            UpdateListener listener = (UpdateListener)i.next();
            listener.documentUpdated(document, event);
        }
    }

    public synchronized void notifyMove(NodeId oldNodeId, StoredNode newNode) {
        Iterator i = this.keySet().iterator();
        while (i.hasNext()) {
            UpdateListener listener = (UpdateListener)i.next();
            listener.nodeMoved(oldNodeId, newNode);
        }
    }

    public void debug() {
        LOG.debug((Object)"Registered UpdateListeners:");
        Iterator i = this.keySet().iterator();
        while (i.hasNext()) {
            UpdateListener listener = (UpdateListener)i.next();
            listener.debug();
        }
    }
}

