/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import org.exist.collections.Collection;
import org.exist.dom.SymbolTable;
import org.exist.storage.btree.Value;
import org.exist.util.ByteConversion;
import org.exist.util.UTF8;

public class ElementValue
extends Value {
    public static final byte UNKNOWN = -1;
    public static final byte ELEMENT = 0;
    public static final byte ATTRIBUTE = 1;
    public static final byte ATTRIBUTE_ID = 2;
    public static final byte ATTRIBUTE_IDREF = 3;
    public static final byte ATTRIBUTE_IDREFS = 4;
    public static int LENGTH_TYPE = 1;
    public static int OFFSET_COLLECTION_ID = 0;
    public static int OFFSET_TYPE = OFFSET_COLLECTION_ID + Collection.LENGTH_COLLECTION_ID;
    public static int OFFSET_SYMBOL = OFFSET_TYPE + LENGTH_TYPE;
    public static int OFFSET_NSSYMBOL = OFFSET_SYMBOL + SymbolTable.LENGTH_LOCAL_NAME;
    public static int OFFSET_ID_STRING_VALUE = OFFSET_TYPE + LENGTH_TYPE;
    public static final String[] type = new String[]{"element", "attribute", "id"};

    ElementValue(int collectionId) {
        this.len = Collection.LENGTH_COLLECTION_ID;
        this.data = new byte[this.len];
        ByteConversion.intToByte(collectionId, this.data, OFFSET_COLLECTION_ID);
        this.pos = OFFSET_COLLECTION_ID;
    }

    ElementValue(byte type, int collectionId) {
        this.len = Collection.LENGTH_COLLECTION_ID + LENGTH_TYPE;
        this.data = new byte[this.len];
        ByteConversion.intToByte(collectionId, this.data, OFFSET_COLLECTION_ID);
        this.data[ElementValue.OFFSET_TYPE] = type;
        this.pos = OFFSET_COLLECTION_ID;
    }

    ElementValue(byte type, int collectionId, short symbol) {
        this.len = Collection.LENGTH_COLLECTION_ID + LENGTH_TYPE + SymbolTable.LENGTH_LOCAL_NAME;
        this.data = new byte[this.len];
        ByteConversion.intToByte(collectionId, this.data, OFFSET_COLLECTION_ID);
        this.data[ElementValue.OFFSET_TYPE] = type;
        ByteConversion.shortToByte(symbol, this.data, OFFSET_SYMBOL);
        this.pos = OFFSET_COLLECTION_ID;
    }

    ElementValue(byte type, int collectionId, short symbol, short nsSymbol) {
        this.len = Collection.LENGTH_COLLECTION_ID + LENGTH_TYPE + SymbolTable.LENGTH_LOCAL_NAME + OFFSET_NSSYMBOL;
        this.data = new byte[this.len];
        ByteConversion.intToByte(collectionId, this.data, OFFSET_COLLECTION_ID);
        this.data[ElementValue.OFFSET_TYPE] = type;
        ByteConversion.shortToByte(symbol, this.data, OFFSET_SYMBOL);
        ByteConversion.shortToByte(nsSymbol, this.data, OFFSET_NSSYMBOL);
        this.pos = OFFSET_COLLECTION_ID;
    }

    ElementValue(byte type, int collectionId, String idStringValue) {
        this.len = Collection.LENGTH_COLLECTION_ID + LENGTH_TYPE + UTF8.encoded(idStringValue);
        this.data = new byte[this.len];
        ByteConversion.intToByte(collectionId, this.data, OFFSET_COLLECTION_ID);
        this.data[ElementValue.OFFSET_TYPE] = type;
        UTF8.encode(idStringValue, this.data, OFFSET_ID_STRING_VALUE);
    }

    int getCollectionId() {
        return ByteConversion.byteToInt(this.data, OFFSET_COLLECTION_ID);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Collection id : " + ByteConversion.byteToInt(this.data, OFFSET_COLLECTION_ID));
        if (this.len > OFFSET_COLLECTION_ID) {
            buf.append(" Type : " + type[this.data[OFFSET_TYPE]]);
            if (this.data[OFFSET_TYPE] == 2) {
                buf.append(" id : " + UTF8.decode(this.data, 4, this.data.length - (Collection.LENGTH_COLLECTION_ID + LENGTH_TYPE)));
            } else if (this.data[OFFSET_TYPE] == 3) {
                buf.append(" idref : " + UTF8.decode(this.data, 4, this.data.length - (Collection.LENGTH_COLLECTION_ID + LENGTH_TYPE)));
            }
            if (this.data[OFFSET_TYPE] == 4) {
                buf.append(" idrefs : " + UTF8.decode(this.data, 4, this.data.length - (Collection.LENGTH_COLLECTION_ID + LENGTH_TYPE)));
            } else if (this.len == Collection.LENGTH_COLLECTION_ID + LENGTH_TYPE + SymbolTable.LENGTH_LOCAL_NAME) {
                buf.append(" Symbol id : " + ByteConversion.byteToShort(this.data, OFFSET_SYMBOL));
            } else if (this.len == Collection.LENGTH_COLLECTION_ID + LENGTH_TYPE + SymbolTable.LENGTH_LOCAL_NAME + SymbolTable.LENGTH_NS_URI) {
                buf.append(" Symbol id : " + ByteConversion.byteToShort(this.data, OFFSET_SYMBOL));
                buf.append(" NSSymbol id : " + ByteConversion.byteToShort(this.data, OFFSET_NSSYMBOL));
            } else {
                buf.append("Invalid data length !!!");
            }
        }
        return buf.toString();
    }
}

