/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.CollectionCache;
import org.exist.collections.CollectionConfigurationManager;
import org.exist.dom.SymbolTable;
import org.exist.indexing.IndexManager;
import org.exist.management.AgentFactory;
import org.exist.numbering.DLNFactory;
import org.exist.numbering.NodeIdFactory;
import org.exist.scheduler.Scheduler;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.security.User;
import org.exist.storage.BrokerFactory;
import org.exist.storage.CollectionCacheManager;
import org.exist.storage.ConsistencyCheckTask;
import org.exist.storage.DBBroker;
import org.exist.storage.DefaultCacheManager;
import org.exist.storage.NotificationService;
import org.exist.storage.ProcessMonitor;
import org.exist.storage.SystemTask;
import org.exist.storage.XQueryPool;
import org.exist.storage.btree.DBException;
import org.exist.storage.lock.FileLock;
import org.exist.storage.lock.Lock;
import org.exist.storage.lock.ReentrantReadWriteLock;
import org.exist.storage.sync.Sync;
import org.exist.storage.txn.TransactionException;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.Configuration;
import org.exist.util.DatabaseConfigurationException;
import org.exist.util.ReadOnlyException;
import org.exist.util.XMLReaderObjectFactory;
import org.exist.util.XMLReaderPool;
import org.exist.xmldb.ShutdownListener;
import org.exist.xmldb.XmldbURI;

public class BrokerPool
extends Observable {
    private static final Logger LOG = Logger.getLogger((Class)BrokerPool.class);
    private static final TreeMap instances = new TreeMap();
    public static final String SIGNAL_STARTUP = "startup";
    public static final String SIGNAL_SHUTDOWN = "shutdown";
    public static final String DEFAULT_INSTANCE_NAME = "exist";
    public static final String CONFIGURATION_CONNECTION_ELEMENT_NAME = "db-connection";
    public static final String CONFIGURATION_POOL_ELEMENT_NAME = "pool";
    public static final String CONFIGURATION_SECURITY_ELEMENT_NAME = "security";
    public static final String CONFIGURATION_RECOVERY_ELEMENT_NAME = "recovery";
    public static final String DATA_DIR_ATTRIBUTE = "files";
    public static final String RECOVERY_ENABLED_ATTRIBUTE = "enabled";
    public static final String RECOVERY_POST_RECOVERY_CHECK = "consistency-check";
    public static final String COLLECTION_CACHE_SIZE_ATTRIBUTE = "collectionCacheSize";
    public static final String MIN_CONNECTIONS_ATTRIBUTE = "min";
    public static final String MAX_CONNECTIONS_ATTRIBUTE = "max";
    public static final String SYNC_PERIOD_ATTRIBUTE = "sync-period";
    public static final String SHUTDOWN_DELAY_ATTRIBUTE = "wait-before-shutdown";
    public static final String PROPERTY_DATA_DIR = "db-connection.data-dir";
    public static final String PROPERTY_MIN_CONNECTIONS = "db-connection.pool.min";
    public static final String PROPERTY_MAX_CONNECTIONS = "db-connection.pool.max";
    public static final String PROPERTY_SYNC_PERIOD = "db-connection.pool.sync-period";
    public static final String PROPERTY_SHUTDOWN_DELAY = "wait-before-shutdown";
    public static final String PROPERTY_COLLECTION_CACHE_SIZE = "db-connection.collection-cache-size";
    public static final String DEFAULT_SECURITY_CLASS = "org.exist.security.XMLSecurityManager";
    public static final String PROPERTY_SECURITY_CLASS = "db-connection.security.class";
    public static final String PROPERTY_RECOVERY_ENABLED = "db-connection.recovery.enabled";
    public static final String PROPERTY_RECOVERY_CHECK = "db-connection.recovery.consistency-check";
    public static final String PROPERTY_SYSTEM_TASK_CONFIG = "db-connection.system-task-config";
    private static final Thread shutdownHook = new Thread(){

        public void run() {
            LOG.info((Object)"Executing shutdown thread");
            BrokerPool.stopAll(true);
        }
    };
    private static boolean registerShutdownHook = true;
    private static Observer statusObserver = null;
    public static boolean FORCE_CORRUPTION = false;
    private final int DEFAULT_MIN_BROKERS = 1;
    private final int DEFAULT_MAX_BROKERS = 15;
    public final long DEFAULT_SYNCH_PERIOD = 120000L;
    public final long DEFAULT_MAX_SHUTDOWN_WAIT = 45000L;
    public final int DEFAULT_COLLECTION_BUFFER_SIZE = 128;
    public static final String PROPERTY_PAGE_SIZE = "db-connection.page-size";
    public static final int DEFAULT_PAGE_SIZE = 4096;
    private boolean transactionsEnabled;
    private String instanceName;
    private static final int OPERATING = 0;
    private static final int INITIALIZING = 1;
    private static final int SHUTDOWN = 2;
    private int status = 0;
    private int brokersCount = 0;
    private int minBrokers;
    private int maxBrokers;
    private Stack inactiveBrokers = new Stack();
    private Map activeBrokers = new HashMap();
    protected Configuration conf = null;
    private boolean syncRequired = false;
    private int syncEvent = 0;
    private boolean checkpoint = false;
    private boolean isReadOnly;
    private int pageSize;
    private FileLock dataLock;
    private TransactionManager transactionManager = null;
    private long maxShutdownWait;
    private Scheduler scheduler;
    private IndexManager indexManager;
    private SymbolTable symbols;
    private long majorSyncPeriod = 120000L;
    private long lastMajorSync = System.currentTimeMillis();
    private ShutdownListener shutdownListener = null;
    private SecurityManager securityManager = null;
    private NotificationService notificationService = null;
    private long nextSystemStatus = System.currentTimeMillis();
    private List systemTasks = new ArrayList();
    private Stack waitingSystemTasks = new Stack();
    private DefaultCacheManager cacheManager;
    private CollectionCacheManager collectionCacheMgr;
    private long reservedMem;
    private XQueryPool xQueryPool;
    private ProcessMonitor processMonitor;
    private CollectionConfigurationManager collectionConfigurationManager = null;
    protected CollectionCache collectionCache;
    protected XMLReaderPool xmlReaderPool;
    private NodeIdFactory nodeFactory = new DLNFactory();
    private Lock globalXUpdateLock = new ReentrantReadWriteLock("xupdate");
    private User serviceModeUser = null;
    private boolean inServiceMode = false;

    public static final void setRegisterShutdownHook(boolean register) {
        registerShutdownHook = register;
    }

    public static final void configure(int minBrokers, int maxBrokers, Configuration config) throws EXistException, DatabaseConfigurationException {
        BrokerPool.configure(DEFAULT_INSTANCE_NAME, minBrokers, maxBrokers, config);
    }

    public static final void configure(String instanceName, int minBrokers, int maxBrokers, Configuration config) throws EXistException, DatabaseConfigurationException {
        BrokerPool instance = (BrokerPool)instances.get(instanceName);
        if (instance == null) {
            LOG.debug((Object)("configuring database instance '" + instanceName + "'..."));
            instance = new BrokerPool(instanceName, minBrokers, maxBrokers, config);
            instances.put(instanceName, instance);
            if (instances.size() == 1 && registerShutdownHook) {
                try {
                    Runtime.getRuntime().addShutdownHook(shutdownHook);
                    LOG.debug((Object)"shutdown hook registered");
                }
                catch (IllegalArgumentException e) {
                    LOG.warn((Object)"shutdown hook already registered");
                }
            }
        } else {
            LOG.warn((Object)("database instance '" + instanceName + "' is already configured"));
        }
    }

    public static final boolean isConfigured() {
        return BrokerPool.isConfigured(DEFAULT_INSTANCE_NAME);
    }

    public static final boolean isConfigured(String id) {
        BrokerPool instance = (BrokerPool)instances.get(id);
        if (instance == null) {
            return false;
        }
        return instance.isInstanceConfigured();
    }

    public static final BrokerPool getInstance() throws EXistException {
        return BrokerPool.getInstance(DEFAULT_INSTANCE_NAME);
    }

    public static final BrokerPool getInstance(String instanceName) throws EXistException {
        BrokerPool instance = (BrokerPool)instances.get(instanceName);
        if (instance != null) {
            return instance;
        }
        throw new EXistException("database instance '" + instanceName + "' is not available");
    }

    public static final Iterator getInstances() {
        return instances.values().iterator();
    }

    public static final void stop() throws EXistException {
        BrokerPool.stop(DEFAULT_INSTANCE_NAME);
    }

    public static final void stop(String id) throws EXistException {
        BrokerPool instance = (BrokerPool)instances.get(id);
        if (instance == null) {
            throw new EXistException("database instance '" + id + "' is not available");
        }
        instance.shutdown();
    }

    public static final void stopAll(boolean killed) {
        Vector tmpInstances = new Vector();
        Iterator i = instances.values().iterator();
        while (i.hasNext()) {
            tmpInstances.add(i.next());
        }
        Iterator i2 = tmpInstances.iterator();
        while (i2.hasNext()) {
            BrokerPool instance = (BrokerPool)i2.next();
            if (instance.conf == null) continue;
            instance.shutdown(killed);
        }
        instances.clear();
    }

    public static void registerStatusObserver(Observer observer) {
        statusObserver = observer;
        LOG.debug((Object)("registering observer: " + observer.getClass().getName()));
    }

    private BrokerPool(String instanceName, int minBrokers, int maxBrokers, Configuration conf) throws EXistException, DatabaseConfigurationException {
        NumberFormat nf = NumberFormat.getNumberInstance();
        if (statusObserver != null) {
            this.addObserver(statusObserver);
        }
        this.instanceName = instanceName;
        this.minBrokers = 1;
        this.maxBrokers = 15;
        this.maxShutdownWait = 45000L;
        this.transactionsEnabled = true;
        this.minBrokers = minBrokers;
        this.maxBrokers = maxBrokers;
        Integer anInteger = (Integer)conf.getProperty(PROPERTY_MIN_CONNECTIONS);
        if (anInteger != null) {
            this.minBrokers = anInteger;
        }
        if ((anInteger = (Integer)conf.getProperty(PROPERTY_MAX_CONNECTIONS)) != null) {
            this.maxBrokers = anInteger;
        }
        LOG.info((Object)("database instance '" + instanceName + "' will have between " + nf.format(this.minBrokers) + " and " + nf.format(this.maxBrokers) + " brokers"));
        Long aLong = (Long)conf.getProperty(PROPERTY_SYNC_PERIOD);
        if (aLong != null) {
            this.majorSyncPeriod = aLong;
        }
        LOG.info((Object)("database instance '" + instanceName + "' will be synchronized every " + nf.format(this.majorSyncPeriod) + " ms"));
        aLong = (Long)conf.getProperty("wait-before-shutdown");
        if (aLong != null) {
            this.maxShutdownWait = aLong;
        }
        LOG.info((Object)("database instance '" + instanceName + "' will wait  " + nf.format(this.maxShutdownWait) + " ms during shutdown"));
        Boolean aBoolean = (Boolean)conf.getProperty(PROPERTY_RECOVERY_ENABLED);
        if (aBoolean != null) {
            this.transactionsEnabled = aBoolean;
        }
        LOG.info((Object)("database instance '" + instanceName + "' is enabled for transactions : " + this.transactionsEnabled));
        this.pageSize = conf.getInteger(PROPERTY_PAGE_SIZE);
        if (this.pageSize < 0) {
            this.pageSize = 4096;
        }
        this.scheduler = new Scheduler(this, conf);
        this.isReadOnly = !this.canReadDataDir(conf);
        LOG.debug((Object)("isReadOnly: " + this.isReadOnly));
        this.conf = conf;
        this.initialize();
        if (this.majorSyncPeriod > 0L) {
            this.scheduler.createPeriodicJob(2500L, new Sync(), 2500L);
        }
    }

    protected boolean canReadDataDir(Configuration conf) throws EXistException {
        File dir;
        String dataDir = (String)conf.getProperty(PROPERTY_DATA_DIR);
        if (dataDir == null) {
            dataDir = "data";
        }
        if (!(dir = new File(dataDir)).exists()) {
            try {
                LOG.info((Object)("Data directory '" + dir.getAbsolutePath() + "' does not exist. Creating one ..."));
                dir.mkdirs();
            }
            catch (SecurityException e) {
                LOG.info((Object)("Cannot create data directory '" + dir.getAbsolutePath() + "'. Switching to read-only mode."));
                return false;
            }
        }
        conf.setProperty(PROPERTY_DATA_DIR, dataDir);
        if (!dir.canWrite()) {
            LOG.info((Object)("Cannot write to data directory: " + dir.getAbsolutePath() + ". Switching to read-only mode."));
            return false;
        }
        this.dataLock = new FileLock(this, dir, "dbx_dir.lck");
        try {
            boolean locked = this.dataLock.tryLock();
            if (!locked) {
                throw new EXistException("The database directory seems to be locked by another database instance. Found a valid lock file: " + this.dataLock.getFile());
            }
        }
        catch (ReadOnlyException e) {
            LOG.info((Object)(e.getMessage() + ". Switching to read-only mode!!!"));
            return false;
        }
        return true;
    }

    protected SecurityManager newSecurityManager() {
        try {
            Class smClass = (Class)this.conf.getProperty(PROPERTY_SECURITY_CLASS);
            return (SecurityManager)smClass.newInstance();
        }
        catch (Throwable ex) {
            LOG.warn((Object)"Exception while instantiating security manager class.", ex);
            return null;
        }
    }

    protected void initialize() throws EXistException, DatabaseConfigurationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("initializing database instance '" + this.instanceName + "'..."));
        }
        this.status = 1;
        this.signalSystemStatus(SIGNAL_STARTUP);
        this.cacheManager = new DefaultCacheManager(this);
        this.xQueryPool = new XQueryPool(this.conf);
        this.processMonitor = new ProcessMonitor();
        this.xmlReaderPool = new XMLReaderPool(this.conf, (PoolableObjectFactory)new XMLReaderObjectFactory(this), 5, 0);
        int bufferSize = this.conf.getInteger(PROPERTY_COLLECTION_CACHE_SIZE);
        if (bufferSize == -1) {
            bufferSize = 128;
        }
        this.collectionCache = new CollectionCache(this, bufferSize, 0.001);
        this.collectionCacheMgr = new CollectionCacheManager(this.conf, this.collectionCache);
        Runtime rt = Runtime.getRuntime();
        this.reservedMem = this.cacheManager.getTotalMem() + this.collectionCacheMgr.getMaxTotal() + rt.maxMemory() / 5L;
        this.notificationService = new NotificationService();
        this.transactionManager = new TransactionManager(this, new File((String)this.conf.getProperty(PROPERTY_DATA_DIR)), this.isTransactional());
        try {
            this.transactionManager.initialize();
        }
        catch (ReadOnlyException e) {
            LOG.warn((Object)(e.getMessage() + ". Switching to read-only mode!!!"));
            this.isReadOnly = true;
        }
        this.indexManager = new IndexManager(this, this.conf);
        this.symbols = new SymbolTable(this, this.conf.getProperty(PROPERTY_DATA_DIR).toString(), this.conf);
        this.isReadOnly = this.isReadOnly || !this.symbols.getFile().canWrite();
        this.createBroker();
        DBBroker broker = (DBBroker)this.inactiveBrokers.peek();
        if (broker.isReadOnly()) {
            this.transactionManager.setEnabled(false);
            this.isReadOnly = true;
        }
        boolean recovered = false;
        if (this.isTransactional() && !(recovered = this.transactionManager.runRecovery(broker)) && broker.getCollection(XmldbURI.ROOT_COLLECTION_URI) == null) {
            Txn txn = this.transactionManager.beginTransaction();
            try {
                broker.getOrCreateCollection(txn, XmldbURI.ROOT_COLLECTION_URI);
                this.transactionManager.commit(txn);
            }
            catch (IOException e) {
                this.transactionManager.abort(txn);
            }
            catch (PermissionDeniedException e) {
                this.transactionManager.abort(txn);
            }
        }
        SecurityManager localSecurityManager = this.newSecurityManager();
        this.securityManager = null;
        localSecurityManager.attach(this, broker);
        this.securityManager = localSecurityManager;
        this.status = 0;
        if (this.securityManager.isXACMLEnabled()) {
            this.securityManager.getPDP().initializePolicyCollection();
        }
        try {
            this.collectionConfigurationManager = new CollectionConfigurationManager(broker);
        }
        catch (Exception e) {
            LOG.error((Object)("Found an error while initializing database: " + e.getMessage()), (Throwable)e);
        }
        if (recovered) {
            try {
                broker.setUser(SecurityManager.SYSTEM_USER);
                broker.repair();
            }
            catch (PermissionDeniedException e) {
                LOG.warn((Object)("Error during recovery: " + e.getMessage()), (Throwable)e);
            }
            if (((Boolean)this.conf.getProperty(PROPERTY_RECOVERY_CHECK)).booleanValue()) {
                ConsistencyCheckTask task = new ConsistencyCheckTask();
                Properties props = new Properties();
                props.setProperty("backup", "no");
                props.setProperty("output", "sanity");
                task.configure(this.conf, props);
                task.execute(broker);
            }
        }
        broker.cleanUpTempResources(true);
        this.sync(broker, 1);
        for (int i = 1; i < this.minBrokers; ++i) {
            this.createBroker();
        }
        AgentFactory.getInstance().initDBInstance(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("database instance '" + this.instanceName + "' initialized"));
        }
        this.scheduler.run();
    }

    public long getReservedMem() {
        return this.reservedMem - this.cacheManager.getSizeInBytes();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void signalSystemStatus(String signal) {
        if (System.currentTimeMillis() > this.nextSystemStatus) {
            this.setChanged();
            this.notifyObservers(signal);
            this.nextSystemStatus = System.currentTimeMillis() + 10000L;
        }
    }

    public boolean isInitializing() {
        return this.status == 1;
    }

    public String getId() {
        return this.instanceName;
    }

    public int active() {
        return this.activeBrokers.size();
    }

    public Map getActiveBrokers() {
        return new HashMap(this.activeBrokers);
    }

    public int available() {
        return this.inactiveBrokers.size();
    }

    public int getMax() {
        return this.maxBrokers;
    }

    public final boolean isInstanceConfigured() {
        return this.conf != null;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public void registerShutdownListener(ShutdownListener listener) {
        this.shutdownListener = listener;
    }

    public NodeIdFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public SymbolTable getSymbols() {
        return this.symbols;
    }

    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    public boolean isTransactional() {
        return !this.isReadOnly && this.transactionsEnabled;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isInServiceMode() {
        return this.inServiceMode;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public CollectionConfigurationManager getConfigurationManager() {
        return this.collectionConfigurationManager;
    }

    public CollectionCache getCollectionsCache() {
        return this.collectionCache;
    }

    public DefaultCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public CollectionCacheManager getCollectionCacheMgr() {
        return this.collectionCacheMgr;
    }

    public IndexManager getIndexManager() {
        return this.indexManager;
    }

    public XQueryPool getXQueryPool() {
        return this.xQueryPool;
    }

    public ProcessMonitor getProcessMonitor() {
        return this.processMonitor;
    }

    public XMLReaderPool getParserPool() {
        return this.xmlReaderPool;
    }

    public Lock getGlobalUpdateLock() {
        return this.globalXUpdateLock;
    }

    protected DBBroker createBroker() throws EXistException {
        DBBroker broker = BrokerFactory.getInstance(this, this.getConfiguration());
        this.inactiveBrokers.push(broker);
        ++this.brokersCount;
        broker.setId(broker.getClass().getName() + '_' + this.instanceName + "_" + this.brokersCount);
        LOG.debug((Object)("created broker '" + broker.getId() + " for database instance '" + this.instanceName + "'"));
        return broker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBBroker get(User user) throws EXistException {
        if (!this.isInstanceConfigured()) {
            throw new EXistException("database instance '" + this.instanceName + "' is not available");
        }
        DBBroker broker = (DBBroker)this.activeBrokers.get(Thread.currentThread());
        if (broker != null) {
            broker.incReferenceCount();
            if (user != null) {
                broker.setUser(user);
            }
            return broker;
        }
        BrokerPool brokerPool = this;
        synchronized (brokerPool) {
            while (this.serviceModeUser != null && user != null && !user.equals(this.serviceModeUser)) {
                try {
                    LOG.debug((Object)"Db instance is in service mode. Waiting for db to become available again ...");
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            if (this.inactiveBrokers.isEmpty()) {
                if (this.brokersCount < this.maxBrokers) {
                    this.createBroker();
                } else {
                    while (this.inactiveBrokers.isEmpty()) {
                        LOG.debug((Object)"waiting for a broker to become available");
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {}
                    }
                }
            }
            broker = (DBBroker)this.inactiveBrokers.pop();
            this.activeBrokers.put(Thread.currentThread(), broker);
            broker.incReferenceCount();
            if (user != null) {
                broker.setUser(user);
            }
            this.notifyAll();
            return broker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(DBBroker broker) {
        if (broker == null) {
            return;
        }
        broker.decReferenceCount();
        if (broker.getReferenceCount() > 0) {
            return;
        }
        BrokerPool brokerPool = this;
        synchronized (brokerPool) {
            for (int i = 0; i < this.inactiveBrokers.size(); ++i) {
                if (broker != this.inactiveBrokers.get(i)) continue;
                LOG.error((Object)"Broker is already in the inactive list!!!");
                return;
            }
            this.activeBrokers.remove(Thread.currentThread());
            this.inactiveBrokers.push(broker);
            if (this.activeBrokers.size() == 0) {
                if (this.syncRequired) {
                    this.sync(broker, this.syncEvent);
                    this.syncRequired = false;
                    this.checkpoint = false;
                }
                this.processWaitingTasks(broker);
                if (this.serviceModeUser != null && !broker.getUser().equals(this.serviceModeUser)) {
                    this.inServiceMode = true;
                }
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterServiceMode(User user) throws PermissionDeniedException {
        if (!user.hasDbaRole()) {
            throw new PermissionDeniedException("Only users of group dba can switch the db to service mode");
        }
        this.serviceModeUser = user;
        BrokerPool brokerPool = this;
        synchronized (brokerPool) {
            if (this.activeBrokers.size() != 0) {
                while (!this.inServiceMode) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        this.inServiceMode = true;
        DBBroker broker = (DBBroker)this.inactiveBrokers.peek();
        this.checkpoint = true;
        this.sync(broker, 1);
        this.checkpoint = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exitServiceMode(User user) throws PermissionDeniedException {
        if (!user.equals(this.serviceModeUser)) {
            throw new PermissionDeniedException("The db has been locked by a different user");
        }
        this.serviceModeUser = null;
        this.inServiceMode = false;
        BrokerPool brokerPool = this;
        synchronized (brokerPool) {
            this.notifyAll();
        }
    }

    public void reloadSecurityManager(DBBroker broker) {
        this.securityManager = this.newSecurityManager();
        this.securityManager.attach(this, broker);
        LOG.debug((Object)"Security manager reloaded");
    }

    public long getMajorSyncPeriod() {
        return this.majorSyncPeriod;
    }

    public long getLastMajorSync() {
        return this.lastMajorSync;
    }

    private void sync(DBBroker broker, int syncEvent) {
        broker.sync(syncEvent);
        User user = broker.getUser();
        broker.setUser(SecurityManager.SYSTEM_USER);
        if (this.status != 2) {
            broker.cleanUpTempResources();
        }
        if (syncEvent == 1) {
            try {
                if (!FORCE_CORRUPTION) {
                    this.transactionManager.checkpoint(this.checkpoint);
                }
            }
            catch (TransactionException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
            this.cacheManager.checkCaches();
            this.lastMajorSync = System.currentTimeMillis();
            if (LOG.isDebugEnabled()) {
                this.notificationService.debug();
            }
        } else {
            this.cacheManager.checkDistribution();
        }
        broker.setUser(user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerSync(int syncEvent) {
        if (this.status == 2) {
            return;
        }
        BrokerPool brokerPool = this;
        synchronized (brokerPool) {
            if (this.inactiveBrokers.size() == this.brokersCount) {
                DBBroker broker = (DBBroker)this.inactiveBrokers.peek();
                this.sync(broker, syncEvent);
                this.syncRequired = false;
            } else {
                this.syncEvent = syncEvent;
                this.syncRequired = true;
            }
        }
    }

    private void runSystemTask(DBBroker broker, SystemTask task) {
        if (this.status == 2) {
            return;
        }
        try {
            this.sync(broker, 1);
            LOG.debug((Object)("Running system maintenance task: " + task.getClass().getName()));
            task.execute(broker);
        }
        catch (Exception e) {
            LOG.warn((Object)("System maintenance task reported error: " + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerSystemTask(SystemTask task) {
        BrokerPool brokerPool = this;
        synchronized (brokerPool) {
            if (this.inactiveBrokers.size() == this.brokersCount) {
                DBBroker broker = (DBBroker)this.inactiveBrokers.peek();
                this.runSystemTask(broker, task);
            } else {
                this.waitingSystemTasks.push(task);
            }
        }
    }

    private void processWaitingTasks(DBBroker broker) {
        while (this.waitingSystemTasks != null && !this.waitingSystemTasks.isEmpty()) {
            SystemTask task = (SystemTask)this.waitingSystemTasks.pop();
            this.runSystemTask(broker, task);
        }
    }

    public synchronized void shutdown() {
        this.shutdown(false);
    }

    public boolean isShuttingDown() {
        return this.status == 2;
    }

    public synchronized void shutdown(boolean killed) {
        if (this.status == 2) {
            return;
        }
        LOG.info((Object)"Database is shutting down ...");
        this.status = 2;
        this.notificationService.debug();
        this.scheduler.shutdown(false);
        while (!this.scheduler.isShutdown()) {
            try {
                this.wait(250L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.signalSystemStatus(SIGNAL_SHUTDOWN);
        }
        this.processMonitor.killAll(500L);
        if (this.isTransactional()) {
            this.transactionManager.getJournal().flushToLog(true, true);
        }
        boolean hangingThreads = false;
        long waitStart = System.currentTimeMillis();
        if (this.activeBrokers.size() > 0) {
            LOG.info((Object)("Waiting " + this.maxShutdownWait + "ms for remaining threads to shut down..."));
            while (this.activeBrokers.size() > 0) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.signalSystemStatus(SIGNAL_SHUTDOWN);
                if (this.maxShutdownWait <= -1L || System.currentTimeMillis() - waitStart <= this.maxShutdownWait) continue;
                LOG.warn((Object)"Not all threads returned. Forcing shutdown ...");
                hangingThreads = true;
                break;
            }
        }
        LOG.debug((Object)"Calling shutdown ...");
        try {
            this.indexManager.shutdown();
        }
        catch (DBException e) {
            LOG.warn((Object)("Error during index shutdown: " + e.getMessage()), (Throwable)e);
        }
        DBBroker broker = null;
        if (this.inactiveBrokers.isEmpty()) {
            try {
                broker = this.createBroker();
            }
            catch (EXistException e) {
                LOG.warn((Object)"could not create instance for shutdown. Giving up.");
            }
        } else {
            broker = (DBBroker)this.inactiveBrokers.peek();
        }
        if (broker != null) {
            broker.setUser(SecurityManager.SYSTEM_USER);
            broker.shutdown();
        }
        this.collectionCacheMgr.deregisterCache(this.collectionCache);
        this.signalSystemStatus(SIGNAL_SHUTDOWN);
        if (hangingThreads) {
            this.transactionManager.shutdown(false);
        } else {
            this.transactionManager.shutdown(true);
        }
        AgentFactory.getInstance().closeDBInstance(this);
        this.conf = null;
        instances.remove(this.instanceName);
        if (!this.isReadOnly) {
            this.dataLock.release();
        }
        LOG.info((Object)"shutdown complete !");
        if (instances.size() == 0 && !killed) {
            LOG.debug((Object)"removing shutdown hook");
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
        }
        if (this.shutdownListener != null) {
            this.shutdownListener.shutdown(this.instanceName, instances.size());
        }
        this.transactionManager = null;
        this.collectionCache = null;
        this.collectionCacheMgr = null;
        this.xQueryPool = null;
        this.processMonitor = null;
        this.collectionConfigurationManager = null;
        this.notificationService = null;
        this.indexManager = null;
        this.scheduler = null;
        this.systemTasks = null;
        this.waitingSystemTasks.clear();
        this.xmlReaderPool = null;
        this.shutdownListener = null;
        this.securityManager = null;
        this.notificationService = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerCheckpoint() {
        if (this.syncRequired) {
            return;
        }
        BrokerPool brokerPool = this;
        synchronized (brokerPool) {
            this.syncEvent = 1;
            this.syncRequired = true;
            this.checkpoint = true;
        }
    }
}

