/*
 * Decompiled with CFR 0.152.
 */
package org.exist.stax;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.exist.dom.AttrImpl;
import org.exist.dom.CharacterDataImpl;
import org.exist.dom.DocumentImpl;
import org.exist.dom.ElementImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.StoredNode;
import org.exist.numbering.NodeId;
import org.exist.storage.DBBroker;
import org.exist.storage.Signatures;
import org.exist.storage.btree.Value;
import org.exist.storage.dom.RawNodeIterator;
import org.exist.util.ByteConversion;
import org.exist.util.XMLString;
import org.exist.util.serializer.AttrList;
import org.w3c.dom.ProcessingInstruction;

public class EmbeddedXMLStreamReader
implements XMLStreamReader {
    public static final String PROPERTY_NODE_ID = "node-id";
    private RawNodeIterator iterator;
    private Value current = null;
    private Value previous = null;
    private Stack elementStack = new Stack();
    private int state = 7;
    private DocumentImpl document;
    private NodeId nodeId;
    private QName qname = null;
    private XMLString text = new XMLString(256);
    private List namespaces = new ArrayList(6);
    private boolean nsRead = false;
    private AttrList attributes = null;
    private boolean reportAttribs = false;
    private DBBroker broker;

    public EmbeddedXMLStreamReader(DBBroker broker, DocumentImpl doc, RawNodeIterator iterator, boolean reportAttributes) throws XMLStreamException {
        this.broker = broker;
        this.document = doc;
        this.iterator = iterator;
        this.reportAttribs = reportAttributes;
    }

    public void reposition(DBBroker broker, StoredNode node, boolean reportAttributes) throws IOException {
        this.reset();
        this.broker = broker;
        this.current = null;
        this.previous = null;
        this.elementStack.clear();
        this.state = 7;
        this.reportAttribs = reportAttributes;
        this.document = (DocumentImpl)node.getOwnerDocument();
        this.iterator.seek(node);
    }

    public void reposition(DBBroker broker, NodeProxy proxy, boolean reportAttributes) throws IOException {
        this.reset();
        this.broker = broker;
        this.current = null;
        this.previous = null;
        this.elementStack.clear();
        this.state = 7;
        this.reportAttribs = reportAttributes;
        this.document = (DocumentImpl)proxy.getOwnerDocument();
        this.iterator.seek(proxy);
    }

    public short getNodeType() {
        return Signatures.getType(this.current.data()[this.current.start()]);
    }

    private void initNode() {
        short type = Signatures.getType(this.current.data()[this.current.start()]);
        switch (type) {
            case 1: {
                this.state = 1;
                this.elementStack.push(new ElementEvent(this.current));
                break;
            }
            case 2: {
                this.state = 10;
                break;
            }
            case 3: {
                this.state = 4;
                break;
            }
            case 8: {
                this.state = 5;
                break;
            }
            case 4: {
                this.state = 12;
                break;
            }
            case 7: {
                this.state = 3;
            }
        }
        this.reset();
        this.readNodeId();
    }

    private void skipAttributes() throws XMLStreamException {
        if (this.attributes == null) {
            ElementEvent parent = (ElementEvent)this.elementStack.peek();
            int attrs = this.getAttributeCount();
            for (int i = 0; i < attrs; ++i) {
                this.iterator.next();
                parent.incrementChild();
            }
        }
    }

    private void readAttributes() {
        if (this.attributes == null) {
            ElementEvent parent = (ElementEvent)this.elementStack.peek();
            int count = this.getAttributeCount();
            this.attributes = new AttrList();
            for (int i = 0; i < count; ++i) {
                Value v = this.iterator.next();
                AttrImpl.addToList(this.broker, v.data(), v.start(), v.getLength(), this.attributes);
                parent.incrementChild();
            }
        }
    }

    private void readNodeId() {
        int offset = this.current.start() + 1;
        if (this.state == 1 || this.state == 2) {
            offset += 4;
        }
        short dlnLen = ByteConversion.byteToShort(this.current.data(), offset);
        this.nodeId = this.broker.getBrokerPool().getNodeFactory().createFromData(dlnLen, this.current.data(), offset += 2);
    }

    public int next() throws XMLStreamException {
        if (this.state != 2) {
            this.previous = this.current;
        }
        if (this.state == 1 && !this.reportAttribs) {
            this.skipAttributes();
        }
        if (!this.elementStack.isEmpty()) {
            ElementEvent parent = (ElementEvent)this.elementStack.peek();
            if (parent.getChildCount() == parent.getCurrentChild()) {
                this.elementStack.pop();
                this.state = 2;
                this.current = parent.data;
                this.reset();
                return this.state;
            }
            parent.incrementChild();
        } else if (this.state != 7) {
            throw new NoSuchElementException();
        }
        this.current = this.iterator.next();
        this.initNode();
        return this.state;
    }

    private void reset() {
        this.nodeId = null;
        this.qname = null;
        this.attributes = null;
        this.text.reuse();
        if (this.state != 2) {
            this.namespaces.clear();
            this.nsRead = false;
        }
    }

    public void require(int i, String string, String string1) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public String getElementText() throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        if (string.equals(PROPERTY_NODE_ID)) {
            if (this.nodeId == null) {
                this.readNodeId();
            }
            return this.nodeId;
        }
        return null;
    }

    public int nextTag() throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext() throws XMLStreamException {
        return this.state == 7 || !this.elementStack.isEmpty();
    }

    public void close() throws XMLStreamException {
        this.iterator.closeDocument();
    }

    public boolean isStartElement() {
        return this.state == 1;
    }

    public boolean isEndElement() {
        return this.state == 2;
    }

    public boolean isCharacters() {
        return this.state == 4;
    }

    public boolean isWhiteSpace() {
        return false;
    }

    public String getAttributeValue(String string, String string1) {
        throw new UnsupportedOperationException();
    }

    public int getAttributeCount() {
        int offset = this.current.start() + 1 + 4 + 2 + this.nodeId.size();
        return ByteConversion.byteToShort(this.current.data(), offset);
    }

    public QName getAttributeName(int i) {
        if (this.state != 1) {
            throw new IllegalStateException("Cursor is not at an element");
        }
        this.readAttributes();
        if (i > this.attributes.getLength()) {
            throw new ArrayIndexOutOfBoundsException("index should be < " + this.attributes.getLength());
        }
        return this.attributes.getQName(i).toJavaQName();
    }

    public String getAttributeNamespace(int i) {
        if (this.state != 1) {
            throw new IllegalStateException("Cursor is not at an element");
        }
        this.readAttributes();
        if (i > this.attributes.getLength()) {
            throw new ArrayIndexOutOfBoundsException("index should be < " + this.attributes.getLength());
        }
        return this.attributes.getQName(i).getNamespaceURI();
    }

    public String getAttributeLocalName(int i) {
        if (this.state != 1) {
            throw new IllegalStateException("Cursor is not at an element");
        }
        this.readAttributes();
        if (i > this.attributes.getLength()) {
            throw new ArrayIndexOutOfBoundsException("index should be < " + this.attributes.getLength());
        }
        return this.attributes.getQName(i).getLocalName();
    }

    public String getAttributePrefix(int i) {
        if (this.state != 1) {
            throw new IllegalStateException("Cursor is not at an element");
        }
        this.readAttributes();
        if (i > this.attributes.getLength()) {
            throw new ArrayIndexOutOfBoundsException("index should be < " + this.attributes.getLength());
        }
        return this.attributes.getQName(i).getPrefix();
    }

    public String getAttributeType(int i) {
        if (this.state != 1) {
            throw new IllegalStateException("Cursor is not at an element");
        }
        this.readAttributes();
        if (i > this.attributes.getLength()) {
            throw new ArrayIndexOutOfBoundsException("index should be < " + this.attributes.getLength());
        }
        int type = this.attributes.getType(i);
        if (type == 1) {
            return "ID";
        }
        if (type == 2) {
            return "IDREF";
        }
        if (type == 3) {
            return "IDREFS";
        }
        return "CDATA";
    }

    public String getAttributeValue(int i) {
        if (this.state != 1) {
            throw new IllegalStateException("Cursor is not at an element");
        }
        this.readAttributes();
        if (i > this.attributes.getLength()) {
            throw new ArrayIndexOutOfBoundsException("index should be < " + this.attributes.getLength());
        }
        return this.attributes.getValue(i);
    }

    public boolean isAttributeSpecified(int i) {
        return false;
    }

    public int getNamespaceCount() {
        this.readNamespaceDecls();
        return this.namespaces.size();
    }

    public String getNamespacePrefix(int i) {
        this.readNamespaceDecls();
        if (i < 0 || i > this.namespaces.size()) {
            return null;
        }
        String[] decl = (String[])this.namespaces.get(i);
        return decl[0];
    }

    public String getNamespaceURI(int i) {
        this.readNamespaceDecls();
        if (i < 0 || i > this.namespaces.size()) {
            return null;
        }
        String[] decl = (String[])this.namespaces.get(i);
        return decl[1];
    }

    public NamespaceContext getNamespaceContext() {
        throw new UnsupportedOperationException();
    }

    public int getEventType() {
        return this.state;
    }

    public String getText() {
        if (this.state == 4 || this.state == 5 || this.state == 12) {
            if (this.text.length() == 0) {
                CharacterDataImpl.readData(this.nodeId, this.current, this.text);
            }
            return this.text.toString();
        }
        return "";
    }

    public char[] getTextCharacters() {
        String s = this.getText();
        char[] dst = new char[s.length()];
        s.getChars(0, dst.length, dst, 0);
        return dst;
    }

    public int getTextCharacters(int sourceStart, char[] chars, int targetStart, int length) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public int getTextStart() {
        throw new UnsupportedOperationException();
    }

    public int getTextLength() {
        throw new UnsupportedOperationException();
    }

    public String getEncoding() {
        throw new UnsupportedOperationException();
    }

    public boolean hasText() {
        return this.state == 4 || this.state == 5 || this.state == 12;
    }

    public Location getLocation() {
        throw new UnsupportedOperationException();
    }

    public String getNamespaceURI(String string) {
        return null;
    }

    public QName getName() {
        if (this.qname != null) {
            return this.qname;
        }
        if (this.state == 1 || this.state == 2) {
            if (this.nodeId == null) {
                this.readNodeId();
            }
            this.qname = ElementImpl.readQName(this.current, this.document, this.nodeId).toJavaQName();
        }
        return this.qname;
    }

    public org.exist.dom.QName getQName() {
        if (this.state == 1 || this.state == 2) {
            if (this.nodeId == null) {
                this.readNodeId();
            }
            return ElementImpl.readQName(this.current, this.document, this.nodeId);
        }
        return null;
    }

    private void readNamespaceDecls() {
        if (this.nsRead) {
            return;
        }
        if (this.state == 1 || this.state == 2) {
            if (this.nodeId == null) {
                this.readNodeId();
            }
            ElementImpl.readNamespaceDecls(this.namespaces, this.current, this.document, this.nodeId);
        }
        this.nsRead = true;
    }

    public String getPrefix() {
        return this.getName().getPrefix();
    }

    public String getLocalName() {
        return this.getName().getLocalPart();
    }

    public String getNamespaceURI() {
        return this.getName().getNamespaceURI();
    }

    public boolean hasName() {
        return this.state == 1 || this.state == 2;
    }

    public StoredNode getNode() {
        StoredNode node = StoredNode.deserialize(this.current.data(), this.current.start(), this.current.getLength(), this.document);
        node.setOwnerDocument(this.document);
        node.setInternalAddress(this.current.getAddress());
        return node;
    }

    public StoredNode getPreviousNode() {
        StoredNode node = StoredNode.deserialize(this.previous.data(), this.previous.start(), this.previous.getLength(), this.document);
        node.setOwnerDocument(this.document);
        node.setInternalAddress(this.previous.getAddress());
        return node;
    }

    public long getCurrentPosition() {
        return this.iterator.currentAddress();
    }

    public String getVersion() {
        return "1.0";
    }

    public boolean isStandalone() {
        return false;
    }

    public boolean standaloneSet() {
        return false;
    }

    public String getCharacterEncodingScheme() {
        return null;
    }

    public String getPITarget() {
        this.readPI();
        return this.qname.getLocalPart();
    }

    public String getPIData() {
        this.readPI();
        return this.text.toString();
    }

    private void readPI() {
        if (this.qname == null) {
            if (this.state != 3) {
                throw new IllegalStateException("Cursor is not at a processing instruction");
            }
            ProcessingInstruction pi = (ProcessingInstruction)((Object)StoredNode.deserialize(this.current.data(), this.current.start(), this.current.getLength(), this.document));
            this.qname = new QName("", pi.getTarget(), "");
            this.text.append(pi.getData());
        }
    }

    private static class ElementEvent {
        private Value data;
        private int childCount = 0;
        private int currentChild = 0;

        public ElementEvent(Value data) {
            this.data = data;
            this.childCount = ByteConversion.byteToInt(data.data(), data.start() + 1);
        }

        public Value getData() {
            return this.data;
        }

        public int getChildCount() {
            return this.childCount;
        }

        public int getCurrentChild() {
            return this.currentChild;
        }

        public void setCurrentChild(int currentChild) {
            this.currentChild = currentChild;
        }

        public void incrementChild() {
            ++this.currentChild;
        }
    }
}

