/*
 * Decompiled with CFR 0.152.
 */
package org.exist.source;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.excalibur.source.SourceValidity;
import org.exist.source.AbstractSource;
import org.exist.source.Source;
import org.exist.storage.DBBroker;

public class CocoonSource
extends AbstractSource {
    private org.apache.excalibur.source.Source inputSource;
    private SourceValidity validity;
    private boolean checkEncoding = false;
    private String encoding = "UTF-8";

    public CocoonSource(org.apache.excalibur.source.Source source, boolean checkXQEncoding) {
        this.inputSource = source;
        this.validity = this.inputSource.getValidity();
        this.checkEncoding = checkXQEncoding;
    }

    public int isValid(DBBroker broker) {
        if (this.validity == null) {
            return 0;
        }
        int valid = this.validity.isValid();
        switch (valid) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return -1;
    }

    public int isValid(Source other) {
        SourceValidity validityOther = ((CocoonSource)other).inputSource.getValidity();
        if (this.validity == null || validityOther == null) {
            try {
                if (this.getContent().equals(((CocoonSource)other).getContent())) {
                    return 1;
                }
                return -1;
            }
            catch (IOException e) {
                return 0;
            }
        }
        int valid = this.validity.isValid(validityOther);
        switch (valid) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return -1;
    }

    public Reader getReader() throws IOException {
        this.checkEncoding();
        InputStream is = this.inputSource.getInputStream();
        return new InputStreamReader(is, this.encoding);
    }

    public String getContent() throws IOException {
        this.checkEncoding();
        int len = (int)this.inputSource.getContentLength();
        ByteArrayOutputStream os = len == -1 ? new ByteArrayOutputStream() : new ByteArrayOutputStream(len);
        byte[] t = new byte[512];
        InputStream is = this.inputSource.getInputStream();
        int count = 0;
        while ((count = is.read(t)) != -1) {
            os.write(t, 0, count);
        }
        return os.toString(this.encoding);
    }

    public Object getKey() {
        return this.inputSource.getURI();
    }

    public org.apache.excalibur.source.Source getWrappedSource() {
        return this.inputSource;
    }

    private void checkEncoding() throws IOException {
        String checkedEnc;
        if (this.checkEncoding && (checkedEnc = CocoonSource.guessXQueryEncoding(this.inputSource.getInputStream())) != null) {
            this.encoding = checkedEnc;
        }
    }
}

