/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security;

import java.io.DataInput;
import java.io.IOException;
import java.util.StringTokenizer;
import org.exist.security.Permission;
import org.exist.security.User;
import org.exist.util.SyntaxException;

public class UnixStylePermission
implements Permission {
    public static final int DEFAULT_PERM = 493;
    public static final Permission SYSTEM_DEFAULT = new UnixStylePermission(493);
    private String owner = "admin";
    private String ownerGroup = "dba";
    private int permissions = 493;

    public UnixStylePermission() {
    }

    public UnixStylePermission(int permissions) {
        this.permissions = permissions;
    }

    public UnixStylePermission(String user, String group, int permissions) {
        this.owner = user;
        this.ownerGroup = group;
        this.permissions = permissions;
    }

    public int getGroupPermissions() {
        return (this.permissions & 0x38) >> 3;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getOwnerGroup() {
        return this.ownerGroup;
    }

    public int getPermissions() {
        return this.permissions;
    }

    public int getPublicPermissions() {
        return this.permissions & 7;
    }

    public int getUserPermissions() {
        return (this.permissions & 0x1C0) >> 6;
    }

    public void read(DataInput istream) throws IOException {
        this.owner = istream.readUTF();
        this.ownerGroup = istream.readUTF();
        this.permissions = istream.readByte();
    }

    public void setGroup(String group) {
        this.ownerGroup = group;
    }

    public void setGroupPermissions(int perm) {
        this.permissions |= perm << 3;
    }

    public void setOwner(User user) {
        this.owner = user == null ? "guest" : user.getName();
    }

    public void setOwner(String user) {
        this.owner = user;
    }

    public void setPermissions(String str) throws SyntaxException {
        StringTokenizer tokenizer = new StringTokenizer(str, ",= ");
        int shift = -1;
        block3: while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equalsIgnoreCase("user")) {
                shift = 6;
                continue;
            }
            if (token.equalsIgnoreCase("group")) {
                shift = 3;
                continue;
            }
            if (token.equalsIgnoreCase("other")) {
                shift = 0;
                continue;
            }
            char modifier = token.charAt(0);
            if (modifier != '+' && modifier != '-') {
                throw new SyntaxException("expected modifier +|-");
            }
            if ((token = token.substring(1)).length() == 0) {
                throw new SyntaxException("'read', 'write' or 'update' expected in permission string");
            }
            int perm = token.equalsIgnoreCase("read") ? 4 : (token.equalsIgnoreCase("write") ? 2 : 1);
            switch (modifier) {
                case '+': {
                    this.permissions |= perm << shift;
                    continue block3;
                }
            }
            this.permissions &= ~(perm << shift);
        }
    }

    public void setPermissions(int perm) {
        this.permissions = perm;
    }

    public void setPublicPermissions(int perm) {
        this.permissions |= perm;
    }

    public void setUserPermissions(int perm) {
        this.permissions |= perm << 6;
    }

    public String toString() {
        char[] ch = new char[]{(this.permissions & 0x100) == 0 ? (char)'-' : 'r', (this.permissions & 0x80) == 0 ? (char)'-' : 'w', (this.permissions & 0x40) == 0 ? (char)'-' : 'u', (this.permissions & 0x20) == 0 ? (char)'-' : 'r', (this.permissions & 0x10) == 0 ? (char)'-' : 'w', (this.permissions & 8) == 0 ? (char)'-' : 'u', (this.permissions & 4) == 0 ? (char)'-' : 'r', (this.permissions & 2) == 0 ? (char)'-' : 'w', (this.permissions & 1) == 0 ? (char)'-' : 'u'};
        return new String(ch);
    }

    public boolean validate(User user, int perm) {
        if (user.hasDbaRole()) {
            return true;
        }
        if (user.getName().equals(this.owner)) {
            return this.validateUser(perm);
        }
        String[] groups = user.getGroups();
        for (int i = 0; i < groups.length; ++i) {
            if (!groups[i].equals(this.ownerGroup)) continue;
            return this.validateGroup(perm);
        }
        return this.validatePublic(perm);
    }

    private final boolean validateGroup(int perm) {
        return (this.permissions & (perm <<= 3)) == perm;
    }

    private final boolean validatePublic(int perm) {
        return (this.permissions & perm) == perm;
    }

    private final boolean validateUser(int perm) {
        return (this.permissions & (perm <<= 6)) == perm;
    }
}

