/*
 * Decompiled with CFR 0.152.
 */
package org.exist.scheduler;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.scheduler.UserJob;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.security.xacml.AccessContext;
import org.exist.source.DBSource;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.XQueryPool;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.StringValue;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class UserXQueryJob
extends UserJob {
    protected static final Logger LOG = Logger.getLogger((Class)UserXQueryJob.class);
    private String JOB_NAME = "XQuery";
    private String XQueryResource = null;
    private User user = null;

    public UserXQueryJob() {
    }

    public UserXQueryJob(String jobName, String XQueryResource, User user) {
        this.XQueryResource = XQueryResource;
        this.user = user;
        this.JOB_NAME = jobName == null ? this.JOB_NAME + ": " + XQueryResource : jobName;
    }

    public final String getName() {
        return this.JOB_NAME;
    }

    public void setName(String name) {
        this.JOB_NAME = name;
    }

    protected String getXQueryResource() {
        return this.XQueryResource;
    }

    protected User getUser() {
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(JobExecutionContext jec) throws JobExecutionException {
        block21: {
            JobDataMap jobDataMap = jec.getJobDetail().getJobDataMap();
            BrokerPool pool = (BrokerPool)jobDataMap.get((Object)"brokerpool");
            DBBroker broker = null;
            String xqueryresource = (String)jobDataMap.get((Object)"xqueryresource");
            User user = (User)jobDataMap.get((Object)"user");
            Properties params = (Properties)jobDataMap.get((Object)"params");
            if (pool == null || xqueryresource == null || user == null) {
                this.abort("BrokerPool or XQueryResource or User was null!");
            }
            try {
                broker = pool.get(user);
                XmldbURI pathUri = XmldbURI.create(xqueryresource);
                DocumentImpl resource = broker.getXMLResource(pathUri, 0);
                if (resource != null) {
                    DBSource source = new DBSource(broker, (BinaryDocument)resource, true);
                    XQuery xquery = broker.getXQueryService();
                    XQueryPool xqPool = xquery.getXQueryPool();
                    CompiledXQuery compiled = xqPool.borrowCompiledXQuery(broker, source);
                    XQueryContext context = compiled == null ? xquery.newContext(AccessContext.REST) : compiled.getContext();
                    context.setModuleLoadPath(XmldbURI.EMBEDDED_SERVER_URI.append(resource.getCollection().getURI()).toString());
                    context.setStaticallyKnownDocuments(new XmldbURI[]{resource.getCollection().getURI()});
                    if (compiled == null) {
                        try {
                            compiled = xquery.compile(context, source);
                        }
                        catch (IOException e) {
                            this.abort("Failed to read query from " + resource.getURI());
                        }
                    }
                    if (params != null) {
                        String bindingPrefix = params.getProperty("bindingPrefix");
                        if (bindingPrefix == null) {
                            bindingPrefix = "local";
                        }
                        Enumeration<Object> paramNames = params.keys();
                        while (paramNames.hasMoreElements()) {
                            String name = (String)paramNames.nextElement();
                            String value = params.getProperty(name);
                            context.declareVariable(bindingPrefix + ":" + name, new StringValue(value));
                        }
                    }
                    try {
                        xquery.execute(compiled, null);
                        break block21;
                    }
                    finally {
                        xqPool.returnCompiledXQuery(source, compiled);
                    }
                }
                LOG.warn((Object)("XQuery User Job not found: " + xqueryresource + ", job not scheduled"));
            }
            catch (EXistException ee) {
                this.abort("Could not get DBBroker!");
            }
            catch (PermissionDeniedException pde) {
                this.abort("Permission denied for the scheduling user: " + user.getName() + "!");
            }
            catch (XPathException xpe) {
                this.abort("XPathException in the Job: " + xpe.getMessage() + "!");
            }
            finally {
                if (pool != null && broker != null) {
                    pool.release(broker);
                }
            }
        }
    }

    private void abort(String message) throws JobExecutionException {
        JobExecutionException jaa = new JobExecutionException("UserXQueryJob Failed: " + message + " Unscheduling UserXQueryJob.", false);
        jaa.setUnscheduleAllTriggers(true);
        throw jaa;
    }
}

