/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler.embedded;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.exist.protocolhandler.embedded.EmbeddedUploadThread;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.storage.io.BlockingInputStream;

public class EmbeddedOutputStream
extends OutputStream {
    private static final Logger logger = Logger.getLogger((Class)EmbeddedOutputStream.class);
    private BlockingInputStream bis;
    private OutputStream bos;
    private EmbeddedUploadThread rt;

    public EmbeddedOutputStream(XmldbURL xmldbURL) {
        logger.debug((Object)"Initializing EmbeddedUploadThread");
        this.bis = new BlockingInputStream();
        this.bos = this.bis.getOutputStream();
        this.rt = new EmbeddedUploadThread(xmldbURL, this.bis);
        this.rt.start();
        logger.debug((Object)"Initializing EmbeddedUploadThread done");
    }

    public void write(int b) throws IOException {
        this.bos.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.bos.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.bos.write(b, off, len);
    }

    public void close() throws IOException {
        this.bos.close();
    }

    public void flush() throws IOException {
        this.bos.flush();
    }
}

