/*
 * Decompiled with CFR 0.152.
 */
package org.exist.memtree;

import org.exist.dom.QName;
import org.exist.memtree.DocumentImpl;
import org.exist.memtree.NodeImpl;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.StringValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class ProcessingInstructionImpl
extends NodeImpl
implements ProcessingInstruction {
    public ProcessingInstructionImpl(DocumentImpl doc, int nodeNumber) {
        super(doc, nodeNumber);
    }

    public String getTarget() {
        QName qn = (QName)this.document.namePool.get(this.document.nodeName[this.nodeNumber]);
        return qn != null ? qn.getLocalName() : null;
    }

    public String getStringValue() {
        return this.getData().replaceFirst("^\\s+", "");
    }

    public String getLocalName() {
        return this.getTarget();
    }

    public String getNamespaceURI() {
        return "";
    }

    public String getData() {
        return new String(this.document.characters, this.document.alpha[this.nodeNumber], this.document.alphaLen[this.nodeNumber]);
    }

    public AtomicValue atomize() throws XPathException {
        return new StringValue(this.getData());
    }

    public void setData(String arg0) throws DOMException {
    }

    public String getBaseURI() {
        String baseURI = "";
        int parent = -1;
        int test = -1;
        test = this.document.getParentNodeFor(this.nodeNumber);
        if (this.document.nodeKind[test] != 9) {
            parent = test;
        }
        while (parent != -1 && this.document.getNode(parent).getBaseURI() != null) {
            baseURI = "".equals(baseURI) ? this.document.getNode(parent).getBaseURI() : this.document.getNode(parent).getBaseURI() + "/" + baseURI;
            test = this.document.getParentNodeFor(parent);
            if (this.document.nodeKind[test] == 9) {
                return baseURI;
            }
            parent = test;
        }
        if ("".equals(baseURI)) {
            baseURI = this.getDocument().getBaseURI();
        }
        return baseURI;
    }

    public Node getFirstChild() {
        return null;
    }

    public int getItemType() {
        return 4;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("in-memory#");
        result.append("processing-instruction {");
        result.append(this.getTarget());
        result.append("} {");
        result.append(this.getData());
        result.append("} ");
        return result.toString();
    }
}

