/*
 * Decompiled with CFR 0.152.
 */
package org.exist.memtree;

import java.util.Iterator;
import java.util.Properties;
import org.exist.dom.DocumentSet;
import org.exist.dom.EmptyNodeSet;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.dom.QNameable;
import org.exist.dom.StoredNode;
import org.exist.memtree.DocumentBuilderReceiver;
import org.exist.memtree.DocumentImpl;
import org.exist.numbering.NodeId;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.Serializer;
import org.exist.util.serializer.DOMStreamer;
import org.exist.util.serializer.Receiver;
import org.exist.util.serializer.SerializerPool;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.UntypedAtomicValue;
import org.exist.xquery.value.ValueSequence;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class NodeImpl
implements Node,
NodeValue,
QNameable,
Comparable {
    public static final short REFERENCE_NODE = 100;
    public static final short NAMESPACE_NODE = 101;
    protected int nodeNumber;
    protected DocumentImpl document;

    public NodeImpl(DocumentImpl doc, int nodeNumber) {
        this.document = doc;
        this.nodeNumber = nodeNumber;
    }

    public int getNodeNumber() {
        return this.nodeNumber;
    }

    public int getImplementationType() {
        return 0;
    }

    public DocumentSet getDocumentSet() {
        return DocumentSet.EMPTY_DOCUMENT_SET;
    }

    public Iterator getCollectionIterator() {
        return EmptyNodeSet.EMPTY_ITERATOR;
    }

    public Node getNode() {
        return this;
    }

    public String getNodeName() {
        switch (this.getType()) {
            case 6: {
                return "#document";
            }
            case 1: 
            case 4: {
                QName qn = (QName)this.document.namePool.get(this.document.nodeName[this.nodeNumber]);
                return qn.getStringValue();
            }
            case 2: {
                return ((QName)this.document.namePool.get(this.document.attrName[this.nodeNumber])).getStringValue();
            }
            case 500: {
                return ((QName)this.document.namePool.get(this.document.namespaceCode[this.nodeNumber])).getStringValue();
            }
            case 3: {
                return "#text";
            }
            case 5: {
                return "#comment";
            }
            case 501: {
                return "#cdata-section";
            }
        }
        return "#unknown";
    }

    public QName getQName() {
        switch (this.getNodeType()) {
            case 1: 
            case 2: 
            case 7: {
                QName qn = (QName)this.document.namePool.get(this.document.nodeName[this.nodeNumber]);
                return qn;
            }
            case 9: {
                return QName.EMPTY_QNAME;
            }
            case 8: {
                return QName.EMPTY_QNAME;
            }
            case 3: {
                return QName.EMPTY_QNAME;
            }
            case 4: {
                return QName.EMPTY_QNAME;
            }
        }
        return null;
    }

    public void expand() throws DOMException {
        this.document.expand();
    }

    public void deepCopy() throws DOMException {
        DocumentImpl newDoc = this.document.expandRefs(this);
        if (newDoc != this.document) {
            this.nodeNumber = 1;
            this.document = newDoc;
        }
    }

    public String getNodeValue() throws DOMException {
        throw new RuntimeException(this.getClass().getName() + ": can not call getNodeValue() on node type " + this.getNodeType());
    }

    public void setNodeValue(String arg0) throws DOMException {
        throw new RuntimeException("Can not call setNodeValue() on node type " + this.getNodeType());
    }

    public short getNodeType() {
        if (this.document == null) {
            return 9;
        }
        return this.document.nodeKind[this.nodeNumber];
    }

    public Node getParentNode() {
        int next = this.document.next[this.nodeNumber];
        while (next > this.nodeNumber) {
            next = this.document.next[next];
        }
        if (next < 0) {
            return this.document;
        }
        return this.document.getNode(next);
    }

    public void addContextNode(int contextId, NodeValue node) {
        throw new RuntimeException("Can not call addContextNode() on node type " + this.getNodeType());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NodeImpl)) {
            return false;
        }
        return this.nodeNumber == ((NodeImpl)obj).nodeNumber;
    }

    public boolean equals(NodeValue other) throws XPathException {
        if (other.getImplementationType() != 0) {
            return false;
        }
        return this.nodeNumber == ((NodeImpl)other).nodeNumber;
    }

    public boolean after(NodeValue other, boolean isFollowing) throws XPathException {
        if (other.getImplementationType() != 0) {
            throw new XPathException("annot compare persistent node with in-memory node");
        }
        return this.nodeNumber < ((NodeImpl)other).nodeNumber;
    }

    public boolean before(NodeValue other, boolean isPreceding) throws XPathException {
        if (other.getImplementationType() != 0) {
            throw new XPathException("annot compare persistent node with in-memory node");
        }
        return this.nodeNumber > ((NodeImpl)other).nodeNumber;
    }

    public int compareTo(Object other) {
        if (!(other instanceof NodeImpl)) {
            return -1;
        }
        NodeImpl n = (NodeImpl)other;
        if (n.document == this.document) {
            if (this.nodeNumber == n.nodeNumber) {
                return 0;
            }
            if (this.nodeNumber < n.nodeNumber) {
                return -1;
            }
            return 1;
        }
        if (this.document.docId < n.document.docId) {
            return -1;
        }
        return 1;
    }

    public NodeList getChildNodes() {
        throw new RuntimeException("Can not call getChildNodes() on node type " + this.getNodeType());
    }

    public Node getFirstChild() {
        throw new RuntimeException("Can not call getFirstChild() on node type " + this.getNodeType());
    }

    public Node getLastChild() {
        throw new RuntimeException("Can not call getLastChild() on node type " + this.getNodeType());
    }

    public Node getPreviousSibling() {
        if (this.nodeNumber == 0) {
            return null;
        }
        int parent = this.document.getParentNodeFor(this.nodeNumber);
        int nextNode = this.document.getFirstChildFor(parent);
        while (nextNode >= parent && nextNode < this.nodeNumber) {
            int following = this.document.next[nextNode];
            if (following == this.nodeNumber) {
                return this.document.getNode(nextNode);
            }
            nextNode = following;
        }
        return null;
    }

    public Node getNextSibling() {
        int nextNr = this.document.next[this.nodeNumber];
        return nextNr < this.nodeNumber ? null : this.document.getNode(nextNr);
    }

    public NamedNodeMap getAttributes() {
        throw new RuntimeException("Can not call getAttributes() on node type " + this.getNodeType());
    }

    public Document getOwnerDocument() {
        return this.document;
    }

    public DocumentImpl getDocument() {
        return this.document;
    }

    public Node insertBefore(Node arg0, Node arg1) throws DOMException {
        throw new RuntimeException("Can not call insertBefore() on node type " + this.getNodeType());
    }

    public Node replaceChild(Node arg0, Node arg1) throws DOMException {
        throw new RuntimeException("Can not call replaceChild() on node type " + this.getNodeType());
    }

    public Node removeChild(Node arg0) throws DOMException {
        throw new RuntimeException("Can not call removeChild() on node type " + this.getNodeType());
    }

    public Node appendChild(Node arg0) throws DOMException {
        throw new RuntimeException("Can not call appendChild() on node type " + this.getNodeType());
    }

    public boolean hasChildNodes() {
        throw new RuntimeException("Can not call hasChildNodes() on node type " + this.getNodeType());
    }

    public Node cloneNode(boolean arg0) {
        throw new RuntimeException("Can not call cloneNode() on node type " + this.getNodeType());
    }

    public void normalize() {
        throw new RuntimeException("Can not call normalize() on node type " + this.getNodeType());
    }

    public boolean isSupported(String arg0, String arg1) {
        throw new RuntimeException("Can not call isSupported() on node type " + this.getNodeType());
    }

    public String getNamespaceURI() {
        throw new RuntimeException("Can not call getNamespaceURI() on node type " + this.getNodeType());
    }

    public String getPrefix() {
        throw new RuntimeException("Can not call getPrefix() on node type " + this.getNodeType());
    }

    public void setPrefix(String arg0) throws DOMException {
        throw new RuntimeException("Can not call setPrefix() on node type " + this.getNodeType());
    }

    public String getLocalName() {
        throw new RuntimeException("Can not call getLocalName() on node type " + this.getNodeType());
    }

    public boolean hasAttributes() {
        throw new RuntimeException("Can not call hasAttributes() on node type " + this.getNodeType());
    }

    public int getType() {
        if (this.document == null) {
            return 6;
        }
        short type = this.getNodeType();
        switch (type) {
            case 9: {
                return 6;
            }
            case 8: {
                return 5;
            }
            case 7: {
                return 4;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 501;
            }
        }
        return -1;
    }

    public String getStringValue() {
        short level = this.document.treeLevel[this.nodeNumber];
        StringBuffer buf = null;
        for (int next = this.nodeNumber + 1; next < this.document.size && this.document.treeLevel[next] > level; ++next) {
            if (this.document.nodeKind[next] == 3) {
                if (buf == null) {
                    buf = new StringBuffer();
                }
                buf.append(this.document.characters, this.document.alpha[next], this.document.alphaLen[next]);
                continue;
            }
            if (this.document.nodeKind[next] != 100) continue;
            if (buf == null) {
                buf = new StringBuffer();
            }
            buf.append(this.document.references[this.document.alpha[next]].getStringValue());
        }
        return buf == null ? "" : buf.toString();
    }

    public Sequence toSequence() {
        return this;
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        return new StringValue(this.getStringValue()).convertTo(requiredType);
    }

    public AtomicValue atomize() throws XPathException {
        return new UntypedAtomicValue(this.getStringValue());
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean hasOne() {
        return true;
    }

    public boolean hasMany() {
        return false;
    }

    public void add(Item item) throws XPathException {
        throw new RuntimeException("Can not call add() on node type " + this.getNodeType());
    }

    public void addAll(Sequence other) throws XPathException {
        throw new RuntimeException("Can not call addAll() on node type " + this.getNodeType());
    }

    public int getItemType() {
        return -1;
    }

    public SequenceIterator iterate() throws XPathException {
        return new SingleNodeIterator(this);
    }

    public SequenceIterator unorderedIterator() {
        return new SingleNodeIterator(this);
    }

    public int getItemCount() {
        return 1;
    }

    public int getLength() {
        throw new RuntimeException("Can not call getLength() on node type " + this.getNodeType());
    }

    public int getCardinality() {
        return 2;
    }

    public Item itemAt(int pos) {
        return pos == 0 ? this : null;
    }

    public boolean effectiveBooleanValue() throws XPathException {
        return true;
    }

    public NodeSet toNodeSet() throws XPathException {
        ValueSequence seq = new ValueSequence();
        seq.add(this);
        return seq.toNodeSet();
    }

    public void toSAX(DBBroker broker, ContentHandler handler, Properties properties) throws SAXException {
        DOMStreamer streamer = null;
        try {
            Serializer serializer = broker.getSerializer();
            serializer.reset();
            serializer.setProperty("sax-document-events", "false");
            if (properties != null) {
                serializer.setProperties(properties);
            }
            serializer.setSAXHandlers(handler, null);
            streamer = SerializerPool.getInstance().borrowDOMStreamer(serializer);
            streamer.setContentHandler(handler);
            if (handler instanceof LexicalHandler) {
                streamer.setLexicalHandler((LexicalHandler)((Object)handler));
            }
            streamer.serialize(this, false);
            if (streamer != null) {
                SerializerPool.getInstance().returnObject(streamer);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new SAXException(e);
            }
            catch (Throwable throwable) {
                if (streamer != null) {
                    SerializerPool.getInstance().returnObject(streamer);
                }
                throw throwable;
            }
        }
    }

    public void copyTo(DBBroker broker, DocumentBuilderReceiver receiver) throws SAXException {
        if (this.document != null) {
            this.document.copyTo(this, receiver);
        }
    }

    public void streamTo(Serializer serializer, Receiver receiver) throws SAXException {
        if (this.document != null) {
            this.document.streamTo(serializer, this, receiver);
        }
    }

    public int conversionPreference(Class javaClass) {
        if (javaClass.isAssignableFrom(NodeImpl.class)) {
            return 0;
        }
        if (javaClass.isAssignableFrom(Node.class)) {
            return 1;
        }
        if (javaClass == String.class || javaClass == CharSequence.class) {
            return 2;
        }
        if (javaClass == Character.class || javaClass == Character.TYPE) {
            return 2;
        }
        if (javaClass == Double.class || javaClass == Double.TYPE) {
            return 10;
        }
        if (javaClass == Float.class || javaClass == Float.TYPE) {
            return 11;
        }
        if (javaClass == Long.class || javaClass == Long.TYPE) {
            return 12;
        }
        if (javaClass == Integer.class || javaClass == Integer.TYPE) {
            return 13;
        }
        if (javaClass == Short.class || javaClass == Short.TYPE) {
            return 14;
        }
        if (javaClass == Byte.class || javaClass == Byte.TYPE) {
            return 15;
        }
        if (javaClass == Boolean.class || javaClass == Boolean.TYPE) {
            return 16;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        return Integer.MAX_VALUE;
    }

    public Object toJavaObject(Class target) throws XPathException {
        if (target.isAssignableFrom(NodeImpl.class)) {
            return this;
        }
        if (target.isAssignableFrom(Node.class)) {
            return this;
        }
        if (target == Object.class) {
            return this;
        }
        StringValue v = new StringValue(this.getStringValue());
        return v.toJavaObject(target);
    }

    public void setSelfAsContext(int contextId) {
        throw new RuntimeException("Can not call setSelfAsContext() on node type " + this.getNodeType());
    }

    public boolean isCached() {
        return false;
    }

    public void setIsCached(boolean cached) {
        throw new RuntimeException("Can not call setIsCached() on node type " + this.getNodeType());
    }

    public void removeDuplicates() {
    }

    public String getBaseURI() {
        return null;
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        throw new RuntimeException("Can not call compareDocumentPosition() on node type " + this.getNodeType());
    }

    public String getTextContent() throws DOMException {
        throw new RuntimeException("Can not call getTextContent() on node type " + this.getNodeType());
    }

    public void setTextContent(String textContent) throws DOMException {
        throw new RuntimeException("Can not call setTextContent() on node type " + this.getNodeType());
    }

    public boolean isSameNode(Node other) {
        throw new RuntimeException("Can not call isSameNode() on node type " + this.getNodeType());
    }

    public String lookupPrefix(String namespaceURI) {
        throw new RuntimeException("Can not call lookupPrefix() on node type " + this.getNodeType());
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        throw new RuntimeException("Can not call isDefaultNamespace() on node type " + this.getNodeType());
    }

    public String lookupNamespaceURI(String prefix) {
        throw new RuntimeException("Can not call lookupNamespaceURI() on node type " + this.getNodeType());
    }

    public boolean isEqualNode(Node arg) {
        throw new RuntimeException("Can not call isEqualNode() on node type " + this.getNodeType());
    }

    public Object getFeature(String feature, String version) {
        throw new RuntimeException("Can not call getFeature() on node type " + this.getNodeType());
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new RuntimeException("Can not call setUserData() on node type " + this.getNodeType());
    }

    public Object getUserData(String key) {
        throw new RuntimeException("Can not call getUserData() on node type " + this.getNodeType());
    }

    public boolean isPersistentSet() {
        return false;
    }

    public void nodeMoved(NodeId oldNodeId, StoredNode newNode) {
    }

    public void clearContext(int contextId) {
        throw new RuntimeException("Can not call clearContext() on node type " + this.getNodeType());
    }

    public int getState() {
        return 0;
    }

    public boolean isCacheable() {
        return true;
    }

    public boolean hasChanged(int previousState) {
        return false;
    }

    private static final class SingleNodeIterator
    implements SequenceIterator {
        NodeImpl node;

        public SingleNodeIterator(NodeImpl node) {
            this.node = node;
        }

        public boolean hasNext() {
            return this.node != null;
        }

        public Item nextItem() {
            NodeImpl next = this.node;
            this.node = null;
            return next;
        }
    }
}

