/*
 * Decompiled with CFR 0.152.
 */
package org.exist.management;

import org.apache.log4j.Logger;
import org.exist.management.Agent;
import org.exist.management.DummyAgent;

public class AgentFactory {
    private static final Logger LOG = Logger.getLogger((Class)AgentFactory.class);
    private static Agent instance = null;

    public static Agent getInstance() {
        if (instance == null) {
            String className = System.getProperty("exist.jmxagent", "org.exist.management.impl.JMXAgent");
            try {
                Class<?> clazz = Class.forName(className);
                if (!Agent.class.isAssignableFrom(clazz)) {
                    LOG.warn((Object)("Class " + className + " does not implement interface Agent. Using fallback."));
                } else {
                    instance = (Agent)clazz.newInstance();
                }
            }
            catch (ClassNotFoundException e) {
                LOG.warn((Object)("Class not found for JMX agent: " + className));
            }
            catch (IllegalAccessException e) {
                LOG.warn((Object)("Failed to instantiate class for JMX agent: " + className));
            }
            catch (InstantiationException e) {
                LOG.warn((Object)("Failed to instantiate class for JMX agent: " + className));
            }
            if (instance == null) {
                instance = new DummyAgent();
            }
        }
        return instance;
    }
}

