/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.exist.collections.Collection;
import org.exist.dom.AttrImpl;
import org.exist.dom.DocumentImpl;
import org.exist.dom.ElementImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.StoredNode;
import org.exist.dom.TextImpl;
import org.exist.indexing.IndexUtils;
import org.exist.indexing.IndexWorker;
import org.exist.indexing.MatchListener;
import org.exist.indexing.StreamListener;
import org.exist.storage.DBBroker;
import org.exist.storage.NodePath;
import org.exist.storage.txn.Txn;
import org.exist.util.DatabaseConfigurationException;
import org.w3c.dom.NodeList;

public class IndexController {
    protected Map indexWorkers = new HashMap();
    protected DBBroker broker;
    protected StreamListener listener = null;
    protected DocumentImpl currentDoc = null;
    protected int currentMode = -1;

    public IndexController(DBBroker broker) {
        this.broker = broker;
        IndexWorker[] workers = broker.getBrokerPool().getIndexManager().getWorkers(broker);
        for (int i = 0; i < workers.length; ++i) {
            this.indexWorkers.put(workers[i].getIndexId(), workers[i]);
        }
    }

    public void addIndexWorker(IndexWorker worker) {
        this.indexWorkers.put(worker.getIndexId(), worker);
    }

    public Map configure(NodeList configNodes, Map namespaces) throws DatabaseConfigurationException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator i = this.indexWorkers.values().iterator();
        while (i.hasNext()) {
            IndexWorker indexWorker = (IndexWorker)i.next();
            Object conf = indexWorker.configure(this, configNodes, namespaces);
            if (conf == null) continue;
            map.put(indexWorker.getIndexId(), conf);
        }
        return map;
    }

    public IndexWorker getWorkerByIndexId(String indexId) {
        return (IndexWorker)this.indexWorkers.get(indexId);
    }

    public IndexWorker getWorkerByIndexName(String indexName) {
        Iterator i = this.indexWorkers.values().iterator();
        while (i.hasNext()) {
            IndexWorker worker = (IndexWorker)i.next();
            if (!indexName.equals(worker.getIndexName())) continue;
            return worker;
        }
        return null;
    }

    public void setDocument(DocumentImpl doc) {
        if (this.currentDoc != doc) {
            this.listener = null;
        }
        this.currentDoc = doc;
        Iterator i = this.indexWorkers.values().iterator();
        while (i.hasNext()) {
            IndexWorker indexWorker = (IndexWorker)i.next();
            indexWorker.setDocument(this.currentDoc);
        }
    }

    public void setMode(int mode) {
        if (this.currentMode != mode) {
            this.listener = null;
        }
        this.currentMode = mode;
        Iterator i = this.indexWorkers.values().iterator();
        while (i.hasNext()) {
            IndexWorker indexWorker = (IndexWorker)i.next();
            indexWorker.setMode(this.currentMode);
        }
    }

    public DocumentImpl getDocument() {
        return this.currentDoc;
    }

    public int getMode() {
        return this.currentMode;
    }

    public void setDocument(DocumentImpl doc, int mode) {
        this.setDocument(doc);
        this.setMode(mode);
    }

    public void flush() {
        Iterator i = this.indexWorkers.values().iterator();
        while (i.hasNext()) {
            IndexWorker indexWorker = (IndexWorker)i.next();
            indexWorker.flush();
        }
    }

    public void removeCollection(Collection collection, DBBroker broker) {
        Iterator i = this.indexWorkers.values().iterator();
        while (i.hasNext()) {
            IndexWorker indexWorker = (IndexWorker)i.next();
            indexWorker.removeCollection(collection, broker);
        }
    }

    public void reindex(Txn transaction, StoredNode reindexRoot, int mode) {
        if (reindexRoot == null) {
            return;
        }
        reindexRoot = this.broker.objectWith(new NodeProxy(reindexRoot.getDocument(), reindexRoot.getNodeId()));
        this.setDocument(reindexRoot.getDocument(), mode);
        this.getStreamListener();
        IndexUtils.scanNode(this.broker, transaction, reindexRoot, this.listener);
        this.flush();
    }

    public StoredNode getReindexRoot(StoredNode node, NodePath path) {
        return this.getReindexRoot(node, path, false);
    }

    public StoredNode getReindexRoot(StoredNode node, NodePath path, boolean includeSelf) {
        StoredNode top = null;
        Iterator i = this.indexWorkers.values().iterator();
        while (i.hasNext()) {
            IndexWorker indexWorker = (IndexWorker)i.next();
            StoredNode next = indexWorker.getReindexRoot(node, path, includeSelf);
            if (next == null || top != null && !top.getNodeId().isDescendantOf(next.getNodeId())) continue;
            top = next;
        }
        if (top != null && top.getNodeId().equals(node.getNodeId())) {
            top = node;
        }
        return top;
    }

    public StreamListener getStreamListener() {
        if (this.listener != null) {
            for (StreamListener next = this.listener; next != null; next = next.getNextInChain()) {
            }
            return this.listener;
        }
        StreamListener first = null;
        StreamListener previous = null;
        Iterator i = this.indexWorkers.values().iterator();
        while (i.hasNext()) {
            IndexWorker worker = (IndexWorker)i.next();
            StreamListener current = worker.getListener();
            if (first == null) {
                first = current;
            } else if (current != null) {
                previous.setNextInChain(current);
            }
            if (current == null) continue;
            previous = current;
        }
        this.listener = first;
        return this.listener;
    }

    public void indexNode(Txn transaction, StoredNode node, NodePath path, StreamListener listener) {
        if (listener != null) {
            switch (node.getNodeType()) {
                case 1: {
                    listener.startElement(transaction, (ElementImpl)node, path);
                    break;
                }
                case 3: {
                    listener.characters(transaction, (TextImpl)node, path);
                    break;
                }
                case 2: {
                    listener.attribute(transaction, (AttrImpl)node, path);
                }
            }
        }
    }

    public void startElement(Txn transaction, ElementImpl node, NodePath path, StreamListener listener) {
        if (listener != null) {
            listener.startElement(transaction, node, path);
        }
    }

    public void endElement(Txn transaction, ElementImpl node, NodePath path, StreamListener listener) {
        if (listener != null) {
            listener.endElement(transaction, node, path);
        }
    }

    public void attribute(Txn transaction, AttrImpl node, NodePath path, StreamListener listener) {
        if (listener != null) {
            listener.attribute(transaction, node, path);
        }
    }

    public void characters(Txn transaction, TextImpl node, NodePath path, StreamListener listener) {
        if (listener != null) {
            listener.characters(transaction, node, path);
        }
    }

    public MatchListener getMatchListener(NodeProxy proxy) {
        MatchListener first = null;
        MatchListener previous = null;
        Iterator i = this.indexWorkers.values().iterator();
        while (i.hasNext()) {
            IndexWorker worker = (IndexWorker)i.next();
            MatchListener current = worker.getMatchListener(this.broker, proxy);
            if (current == null) continue;
            if (first == null) {
                first = current;
            } else {
                previous.setNextInChain(current);
            }
            previous = current;
        }
        return first;
    }
}

