/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.webdav.methods;

import java.io.IOException;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentMetadata;
import org.exist.dom.LockToken;
import org.exist.dom.QName;
import org.exist.http.webdav.WebDAV;
import org.exist.http.webdav.WebDAVUtil;
import org.exist.http.webdav.methods.AbstractWebDAVMethod;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.util.LockException;
import org.exist.util.MimeType;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Propfind
extends AbstractWebDAVMethod {
    private static final int FIND_ALL_PROPERTIES = 0;
    private static final int FIND_BY_PROPERTY = 1;
    private static final int FIND_PROPERTY_NAMES = 2;
    private static final SimpleDateFormat creationDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
    private static final SimpleDateFormat modificationDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    private static final String PREFIX = "D";
    private static final QName DISPLAY_NAME_PROP;
    private static final QName CREATION_DATE_PROP;
    private static final QName RESOURCE_TYPE_PROP;
    private static final QName CONTENT_TYPE_PROP;
    private static final QName CONTENT_LENGTH_PROP;
    private static final QName LAST_MODIFIED_PROP;
    private static final QName SUPPORTED_LOCK_PROP;
    private static final QName EXCLUSIVE_LOCK_PROP;
    private static final QName WRITE_LOCK_PROP;
    private static final QName ETAG_PROP;
    private static final QName STATUS_PROP;
    private static final QName COLLECTION_PROP;
    private static final QName LOCK_DISCOVERY_PROP;
    private static final QName ACTIVELOCK_PROP;
    private static final QName LOCKTYPE_PROP;
    private static final QName LOCK_SCOPE_PROP;
    private static final QName LOCK_DEPTH_PROP;
    private static final QName LOCK_OWNER_PROP;
    private static final QName LOCK_TIMEOUT_PROP;
    private static final QName LOCK_TOKEN_PROP;
    private static final QName[] DEFAULT_COLLECTION_PROPS;
    private static final QName[] DEFAULT_RESOURCE_PROPS;

    public Propfind(BrokerPool pool) {
        super(pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(User user, HttpServletRequest request, HttpServletResponse response, XmldbURI path) throws ServletException, IOException {
        DBBroker broker = null;
        Collection collection = null;
        DocumentImpl resource = null;
        try {
            DocumentBuilder docBuilder;
            broker = this.pool.get(user);
            collection = broker.openCollection(path, 0);
            if (collection == null) {
                XmldbURI docUri = path.lastSegment();
                XmldbURI collUri = path.removeLastSegment();
                collection = broker.openCollection(collUri, 0);
                if (collection == null) {
                    LOG.debug((Object)("No resource or collection found for path: " + path));
                    response.sendError(404, "No resource or collection found");
                    return;
                }
                resource = collection.getDocumentWithLock(broker, docUri, 0);
                if (resource == null) {
                    LOG.debug((Object)("No resource found for path: " + path));
                    response.sendError(404, "No resource or collection found");
                    return;
                }
            }
            if (!collection.getPermissions().validate(user, 4)) {
                response.sendError(403);
                return;
            }
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            try {
                docBuilder = docFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e1) {
                throw new ServletException("Failed to create XML parser: ", (Throwable)e1);
            }
            Document doc = WebDAVUtil.parseRequestContent(request, response, docBuilder);
            int type = 0;
            DAVProperties searchedProperties = new DAVProperties();
            if (doc != null) {
                Element propfind = doc.getDocumentElement();
                if (!propfind.getLocalName().equals("propfind") || !propfind.getNamespaceURI().equals("DAV:")) {
                    LOG.debug((Object)("Unexpected element found: " + propfind.getNodeName()));
                    response.sendError(400, "Unexpected element found: " + propfind.getNodeName());
                    return;
                }
                NodeList childNodes = propfind.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node currentNode = childNodes.item(i);
                    if (currentNode.getNodeType() != 1) continue;
                    if (currentNode.getNamespaceURI().equals("DAV:")) {
                        if (currentNode.getLocalName().equals("prop")) {
                            type = 1;
                            this.getPropertyNames(currentNode, searchedProperties);
                        }
                        if (currentNode.getLocalName().equals("allprop")) {
                            type = 0;
                        }
                        if (!currentNode.getLocalName().equals("propname")) continue;
                        type = 2;
                        continue;
                    }
                    LOG.debug((Object)("Unexpected child: " + currentNode.getNodeName()));
                    response.sendError(400, "Unexpected element found: " + currentNode.getNodeName());
                    return;
                }
            }
            String servletPath = this.getServletPath(request);
            int depth = this.getDepth(request);
            StringWriter os = new StringWriter();
            SAXSerializer serializer = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
            try {
                serializer.setOutput(os, WebDAV.OUTPUT_PROPERTIES);
                AttributesImpl attrs = new AttributesImpl();
                serializer.startDocument();
                serializer.startPrefixMapping(PREFIX, "DAV:");
                serializer.startElement("DAV:", "multistatus", "D:multistatus", attrs);
                if (type == 0 || type == 1) {
                    if (resource != null) {
                        this.writeResourceProperties(user, searchedProperties, type, collection, resource, serializer, servletPath);
                    } else {
                        this.writeCollectionProperties(user, broker, searchedProperties, type, collection, serializer, servletPath, depth, 0);
                    }
                } else if (type == 2) {
                    this.writePropertyNames(collection, resource, serializer, servletPath);
                }
                serializer.endElement("DAV:", "multistatus", "D:multistatus");
                serializer.endPrefixMapping(PREFIX);
                serializer.endDocument();
            }
            catch (SAXException e) {
                throw new ServletException("Exception while writing multistatus response: " + e.getMessage(), (Throwable)e);
            }
            finally {
                SerializerPool.getInstance().returnObject(serializer);
            }
            String content = os.toString();
            this.writeResponse(response, content);
        }
        catch (EXistException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        catch (LockException e) {
            response.sendError(500, e.getMessage());
        }
        finally {
            this.pool.release(broker);
            if (resource != null) {
                resource.getUpdateLock().release(0);
            }
            if (collection != null) {
                collection.release(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCollectionProperties(User user, DBBroker broker, DAVProperties searchedProperties, int type, Collection collection, SAXSerializer serializer, String servletPath, int maxDepth, int currentDepth) throws SAXException {
        List unvisited;
        if (!collection.getPermissions().validate(user, 4)) {
            return;
        }
        AttributesImpl attrs = new AttributesImpl();
        searchedProperties.reset();
        serializer.startElement("DAV:", "response", "D:response", attrs);
        serializer.startElement("DAV:", "href", "D:href", attrs);
        serializer.characters(servletPath + collection.getURI());
        serializer.endElement("DAV:", "href", "D:href");
        serializer.startElement("DAV:", "propstat", "D:propstat", attrs);
        serializer.startElement("DAV:", "prop", "D:prop", attrs);
        if (this.shouldIncludeProperty(type, searchedProperties, DISPLAY_NAME_PROP)) {
            String displayName = collection.getURI().lastSegment().toString();
            this.writeSimpleElement(DISPLAY_NAME_PROP, displayName, serializer);
        }
        if (this.shouldIncludeProperty(type, searchedProperties, RESOURCE_TYPE_PROP)) {
            serializer.startElement("DAV:", "resourcetype", "D:resourcetype", attrs);
            this.writeEmptyElement(COLLECTION_PROP, serializer);
            serializer.endElement("DAV:", "resourcetype", "D:resourcetype");
        }
        if (this.shouldIncludeProperty(type, searchedProperties, CREATION_DATE_PROP)) {
            long created = collection.getCreationTime();
            this.writeSimpleElement(CREATION_DATE_PROP, creationDateFormat.format(new Date(created)), serializer);
        }
        if (this.shouldIncludeProperty(type, searchedProperties, LAST_MODIFIED_PROP)) {
            long created = collection.getCreationTime();
            this.writeSimpleElement(LAST_MODIFIED_PROP, modificationDateFormat.format(new Date(created)), serializer);
        }
        serializer.endElement("DAV:", "prop", "D:prop");
        this.writeSimpleElement(STATUS_PROP, "HTTP/1.1 200 OK", serializer);
        serializer.endElement("DAV:", "propstat", "D:propstat");
        if (type == 1 && (unvisited = searchedProperties.unvisitedProperties()).size() > 0) {
            serializer.startElement("DAV:", "propstat", "D:propstat", attrs);
            serializer.startElement("DAV:", "prop", "D:prop", attrs);
            Iterator i = unvisited.iterator();
            while (i.hasNext()) {
                this.writeEmptyElement((QName)i.next(), serializer);
            }
            serializer.endElement("DAV:", "prop", "D:prop");
            this.writeSimpleElement(STATUS_PROP, "HTTP/1.1 404 Not Found", serializer);
            serializer.endElement("DAV:", "propstat", "D:propstat");
        }
        serializer.endElement("DAV:", "response", "D:response");
        if (currentDepth++ < maxDepth) {
            Iterator i;
            if (collection.getDocumentCount() > 0) {
                i = collection.iterator(broker);
                while (i.hasNext()) {
                    DocumentImpl doc = (DocumentImpl)i.next();
                    try {
                        doc.getUpdateLock().acquire(0);
                        this.writeResourceProperties(user, searchedProperties, type, collection, doc, serializer, servletPath);
                    }
                    catch (LockException e) {
                        LOG.debug((Object)("Failed to acquire lock on document " + doc.getURI()));
                    }
                    finally {
                        doc.getUpdateLock().release(0);
                    }
                }
            }
            if (collection.getChildCollectionCount() > 0) {
                i = collection.collectionIterator();
                while (i.hasNext()) {
                    XmldbURI child = (XmldbURI)i.next();
                    Collection childCollection = null;
                    try {
                        childCollection = broker.openCollection(collection.getURI().append(child), 0);
                        if (childCollection == null) continue;
                        this.writeCollectionProperties(user, broker, searchedProperties, type, childCollection, serializer, servletPath, maxDepth, currentDepth);
                    }
                    catch (Exception e) {}
                    continue;
                    finally {
                        if (childCollection != null) {
                            childCollection.release(0);
                        }
                    }
                }
            }
        }
    }

    private void writeResourceProperties(User user, DAVProperties searchedProperties, int type, Collection collection, DocumentImpl resource, SAXSerializer serializer, String servletPath) throws SAXException {
        List unvisited;
        if (!resource.getPermissions().validate(user, 4)) {
            return;
        }
        DocumentMetadata metadata = resource.getMetadata();
        AttributesImpl attrs = new AttributesImpl();
        searchedProperties.reset();
        serializer.startElement("DAV:", "response", "D:response", attrs);
        serializer.startElement("DAV:", "href", "D:href", attrs);
        serializer.characters(servletPath + collection.getURI().append(resource.getFileURI()).toString());
        serializer.endElement("DAV:", "href", "D:href");
        serializer.startElement("DAV:", "propstat", "D:propstat", attrs);
        serializer.startElement("DAV:", "prop", "D:prop", attrs);
        if (this.shouldIncludeProperty(type, searchedProperties, DISPLAY_NAME_PROP)) {
            this.writeSimpleElement(DISPLAY_NAME_PROP, resource.getFileURI().toString(), serializer);
        }
        if (this.shouldIncludeProperty(type, searchedProperties, RESOURCE_TYPE_PROP)) {
            this.writeEmptyElement(RESOURCE_TYPE_PROP, serializer);
        }
        if (this.shouldIncludeProperty(type, searchedProperties, CREATION_DATE_PROP)) {
            long created = metadata.getCreated();
            this.writeSimpleElement(CREATION_DATE_PROP, creationDateFormat.format(new Date(created)), serializer);
        }
        if (this.shouldIncludeProperty(type, searchedProperties, LAST_MODIFIED_PROP)) {
            long modified = metadata.getLastModified();
            this.writeSimpleElement(LAST_MODIFIED_PROP, modificationDateFormat.format(new Date(modified)), serializer);
        }
        if (this.shouldIncludeProperty(type, searchedProperties, CONTENT_LENGTH_PROP)) {
            this.writeSimpleElement(CONTENT_LENGTH_PROP, Long.toString(resource.getContentLength()), serializer);
        }
        if (this.shouldIncludeProperty(type, searchedProperties, CONTENT_TYPE_PROP)) {
            this.writeSimpleElement(CONTENT_TYPE_PROP, metadata.getMimeType(), serializer);
        }
        if (this.shouldIncludeProperty(type, searchedProperties, SUPPORTED_LOCK_PROP)) {
            serializer.startElement("DAV:", "supportedlock", "D:supportedlock", attrs);
            serializer.startElement("DAV:", "lockentry", "D:lockentry", attrs);
            serializer.startElement("DAV:", "lockscope", "D:lockscope", attrs);
            this.writeEmptyElement(EXCLUSIVE_LOCK_PROP, serializer);
            serializer.endElement("DAV:", "lockscope", "D:lockscope");
            serializer.startElement("DAV:", "locktype", "D:locktype", attrs);
            this.writeEmptyElement(WRITE_LOCK_PROP, serializer);
            serializer.endElement("DAV:", "locktype", "D:locktype");
            serializer.endElement("DAV:", "lockentry", "D:lockentry");
            serializer.endElement("DAV:", "supportedlock", "D:supportedlock");
        }
        if (this.shouldIncludeProperty(type, searchedProperties, LOCK_DISCOVERY_PROP)) {
            DocumentMetadata meta = resource.getMetadata();
            LockToken token = null;
            if (meta != null) {
                token = meta.getLockToken();
            } else {
                LOG.info((Object)"No Document meta data");
            }
            serializer.startElement("DAV:", "lockdiscovery", "D:lockdiscovery", attrs);
            if (token != null) {
                String lockDepth;
                String lockScope;
                String lockType;
                serializer.startElement("DAV:", "activelock", "D:activelock", attrs);
                switch (token.getType()) {
                    case 1: {
                        lockType = "write";
                        break;
                    }
                    default: {
                        lockType = "none";
                    }
                }
                this.writeSimpleElement(LOCKTYPE_PROP, lockType, serializer);
                switch (token.getScope()) {
                    case 1: {
                        lockScope = "exclusive";
                        break;
                    }
                    case 2: {
                        lockScope = "shared";
                        break;
                    }
                    default: {
                        lockScope = "none";
                    }
                }
                this.writeSimpleElement(LOCK_SCOPE_PROP, lockScope, serializer);
                switch (token.getDepth()) {
                    case 2: {
                        lockDepth = "Infinity";
                        break;
                    }
                    case 1: {
                        lockDepth = "1";
                        break;
                    }
                    case 0: {
                        lockDepth = "0";
                        break;
                    }
                    default: {
                        lockDepth = "none";
                    }
                }
                this.writeSimpleElement(LOCK_DEPTH_PROP, lockDepth, serializer);
                this.writeSimpleElement(LOCK_OWNER_PROP, token.getOwner(), serializer);
                this.writeSimpleElement(LOCK_TIMEOUT_PROP, "" + token.getTimeOut(), serializer);
                serializer.startElement("DAV:", "locktoken", "D:locktoken", attrs);
                serializer.startElement("DAV:", "href", "D:href", attrs);
                serializer.characters("opaquelocktoken:" + token.getOpaqueLockToken());
                serializer.endElement("DAV:", "href", "D:href");
                serializer.endElement("DAV:", "locktoken", "D:locktoken");
                serializer.endElement("DAV:", "activelock", "D:activelock");
            }
            serializer.endElement("DAV:", "lockdiscovery", "D:lockdiscovery");
        }
        serializer.endElement("DAV:", "prop", "D:prop");
        this.writeSimpleElement(STATUS_PROP, "HTTP/1.1 200 OK", serializer);
        serializer.endElement("DAV:", "propstat", "D:propstat");
        if (type == 1 && (unvisited = searchedProperties.unvisitedProperties()).size() > 0) {
            serializer.startElement("DAV:", "propstat", "D:propstat", attrs);
            serializer.startElement("DAV:", "prop", "D:prop", attrs);
            Iterator i = unvisited.iterator();
            while (i.hasNext()) {
                this.writeEmptyElement((QName)i.next(), serializer);
            }
            serializer.endElement("DAV:", "prop", "D:prop");
            this.writeSimpleElement(STATUS_PROP, "HTTP/1.1 404 Not Found", serializer);
            serializer.endElement("DAV:", "propstat", "D:propstat");
        }
        serializer.endElement("DAV:", "response", "D:response");
    }

    private void writePropertyNames(Collection collection, DocumentImpl resource, SAXSerializer serializer, String servletPath) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        serializer.startElement("DAV:", "response", "D:response", attrs);
        serializer.startElement("DAV:", "href", "D:href", attrs);
        String href = servletPath + (resource != null ? collection.getURI().toString() + "/" + resource.getFileURI() : collection.getURI().toString());
        serializer.characters(href);
        serializer.endElement("DAV:", "href", "D:href");
        serializer.startElement("DAV:", "propstat", "D:propstat", attrs);
        serializer.startElement("DAV:", "prop", "D:prop", attrs);
        QName[] defaults = resource == null ? DEFAULT_COLLECTION_PROPS : DEFAULT_RESOURCE_PROPS;
        for (int i = 0; i < defaults.length; ++i) {
            this.writeEmptyElement(defaults[i], serializer);
        }
        serializer.endElement("DAV:", "prop", "D:prop");
        this.writeSimpleElement(STATUS_PROP, "HTTP/1.1 200 OK", serializer);
        serializer.endElement("DAV:", "propstat", "D:propstat");
        serializer.endElement("DAV:", "response", "D:response");
    }

    private boolean shouldIncludeProperty(int type, DAVProperties properties, QName name) {
        if (type == 0) {
            return true;
        }
        return properties.includeProperty(name);
    }

    private void writeEmptyElement(QName qname, SAXSerializer serializer) throws SAXException {
        serializer.startElement("DAV:", qname.getLocalName(), qname.toString(), new AttributesImpl());
        serializer.endElement("DAV:", qname.getLocalName(), qname.toString());
    }

    private void writeSimpleElement(QName element, String content, SAXSerializer serializer) throws SAXException {
        serializer.startElement("DAV:", element.getLocalName(), element.toString(), new AttributesImpl());
        serializer.characters(content);
        serializer.endElement("DAV:", element.getLocalName(), element.toString());
    }

    private void writeResponse(HttpServletResponse response, String content) throws IOException {
        response.setStatus(207);
        response.setContentType(MimeType.XML_CONTENT_TYPE.getName());
        byte[] data = content.getBytes("UTF-8");
        response.setContentLength(data.length);
        ServletOutputStream os = response.getOutputStream();
        os.write(data);
        os.flush();
    }

    private String getServletPath(HttpServletRequest request) {
        String servletPath = request.getContextPath();
        if (servletPath.endsWith("/")) {
            servletPath = servletPath.substring(0, servletPath.length() - 1);
        }
        if ((servletPath = servletPath + request.getServletPath()).endsWith("/")) {
            servletPath = servletPath.substring(0, servletPath.length() - 1);
        }
        return servletPath;
    }

    protected int getDepth(HttpServletRequest req) {
        int depth = 1;
        String depthStr = req.getHeader("Depth");
        if (depthStr != null && depthStr.equals("0")) {
            depth = 0;
        }
        return depth;
    }

    private void getPropertyNames(Node propNode, DAVProperties properties) {
        NodeList childList = propNode.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node currentNode = childList.item(i);
            if (currentNode.getNodeType() != 1) continue;
            properties.add(currentNode);
        }
    }

    public static String xmlToString(Node node) {
        try {
            DOMSource source = new DOMSource(node);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
            return stringWriter.getBuffer().toString();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return null;
    }

    static {
        creationDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        modificationDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        DISPLAY_NAME_PROP = new QName("displayname", "DAV:", PREFIX);
        CREATION_DATE_PROP = new QName("creationdate", "DAV:", PREFIX);
        RESOURCE_TYPE_PROP = new QName("resourcetype", "DAV:", PREFIX);
        CONTENT_TYPE_PROP = new QName("getcontenttype", "DAV:", PREFIX);
        CONTENT_LENGTH_PROP = new QName("getcontentlength", "DAV:", PREFIX);
        LAST_MODIFIED_PROP = new QName("getlastmodified", "DAV:", PREFIX);
        SUPPORTED_LOCK_PROP = new QName("supportedlock", "DAV:", PREFIX);
        EXCLUSIVE_LOCK_PROP = new QName("exclusive", "DAV:", PREFIX);
        WRITE_LOCK_PROP = new QName("write", "DAV:", PREFIX);
        ETAG_PROP = new QName("etag", "DAV:", PREFIX);
        STATUS_PROP = new QName("status", "DAV:", PREFIX);
        COLLECTION_PROP = new QName("collection", "DAV:", PREFIX);
        LOCK_DISCOVERY_PROP = new QName("lockdiscovery", "DAV:", PREFIX);
        ACTIVELOCK_PROP = new QName("activelock", "DAV:", PREFIX);
        LOCKTYPE_PROP = new QName("activelock", "DAV:", PREFIX);
        LOCK_SCOPE_PROP = new QName("lockscope", "DAV:", PREFIX);
        LOCK_DEPTH_PROP = new QName("depth", "DAV:", PREFIX);
        LOCK_OWNER_PROP = new QName("owner", "DAV:", PREFIX);
        LOCK_TIMEOUT_PROP = new QName("timeout", "DAV:", PREFIX);
        LOCK_TOKEN_PROP = new QName("locktocken", "DAV:", PREFIX);
        DEFAULT_COLLECTION_PROPS = new QName[]{DISPLAY_NAME_PROP, RESOURCE_TYPE_PROP, CREATION_DATE_PROP, LAST_MODIFIED_PROP};
        DEFAULT_RESOURCE_PROPS = new QName[]{DISPLAY_NAME_PROP, RESOURCE_TYPE_PROP, CREATION_DATE_PROP, LAST_MODIFIED_PROP, CONTENT_TYPE_PROP, CONTENT_LENGTH_PROP, SUPPORTED_LOCK_PROP, LOCK_DISCOVERY_PROP};
    }

    private static class DAVProperties
    extends HashMap {
        DAVProperties() {
        }

        void add(Node node) {
            QName qname = new QName(node.getLocalName(), node.getNamespaceURI());
            if (node.getNamespaceURI().equals("DAV:")) {
                qname.setPrefix(Propfind.PREFIX);
            } else {
                qname.setPrefix(node.getPrefix());
            }
            if (!this.containsKey(qname)) {
                this.put(qname, new Visited());
            }
        }

        boolean includeProperty(QName property) {
            Visited visited = (Visited)this.get(property);
            if (visited == null) {
                return false;
            }
            boolean include = !visited.isVisited();
            visited.setVisited(true);
            return include;
        }

        List unvisitedProperties() {
            ArrayList list = new ArrayList(5);
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                if (((Visited)entry.getValue()).visited) continue;
                list.add(entry.getKey());
            }
            return list;
        }

        void reset() {
            Iterator i = this.values().iterator();
            while (i.hasNext()) {
                Visited visited = (Visited)i.next();
                visited.setVisited(false);
            }
        }
    }

    private static class Visited {
        boolean visited = false;

        private Visited() {
        }

        boolean isVisited() {
            return this.visited;
        }

        void setVisited(boolean visit) {
            this.visited = visit;
        }
    }
}

