/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.webdav.methods;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.http.webdav.methods.AbstractWebDAVMethod;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.xmldb.XmldbURI;

public class Mkcol
extends AbstractWebDAVMethod {
    public Mkcol(BrokerPool pool) {
        super(pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(User user, HttpServletRequest request, HttpServletResponse response, XmldbURI path) throws ServletException, IOException {
        if (path == null || path.equals("")) {
            response.sendError(405, "no path specified");
            return;
        }
        DBBroker broker = null;
        Collection collection = null;
        try {
            block24: {
                broker = this.pool.get(user);
                try {
                    collection = broker.openCollection(path, 0);
                    if (collection != null) {
                        response.sendError(405, "collection " + request.getPathInfo() + " already exists");
                        return;
                    }
                }
                finally {
                    if (collection != null) {
                        collection.release(0);
                    }
                }
                XmldbURI parentURI = path.removeLastSegment();
                if (parentURI == null) {
                    parentURI = XmldbURI.ROOT_COLLECTION_URI;
                }
                XmldbURI collURI = path.lastSegment();
                collection = broker.openCollection(parentURI, 1);
                if (collection == null) {
                    LOG.debug((Object)("Parent collection " + parentURI + " not found"));
                    response.sendError(409, "Parent collection not found");
                    return;
                }
                if (!collection.hasDocument(collURI)) break block24;
                response.sendError(405, "path conflicts with an existing resource");
                return;
                finally {
                    if (collection != null) {
                        collection.release(1);
                    }
                }
            }
            TransactionManager transact = this.pool.getTransactionManager();
            Txn txn = transact.beginTransaction();
            try {
                Collection created = broker.getOrCreateCollection(txn, path);
                broker.saveCollection(txn, created);
                broker.flush();
                transact.commit(txn);
            }
            catch (PermissionDeniedException e) {
                transact.abort(txn);
                response.sendError(403, e.getMessage());
            }
            LOG.debug((Object)("Created collection " + path));
            response.setStatus(201);
        }
        catch (EXistException e) {
            throw new ServletException("Database error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }
}

