/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.exist.memtree.SAXAdapter;
import org.exist.util.ConfigurationHelper;
import org.exist.util.SingleInstanceConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class Descriptor
implements ErrorHandler {
    private static final String SYSTEM_LINE_SEPARATOR = System.getProperty("line.separator");
    private static Descriptor singletonRef;
    private static final Logger LOG;
    private static final String file = "descriptor.xml";
    private BufferedWriter bufWriteReplayLog = null;
    private String[] allowSourceXQueryList = null;
    private String[][] mapList = null;

    private Descriptor() {
        try {
            NodeList maps;
            NodeList allowsourcexqueries;
            InputStream is = null;
            File f = ConfigurationHelper.lookup(file);
            if (!f.canRead()) {
                LOG.warn((Object)("Giving up unable to read descriptor file from " + f));
            } else {
                is = new FileInputStream(f);
                LOG.info((Object)("Reading Descriptor from file " + f));
            }
            if (is == null) {
                is = Descriptor.class.getResourceAsStream(file);
                if (is != null) {
                    LOG.info((Object)("Reading Descriptor from classloader in " + this.getClass().getPackage()));
                } else {
                    LOG.warn((Object)("Giving up unable to read descriptor.xml file from classloader in " + this.getClass().getPackage()));
                    return;
                }
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            InputSource src = new InputSource(is);
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            SAXAdapter adapter = new SAXAdapter();
            reader.setContentHandler(adapter);
            reader.parse(src);
            Document doc = adapter.getDocument();
            if (doc.getDocumentElement().getAttribute("request-replay-log").equals("true")) {
                File logFile = new File("request-replay-log.txt");
                this.bufWriteReplayLog = new BufferedWriter(new FileWriter(logFile));
            }
            if ((allowsourcexqueries = doc.getElementsByTagName("allow-source")).getLength() > 0) {
                this.configureAllowSourceXQuery((Element)allowsourcexqueries.item(0));
            }
            if ((maps = doc.getElementsByTagName("maps")).getLength() > 0) {
                this.configureMaps((Element)maps.item(0));
            }
        }
        catch (SAXException e) {
            LOG.warn((Object)"Error while reading descriptor file: descriptor.xml", (Throwable)e);
            return;
        }
        catch (ParserConfigurationException cfg) {
            LOG.warn((Object)"Error while reading descriptor file: descriptor.xml", (Throwable)cfg);
            return;
        }
        catch (IOException io) {
            LOG.warn((Object)"Error while reading descriptor file: descriptor.xml", (Throwable)io);
            return;
        }
    }

    public static synchronized Descriptor getDescriptorSingleton() {
        if (singletonRef == null) {
            singletonRef = new Descriptor();
        }
        return singletonRef;
    }

    private void configureAllowSourceXQuery(Element allowsourcexqueries) {
        NodeList nlXQuery = allowsourcexqueries.getElementsByTagName("xquery");
        this.allowSourceXQueryList = new String[nlXQuery.getLength()];
        Element elem = null;
        for (int i = 0; i < nlXQuery.getLength(); ++i) {
            elem = (Element)nlXQuery.item(i);
            String path = elem.getAttribute("path");
            if (path == null) {
                LOG.warn((Object)"Error element 'xquery' requires an attribute 'path'");
                return;
            }
            this.allowSourceXQueryList[i] = path = path.replaceAll("\\$\\{WEBAPP_HOME\\}", SingleInstanceConfiguration.getWebappHome().getAbsolutePath().replace('\\', '/'));
        }
    }

    private void configureMaps(Element maps) {
        NodeList nlMap = maps.getElementsByTagName("map");
        this.mapList = new String[nlMap.getLength()][2];
        Element elem = null;
        for (int i = 0; i < nlMap.getLength(); ++i) {
            elem = (Element)nlMap.item(i);
            String path = elem.getAttribute("path");
            String view = elem.getAttribute("view");
            if (path == null) {
                LOG.warn((Object)"Error element 'map' requires an attribute 'path' or an attribute 'pattern'");
                return;
            }
            path = path.replaceAll("\\$\\{WEBAPP_HOME\\}", SingleInstanceConfiguration.getWebappHome().getAbsolutePath().replace('\\', '/'));
            if (view == null) {
                LOG.warn((Object)"Error element 'map' requires an attribute 'view'");
                return;
            }
            view = view.replaceAll("\\$\\{WEBAPP_HOME\\}", SingleInstanceConfiguration.getWebappHome().getAbsolutePath().replace('\\', '/'));
            this.mapList[i][0] = path;
            this.mapList[i][1] = view;
        }
    }

    public boolean allowSourceXQuery(String path) {
        if (this.allowSourceXQueryList != null) {
            for (int i = 0; i < this.allowSourceXQueryList.length; ++i) {
                if (!this.allowSourceXQueryList[i].equals(path = path.replace('\\', '/')) && path.indexOf(this.allowSourceXQueryList[i]) <= -1) continue;
                return true;
            }
        }
        return false;
    }

    public String mapPath(String path) {
        if (this.mapList == null) {
            return path;
        }
        for (int i = 0; i < this.mapList.length; ++i) {
            if (!this.mapList[i][0].equals(path) && !new String(this.mapList[i][0] + "/").equals(path)) continue;
            return this.mapList[i][1];
        }
        return path;
    }

    public boolean allowRequestLogging() {
        return this.bufWriteReplayLog != null;
    }

    public synchronized void doLogRequestInReplayLog(HttpServletRequest request) {
        if (this.bufWriteReplayLog == null) {
            return;
        }
        try {
            this.bufWriteReplayLog.write("Date: ");
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            this.bufWriteReplayLog.write(formatter.format(new Date()));
            this.bufWriteReplayLog.write(SYSTEM_LINE_SEPARATOR);
            String requestAsString = request.toString();
            this.bufWriteReplayLog.write(requestAsString.substring(requestAsString.indexOf(SYSTEM_LINE_SEPARATOR) + 1));
            this.bufWriteReplayLog.write(SYSTEM_LINE_SEPARATOR);
            this.bufWriteReplayLog.flush();
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Could not write request replay log: " + ioe));
            return;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void error(SAXParseException exception) throws SAXException {
        System.err.println("Error occured while reading descriptor file [line: " + exception.getLineNumber() + "]:" + exception.getMessage());
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        System.err.println("Error occured while reading descriptor file [line: " + exception.getLineNumber() + "]:" + exception.getMessage());
    }

    public void warning(SAXParseException exception) throws SAXException {
        System.err.println("error occured while reading descriptor file [line: " + exception.getLineNumber() + "]:" + exception.getMessage());
    }

    static {
        LOG = Logger.getLogger((Class)Descriptor.class);
    }
}

