/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import org.exist.util.XMLChar;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;

public class QName
implements Comparable {
    public static final QName EMPTY_QNAME;
    public static final QName DOCUMENT_QNAME;
    public static final QName TEXT_QNAME;
    public static final QName COMMENT_QNAME;
    public static final QName DOCTYPE_QNAME;
    private String localName_ = null;
    private String namespaceURI_ = null;
    private String prefix_ = null;
    private byte nameType_ = 0;

    public QName(String localName, String namespaceURI, String prefix) {
        this.localName_ = localName;
        this.namespaceURI_ = namespaceURI == null ? "" : namespaceURI;
        this.prefix_ = prefix;
    }

    public QName(String localName, String namespaceURI) {
        this(localName, namespaceURI, null);
    }

    public QName(QName other) {
        this(other.localName_, other.namespaceURI_, other.prefix_);
        this.nameType_ = other.nameType_;
    }

    public QName(String name) {
        this(QName.extractLocalName(name), null, QName.extractPrefix(name));
    }

    public String getLocalName() {
        return this.localName_;
    }

    public void setLocalName(String name) {
        this.localName_ = name;
    }

    public String getNamespaceURI() {
        return this.namespaceURI_;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI_ = namespaceURI;
    }

    public boolean needsNamespaceDecl() {
        return this.namespaceURI_ != null && this.namespaceURI_.length() > 0;
    }

    public String getPrefix() {
        return this.prefix_;
    }

    public void setPrefix(String prefix) {
        this.prefix_ = prefix;
    }

    public void setNameType(byte type) {
        this.nameType_ = type;
    }

    public byte getNameType() {
        return this.nameType_;
    }

    public String getStringValue() {
        if (this.prefix_ != null && this.prefix_.length() > 0) {
            return this.prefix_ + ':' + this.localName_;
        }
        return this.localName_;
    }

    public String toString() {
        if (this.prefix_ != null && this.prefix_.length() > 0) {
            return this.prefix_ + ':' + this.localName_;
        }
        return this.localName_;
    }

    public int compareTo(Object o) {
        QName other = (QName)o;
        if (this.nameType_ != other.nameType_) {
            return this.nameType_ < other.nameType_ ? -1 : 1;
        }
        int c = this.namespaceURI_ == null ? (other.namespaceURI_ == null ? 0 : -1) : (other.namespaceURI_ == null ? 1 : this.namespaceURI_.compareTo(other.namespaceURI_));
        return c == 0 ? this.localName_.compareTo(other.localName_) : c;
    }

    public boolean equals(Object obj) {
        int cmp = this.compareTo(obj);
        if (cmp != 0) {
            return false;
        }
        QName other = (QName)obj;
        if (this.prefix_ == null) {
            return other.prefix_ == null;
        }
        if (other.prefix_ == null) {
            return false;
        }
        return this.prefix_.equals(other.prefix_);
    }

    public boolean equalsSimple(QName other) {
        int c = this.namespaceURI_ == null ? (other.namespaceURI_ == null ? 0 : -1) : (other.namespaceURI_ == null ? 1 : this.namespaceURI_.compareTo(other.namespaceURI_));
        if (c == 0) {
            return this.localName_.equals(other.localName_);
        }
        return false;
    }

    public int hashCode() {
        int h = this.nameType_ + 31 + this.localName_.hashCode();
        h += 31 * h + (this.namespaceURI_ == null ? 1 : this.namespaceURI_.hashCode());
        h += 31 * h + (this.prefix_ == null ? 1 : this.prefix_.hashCode());
        return h;
    }

    public javax.xml.namespace.QName toJavaQName() {
        return new javax.xml.namespace.QName(this.namespaceURI_ == null ? "" : this.namespaceURI_, this.localName_, this.prefix_ == null ? "" : this.prefix_);
    }

    public static String extractPrefix(String qname) throws IllegalArgumentException {
        int p = qname.indexOf(58);
        if (p == -1) {
            return null;
        }
        if (p == 0) {
            throw new IllegalArgumentException("Illegal QName: starts with a :");
        }
        if (Character.isDigit(qname.substring(0, 1).charAt(0))) {
            throw new IllegalArgumentException("Illegal QName: starts with a digit");
        }
        return qname.substring(0, p);
    }

    public static String extractLocalName(String qname) throws IllegalArgumentException {
        int p = qname.indexOf(58);
        if (p == -1) {
            return qname;
        }
        if (p == 0) {
            throw new IllegalArgumentException("Illegal QName: starts with a :");
        }
        if (p == qname.length()) {
            throw new IllegalArgumentException("Illegal QName: ends with a :");
        }
        if (!QName.isQName(qname)) {
            throw new IllegalArgumentException("Illegal QName: not a valid local name.");
        }
        return qname.substring(p + 1);
    }

    public static QName parse(XQueryContext context, String qname, String defaultNS) throws XPathException {
        String namespaceURI;
        String prefix = QName.extractPrefix(qname);
        if (prefix != null) {
            namespaceURI = context.getURIForPrefix(prefix);
            if (namespaceURI == null) {
                throw new XPathException("XPST0081: No namespace defined for prefix " + prefix);
            }
        } else {
            namespaceURI = defaultNS;
        }
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        return new QName(QName.extractLocalName(qname), namespaceURI, prefix);
    }

    public static QName parse(XQueryContext context, String qname) throws XPathException {
        return QName.parse(context, qname, context.getURIForPrefix(""));
    }

    public static final boolean isQName(String name) {
        int colon = name.indexOf(58);
        if (colon == -1) {
            return XMLChar.isValidNCName(name);
        }
        if (colon == 0 || colon == name.length() - 1) {
            return false;
        }
        if (!XMLChar.isValidNCName(name.substring(0, colon))) {
            return false;
        }
        return XMLChar.isValidNCName(name.substring(colon + 1));
    }

    static {
        DOCUMENT_QNAME = EMPTY_QNAME = new QName("", "", null);
        TEXT_QNAME = EMPTY_QNAME;
        COMMENT_QNAME = EMPTY_QNAME;
        DOCTYPE_QNAME = EMPTY_QNAME;
    }
}

